/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import org.apache.camel.Component;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.amqp.AMQPComponent;
import org.apache.camel.component.jms.ConsumerType;
import org.apache.camel.component.jms.DefaultTaskExecutorType;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsKeyFormatStrategy;
import org.apache.camel.component.jms.JmsMessageType;
import org.apache.camel.component.jms.MessageCreatedStrategy;
import org.apache.camel.component.jms.MessageListenerContainerFactory;
import org.apache.camel.component.jms.QueueBrowseStrategy;
import org.apache.camel.component.jms.ReplyToType;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ErrorHandler;

public interface AmqpComponentBuilderFactory {
    public static AmqpComponentBuilder amqp() {
        return new AmqpComponentBuilderImpl();
    }

    public static class AmqpComponentBuilderImpl
    extends AbstractComponentBuilder<AMQPComponent>
    implements AmqpComponentBuilder {
        @Override
        protected AMQPComponent buildConcreteComponent() {
            return new AMQPComponent();
        }

        private JmsConfiguration getOrCreateConfiguration(AMQPComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new JmsConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "clientId": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setClientId((String)value);
                    return true;
                }
                case "connectionFactory": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setConnectionFactory((ConnectionFactory)value);
                    return true;
                }
                case "disableReplyTo": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setDisableReplyTo(((Boolean)value).booleanValue());
                    return true;
                }
                case "durableSubscriptionName": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setDurableSubscriptionName((String)value);
                    return true;
                }
                case "includeAmqpAnnotations": {
                    ((AMQPComponent)component).setIncludeAmqpAnnotations(((Boolean)value).booleanValue());
                    return true;
                }
                case "jmsMessageType": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setJmsMessageType((JmsMessageType)value);
                    return true;
                }
                case "replyTo": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setReplyTo((String)value);
                    return true;
                }
                case "testConnectionOnStartup": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setTestConnectionOnStartup(((Boolean)value).booleanValue());
                    return true;
                }
                case "acknowledgementModeName": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setAcknowledgementModeName((String)value);
                    return true;
                }
                case "asyncConsumer": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setAsyncConsumer(((Boolean)value).booleanValue());
                    return true;
                }
                case "autoStartup": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setAutoStartup(((Boolean)value).booleanValue());
                    return true;
                }
                case "cacheLevel": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setCacheLevel(((Integer)value).intValue());
                    return true;
                }
                case "cacheLevelName": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setCacheLevelName((String)value);
                    return true;
                }
                case "concurrentConsumers": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setConcurrentConsumers(((Integer)value).intValue());
                    return true;
                }
                case "maxConcurrentConsumers": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setMaxConcurrentConsumers(((Integer)value).intValue());
                    return true;
                }
                case "replyToDeliveryPersistent": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setReplyToDeliveryPersistent(((Boolean)value).booleanValue());
                    return true;
                }
                case "selector": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setSelector((String)value);
                    return true;
                }
                case "subscriptionDurable": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setSubscriptionDurable(((Boolean)value).booleanValue());
                    return true;
                }
                case "subscriptionName": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setSubscriptionName((String)value);
                    return true;
                }
                case "subscriptionShared": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setSubscriptionShared(((Boolean)value).booleanValue());
                    return true;
                }
                case "acceptMessagesWhileStopping": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setAcceptMessagesWhileStopping(((Boolean)value).booleanValue());
                    return true;
                }
                case "allowReplyManagerQuickStop": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setAllowReplyManagerQuickStop(((Boolean)value).booleanValue());
                    return true;
                }
                case "consumerType": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setConsumerType((ConsumerType)value);
                    return true;
                }
                case "defaultTaskExecutorType": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setDefaultTaskExecutorType((DefaultTaskExecutorType)value);
                    return true;
                }
                case "eagerLoadingOfProperties": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setEagerLoadingOfProperties(((Boolean)value).booleanValue());
                    return true;
                }
                case "eagerPoisonBody": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setEagerPoisonBody((String)value);
                    return true;
                }
                case "exposeListenerSession": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setExposeListenerSession(((Boolean)value).booleanValue());
                    return true;
                }
                case "replyToSameDestinationAllowed": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setReplyToSameDestinationAllowed(((Boolean)value).booleanValue());
                    return true;
                }
                case "taskExecutor": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setTaskExecutor((TaskExecutor)value);
                    return true;
                }
                case "deliveryDelay": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setDeliveryDelay(((Long)value).longValue());
                    return true;
                }
                case "deliveryMode": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setDeliveryMode((Integer)value);
                    return true;
                }
                case "deliveryPersistent": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setDeliveryPersistent(((Boolean)value).booleanValue());
                    return true;
                }
                case "explicitQosEnabled": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setExplicitQosEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "formatDateHeadersToIso8601": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setFormatDateHeadersToIso8601(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((AMQPComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "preserveMessageQos": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setPreserveMessageQos(((Boolean)value).booleanValue());
                    return true;
                }
                case "priority": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setPriority(((Integer)value).intValue());
                    return true;
                }
                case "replyToConcurrentConsumers": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setReplyToConcurrentConsumers(((Integer)value).intValue());
                    return true;
                }
                case "replyToMaxConcurrentConsumers": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setReplyToMaxConcurrentConsumers(((Integer)value).intValue());
                    return true;
                }
                case "replyToOnTimeoutMaxConcurrentConsumers": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setReplyToOnTimeoutMaxConcurrentConsumers(((Integer)value).intValue());
                    return true;
                }
                case "replyToOverride": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setReplyToOverride((String)value);
                    return true;
                }
                case "replyToType": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setReplyToType((ReplyToType)value);
                    return true;
                }
                case "requestTimeout": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setRequestTimeout(((Long)value).longValue());
                    return true;
                }
                case "timeToLive": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setTimeToLive(((Long)value).longValue());
                    return true;
                }
                case "allowAdditionalHeaders": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setAllowAdditionalHeaders((String)value);
                    return true;
                }
                case "allowNullBody": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setAllowNullBody(((Boolean)value).booleanValue());
                    return true;
                }
                case "alwaysCopyMessage": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setAlwaysCopyMessage(((Boolean)value).booleanValue());
                    return true;
                }
                case "correlationProperty": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setCorrelationProperty((String)value);
                    return true;
                }
                case "disableTimeToLive": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setDisableTimeToLive(((Boolean)value).booleanValue());
                    return true;
                }
                case "forceSendOriginalMessage": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setForceSendOriginalMessage(((Boolean)value).booleanValue());
                    return true;
                }
                case "includeSentJMSMessageID": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setIncludeSentJMSMessageID(((Boolean)value).booleanValue());
                    return true;
                }
                case "replyToCacheLevelName": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setReplyToCacheLevelName((String)value);
                    return true;
                }
                case "replyToDestinationSelectorName": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setReplyToDestinationSelectorName((String)value);
                    return true;
                }
                case "streamMessageTypeEnabled": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setStreamMessageTypeEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "allowAutoWiredConnectionFactory": {
                    ((AMQPComponent)component).setAllowAutoWiredConnectionFactory(((Boolean)value).booleanValue());
                    return true;
                }
                case "allowAutoWiredDestinationResolver": {
                    ((AMQPComponent)component).setAllowAutoWiredDestinationResolver(((Boolean)value).booleanValue());
                    return true;
                }
                case "allowSerializedHeaders": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setAllowSerializedHeaders(((Boolean)value).booleanValue());
                    return true;
                }
                case "artemisStreamingEnabled": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setArtemisStreamingEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "asyncStartListener": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setAsyncStartListener(((Boolean)value).booleanValue());
                    return true;
                }
                case "asyncStopListener": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setAsyncStopListener(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((AMQPComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((AMQPComponent)component).setConfiguration((JmsConfiguration)value);
                    return true;
                }
                case "destinationResolver": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setDestinationResolver((DestinationResolver)value);
                    return true;
                }
                case "errorHandler": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setErrorHandler((ErrorHandler)value);
                    return true;
                }
                case "exceptionListener": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setExceptionListener((ExceptionListener)value);
                    return true;
                }
                case "idleConsumerLimit": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setIdleConsumerLimit(((Integer)value).intValue());
                    return true;
                }
                case "idleTaskExecutionLimit": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setIdleTaskExecutionLimit(((Integer)value).intValue());
                    return true;
                }
                case "includeAllJMSXProperties": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setIncludeAllJMSXProperties(((Boolean)value).booleanValue());
                    return true;
                }
                case "jmsKeyFormatStrategy": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setJmsKeyFormatStrategy((JmsKeyFormatStrategy)value);
                    return true;
                }
                case "mapJmsMessage": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setMapJmsMessage(((Boolean)value).booleanValue());
                    return true;
                }
                case "maxMessagesPerTask": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setMaxMessagesPerTask(((Integer)value).intValue());
                    return true;
                }
                case "messageConverter": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setMessageConverter((MessageConverter)value);
                    return true;
                }
                case "messageCreatedStrategy": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setMessageCreatedStrategy((MessageCreatedStrategy)value);
                    return true;
                }
                case "messageIdEnabled": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setMessageIdEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "messageListenerContainerFactory": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setMessageListenerContainerFactory((MessageListenerContainerFactory)value);
                    return true;
                }
                case "messageTimestampEnabled": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setMessageTimestampEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "pubSubNoLocal": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setPubSubNoLocal(((Boolean)value).booleanValue());
                    return true;
                }
                case "queueBrowseStrategy": {
                    ((AMQPComponent)component).setQueueBrowseStrategy((QueueBrowseStrategy)value);
                    return true;
                }
                case "receiveTimeout": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setReceiveTimeout(((Long)value).longValue());
                    return true;
                }
                case "recoveryInterval": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setRecoveryInterval(((Long)value).longValue());
                    return true;
                }
                case "requestTimeoutCheckerInterval": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setRequestTimeoutCheckerInterval(((Long)value).longValue());
                    return true;
                }
                case "transferException": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setTransferException(((Boolean)value).booleanValue());
                    return true;
                }
                case "transferExchange": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setTransferExchange(((Boolean)value).booleanValue());
                    return true;
                }
                case "useMessageIDAsCorrelationID": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setUseMessageIDAsCorrelationID(((Boolean)value).booleanValue());
                    return true;
                }
                case "waitForProvisionCorrelationToBeUpdatedCounter": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setWaitForProvisionCorrelationToBeUpdatedCounter(((Integer)value).intValue());
                    return true;
                }
                case "waitForProvisionCorrelationToBeUpdatedThreadSleepingTime": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setWaitForProvisionCorrelationToBeUpdatedThreadSleepingTime(((Long)value).longValue());
                    return true;
                }
                case "headerFilterStrategy": {
                    ((AMQPComponent)component).setHeaderFilterStrategy((HeaderFilterStrategy)value);
                    return true;
                }
                case "errorHandlerLoggingLevel": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setErrorHandlerLoggingLevel((LoggingLevel)value);
                    return true;
                }
                case "errorHandlerLogStackTrace": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setErrorHandlerLogStackTrace(((Boolean)value).booleanValue());
                    return true;
                }
                case "password": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setPassword((String)value);
                    return true;
                }
                case "username": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setUsername((String)value);
                    return true;
                }
                case "transacted": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setTransacted(((Boolean)value).booleanValue());
                    return true;
                }
                case "transactedInOut": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setTransactedInOut(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyCreateTransactionManager": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setLazyCreateTransactionManager(((Boolean)value).booleanValue());
                    return true;
                }
                case "transactionManager": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setTransactionManager((PlatformTransactionManager)value);
                    return true;
                }
                case "transactionName": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setTransactionName((String)value);
                    return true;
                }
                case "transactionTimeout": {
                    this.getOrCreateConfiguration((AMQPComponent)component).setTransactionTimeout(((Integer)value).intValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AmqpComponentBuilder
    extends ComponentBuilder<AMQPComponent> {
        default public AmqpComponentBuilder clientId(String clientId) {
            this.doSetProperty("clientId", clientId);
            return this;
        }

        default public AmqpComponentBuilder connectionFactory(ConnectionFactory connectionFactory) {
            this.doSetProperty("connectionFactory", connectionFactory);
            return this;
        }

        default public AmqpComponentBuilder disableReplyTo(boolean disableReplyTo) {
            this.doSetProperty("disableReplyTo", disableReplyTo);
            return this;
        }

        default public AmqpComponentBuilder durableSubscriptionName(String durableSubscriptionName) {
            this.doSetProperty("durableSubscriptionName", durableSubscriptionName);
            return this;
        }

        default public AmqpComponentBuilder includeAmqpAnnotations(boolean includeAmqpAnnotations) {
            this.doSetProperty("includeAmqpAnnotations", includeAmqpAnnotations);
            return this;
        }

        default public AmqpComponentBuilder jmsMessageType(JmsMessageType jmsMessageType) {
            this.doSetProperty("jmsMessageType", jmsMessageType);
            return this;
        }

        default public AmqpComponentBuilder replyTo(String replyTo) {
            this.doSetProperty("replyTo", replyTo);
            return this;
        }

        default public AmqpComponentBuilder testConnectionOnStartup(boolean testConnectionOnStartup) {
            this.doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }

        default public AmqpComponentBuilder acknowledgementModeName(String acknowledgementModeName) {
            this.doSetProperty("acknowledgementModeName", acknowledgementModeName);
            return this;
        }

        default public AmqpComponentBuilder asyncConsumer(boolean asyncConsumer) {
            this.doSetProperty("asyncConsumer", asyncConsumer);
            return this;
        }

        default public AmqpComponentBuilder autoStartup(boolean autoStartup) {
            this.doSetProperty("autoStartup", autoStartup);
            return this;
        }

        default public AmqpComponentBuilder cacheLevel(int cacheLevel) {
            this.doSetProperty("cacheLevel", cacheLevel);
            return this;
        }

        default public AmqpComponentBuilder cacheLevelName(String cacheLevelName) {
            this.doSetProperty("cacheLevelName", cacheLevelName);
            return this;
        }

        default public AmqpComponentBuilder concurrentConsumers(int concurrentConsumers) {
            this.doSetProperty("concurrentConsumers", concurrentConsumers);
            return this;
        }

        default public AmqpComponentBuilder maxConcurrentConsumers(int maxConcurrentConsumers) {
            this.doSetProperty("maxConcurrentConsumers", maxConcurrentConsumers);
            return this;
        }

        default public AmqpComponentBuilder replyToDeliveryPersistent(boolean replyToDeliveryPersistent) {
            this.doSetProperty("replyToDeliveryPersistent", replyToDeliveryPersistent);
            return this;
        }

        default public AmqpComponentBuilder selector(String selector) {
            this.doSetProperty("selector", selector);
            return this;
        }

        default public AmqpComponentBuilder subscriptionDurable(boolean subscriptionDurable) {
            this.doSetProperty("subscriptionDurable", subscriptionDurable);
            return this;
        }

        default public AmqpComponentBuilder subscriptionName(String subscriptionName) {
            this.doSetProperty("subscriptionName", subscriptionName);
            return this;
        }

        default public AmqpComponentBuilder subscriptionShared(boolean subscriptionShared) {
            this.doSetProperty("subscriptionShared", subscriptionShared);
            return this;
        }

        default public AmqpComponentBuilder acceptMessagesWhileStopping(boolean acceptMessagesWhileStopping) {
            this.doSetProperty("acceptMessagesWhileStopping", acceptMessagesWhileStopping);
            return this;
        }

        default public AmqpComponentBuilder allowReplyManagerQuickStop(boolean allowReplyManagerQuickStop) {
            this.doSetProperty("allowReplyManagerQuickStop", allowReplyManagerQuickStop);
            return this;
        }

        default public AmqpComponentBuilder consumerType(ConsumerType consumerType) {
            this.doSetProperty("consumerType", consumerType);
            return this;
        }

        default public AmqpComponentBuilder defaultTaskExecutorType(DefaultTaskExecutorType defaultTaskExecutorType) {
            this.doSetProperty("defaultTaskExecutorType", defaultTaskExecutorType);
            return this;
        }

        default public AmqpComponentBuilder eagerLoadingOfProperties(boolean eagerLoadingOfProperties) {
            this.doSetProperty("eagerLoadingOfProperties", eagerLoadingOfProperties);
            return this;
        }

        default public AmqpComponentBuilder eagerPoisonBody(String eagerPoisonBody) {
            this.doSetProperty("eagerPoisonBody", eagerPoisonBody);
            return this;
        }

        default public AmqpComponentBuilder exposeListenerSession(boolean exposeListenerSession) {
            this.doSetProperty("exposeListenerSession", exposeListenerSession);
            return this;
        }

        default public AmqpComponentBuilder replyToSameDestinationAllowed(boolean replyToSameDestinationAllowed) {
            this.doSetProperty("replyToSameDestinationAllowed", replyToSameDestinationAllowed);
            return this;
        }

        default public AmqpComponentBuilder taskExecutor(TaskExecutor taskExecutor) {
            this.doSetProperty("taskExecutor", taskExecutor);
            return this;
        }

        default public AmqpComponentBuilder deliveryDelay(long deliveryDelay) {
            this.doSetProperty("deliveryDelay", deliveryDelay);
            return this;
        }

        default public AmqpComponentBuilder deliveryMode(Integer deliveryMode) {
            this.doSetProperty("deliveryMode", deliveryMode);
            return this;
        }

        default public AmqpComponentBuilder deliveryPersistent(boolean deliveryPersistent) {
            this.doSetProperty("deliveryPersistent", deliveryPersistent);
            return this;
        }

        default public AmqpComponentBuilder explicitQosEnabled(Boolean explicitQosEnabled) {
            this.doSetProperty("explicitQosEnabled", explicitQosEnabled);
            return this;
        }

        default public AmqpComponentBuilder formatDateHeadersToIso8601(boolean formatDateHeadersToIso8601) {
            this.doSetProperty("formatDateHeadersToIso8601", formatDateHeadersToIso8601);
            return this;
        }

        default public AmqpComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AmqpComponentBuilder preserveMessageQos(boolean preserveMessageQos) {
            this.doSetProperty("preserveMessageQos", preserveMessageQos);
            return this;
        }

        default public AmqpComponentBuilder priority(int priority) {
            this.doSetProperty("priority", priority);
            return this;
        }

        default public AmqpComponentBuilder replyToConcurrentConsumers(int replyToConcurrentConsumers) {
            this.doSetProperty("replyToConcurrentConsumers", replyToConcurrentConsumers);
            return this;
        }

        default public AmqpComponentBuilder replyToMaxConcurrentConsumers(int replyToMaxConcurrentConsumers) {
            this.doSetProperty("replyToMaxConcurrentConsumers", replyToMaxConcurrentConsumers);
            return this;
        }

        default public AmqpComponentBuilder replyToOnTimeoutMaxConcurrentConsumers(int replyToOnTimeoutMaxConcurrentConsumers) {
            this.doSetProperty("replyToOnTimeoutMaxConcurrentConsumers", replyToOnTimeoutMaxConcurrentConsumers);
            return this;
        }

        default public AmqpComponentBuilder replyToOverride(String replyToOverride) {
            this.doSetProperty("replyToOverride", replyToOverride);
            return this;
        }

        default public AmqpComponentBuilder replyToType(ReplyToType replyToType) {
            this.doSetProperty("replyToType", replyToType);
            return this;
        }

        default public AmqpComponentBuilder requestTimeout(long requestTimeout) {
            this.doSetProperty("requestTimeout", requestTimeout);
            return this;
        }

        default public AmqpComponentBuilder timeToLive(long timeToLive) {
            this.doSetProperty("timeToLive", timeToLive);
            return this;
        }

        default public AmqpComponentBuilder allowAdditionalHeaders(String allowAdditionalHeaders) {
            this.doSetProperty("allowAdditionalHeaders", allowAdditionalHeaders);
            return this;
        }

        default public AmqpComponentBuilder allowNullBody(boolean allowNullBody) {
            this.doSetProperty("allowNullBody", allowNullBody);
            return this;
        }

        default public AmqpComponentBuilder alwaysCopyMessage(boolean alwaysCopyMessage) {
            this.doSetProperty("alwaysCopyMessage", alwaysCopyMessage);
            return this;
        }

        default public AmqpComponentBuilder correlationProperty(String correlationProperty) {
            this.doSetProperty("correlationProperty", correlationProperty);
            return this;
        }

        default public AmqpComponentBuilder disableTimeToLive(boolean disableTimeToLive) {
            this.doSetProperty("disableTimeToLive", disableTimeToLive);
            return this;
        }

        default public AmqpComponentBuilder forceSendOriginalMessage(boolean forceSendOriginalMessage) {
            this.doSetProperty("forceSendOriginalMessage", forceSendOriginalMessage);
            return this;
        }

        default public AmqpComponentBuilder includeSentJMSMessageID(boolean includeSentJMSMessageID) {
            this.doSetProperty("includeSentJMSMessageID", includeSentJMSMessageID);
            return this;
        }

        default public AmqpComponentBuilder replyToCacheLevelName(String replyToCacheLevelName) {
            this.doSetProperty("replyToCacheLevelName", replyToCacheLevelName);
            return this;
        }

        default public AmqpComponentBuilder replyToDestinationSelectorName(String replyToDestinationSelectorName) {
            this.doSetProperty("replyToDestinationSelectorName", replyToDestinationSelectorName);
            return this;
        }

        default public AmqpComponentBuilder streamMessageTypeEnabled(boolean streamMessageTypeEnabled) {
            this.doSetProperty("streamMessageTypeEnabled", streamMessageTypeEnabled);
            return this;
        }

        default public AmqpComponentBuilder allowAutoWiredConnectionFactory(boolean allowAutoWiredConnectionFactory) {
            this.doSetProperty("allowAutoWiredConnectionFactory", allowAutoWiredConnectionFactory);
            return this;
        }

        default public AmqpComponentBuilder allowAutoWiredDestinationResolver(boolean allowAutoWiredDestinationResolver) {
            this.doSetProperty("allowAutoWiredDestinationResolver", allowAutoWiredDestinationResolver);
            return this;
        }

        default public AmqpComponentBuilder allowSerializedHeaders(boolean allowSerializedHeaders) {
            this.doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }

        default public AmqpComponentBuilder artemisStreamingEnabled(boolean artemisStreamingEnabled) {
            this.doSetProperty("artemisStreamingEnabled", artemisStreamingEnabled);
            return this;
        }

        default public AmqpComponentBuilder asyncStartListener(boolean asyncStartListener) {
            this.doSetProperty("asyncStartListener", asyncStartListener);
            return this;
        }

        default public AmqpComponentBuilder asyncStopListener(boolean asyncStopListener) {
            this.doSetProperty("asyncStopListener", asyncStopListener);
            return this;
        }

        @Deprecated
        default public AmqpComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AmqpComponentBuilder configuration(JmsConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AmqpComponentBuilder destinationResolver(DestinationResolver destinationResolver) {
            this.doSetProperty("destinationResolver", destinationResolver);
            return this;
        }

        default public AmqpComponentBuilder errorHandler(ErrorHandler errorHandler) {
            this.doSetProperty("errorHandler", errorHandler);
            return this;
        }

        default public AmqpComponentBuilder exceptionListener(ExceptionListener exceptionListener) {
            this.doSetProperty("exceptionListener", exceptionListener);
            return this;
        }

        default public AmqpComponentBuilder idleConsumerLimit(int idleConsumerLimit) {
            this.doSetProperty("idleConsumerLimit", idleConsumerLimit);
            return this;
        }

        default public AmqpComponentBuilder idleTaskExecutionLimit(int idleTaskExecutionLimit) {
            this.doSetProperty("idleTaskExecutionLimit", idleTaskExecutionLimit);
            return this;
        }

        default public AmqpComponentBuilder includeAllJMSXProperties(boolean includeAllJMSXProperties) {
            this.doSetProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }

        default public AmqpComponentBuilder jmsKeyFormatStrategy(JmsKeyFormatStrategy jmsKeyFormatStrategy) {
            this.doSetProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }

        default public AmqpComponentBuilder mapJmsMessage(boolean mapJmsMessage) {
            this.doSetProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }

        default public AmqpComponentBuilder maxMessagesPerTask(int maxMessagesPerTask) {
            this.doSetProperty("maxMessagesPerTask", maxMessagesPerTask);
            return this;
        }

        default public AmqpComponentBuilder messageConverter(MessageConverter messageConverter) {
            this.doSetProperty("messageConverter", messageConverter);
            return this;
        }

        default public AmqpComponentBuilder messageCreatedStrategy(MessageCreatedStrategy messageCreatedStrategy) {
            this.doSetProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }

        default public AmqpComponentBuilder messageIdEnabled(boolean messageIdEnabled) {
            this.doSetProperty("messageIdEnabled", messageIdEnabled);
            return this;
        }

        default public AmqpComponentBuilder messageListenerContainerFactory(MessageListenerContainerFactory messageListenerContainerFactory) {
            this.doSetProperty("messageListenerContainerFactory", messageListenerContainerFactory);
            return this;
        }

        default public AmqpComponentBuilder messageTimestampEnabled(boolean messageTimestampEnabled) {
            this.doSetProperty("messageTimestampEnabled", messageTimestampEnabled);
            return this;
        }

        default public AmqpComponentBuilder pubSubNoLocal(boolean pubSubNoLocal) {
            this.doSetProperty("pubSubNoLocal", pubSubNoLocal);
            return this;
        }

        default public AmqpComponentBuilder queueBrowseStrategy(QueueBrowseStrategy queueBrowseStrategy) {
            this.doSetProperty("queueBrowseStrategy", queueBrowseStrategy);
            return this;
        }

        default public AmqpComponentBuilder receiveTimeout(long receiveTimeout) {
            this.doSetProperty("receiveTimeout", receiveTimeout);
            return this;
        }

        default public AmqpComponentBuilder recoveryInterval(long recoveryInterval) {
            this.doSetProperty("recoveryInterval", recoveryInterval);
            return this;
        }

        default public AmqpComponentBuilder requestTimeoutCheckerInterval(long requestTimeoutCheckerInterval) {
            this.doSetProperty("requestTimeoutCheckerInterval", requestTimeoutCheckerInterval);
            return this;
        }

        default public AmqpComponentBuilder transferException(boolean transferException) {
            this.doSetProperty("transferException", transferException);
            return this;
        }

        default public AmqpComponentBuilder transferExchange(boolean transferExchange) {
            this.doSetProperty("transferExchange", transferExchange);
            return this;
        }

        default public AmqpComponentBuilder useMessageIDAsCorrelationID(boolean useMessageIDAsCorrelationID) {
            this.doSetProperty("useMessageIDAsCorrelationID", useMessageIDAsCorrelationID);
            return this;
        }

        default public AmqpComponentBuilder waitForProvisionCorrelationToBeUpdatedCounter(int waitForProvisionCorrelationToBeUpdatedCounter) {
            this.doSetProperty("waitForProvisionCorrelationToBeUpdatedCounter", waitForProvisionCorrelationToBeUpdatedCounter);
            return this;
        }

        default public AmqpComponentBuilder waitForProvisionCorrelationToBeUpdatedThreadSleepingTime(long waitForProvisionCorrelationToBeUpdatedThreadSleepingTime) {
            this.doSetProperty("waitForProvisionCorrelationToBeUpdatedThreadSleepingTime", waitForProvisionCorrelationToBeUpdatedThreadSleepingTime);
            return this;
        }

        default public AmqpComponentBuilder headerFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
            this.doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }

        default public AmqpComponentBuilder errorHandlerLoggingLevel(LoggingLevel errorHandlerLoggingLevel) {
            this.doSetProperty("errorHandlerLoggingLevel", errorHandlerLoggingLevel);
            return this;
        }

        default public AmqpComponentBuilder errorHandlerLogStackTrace(boolean errorHandlerLogStackTrace) {
            this.doSetProperty("errorHandlerLogStackTrace", errorHandlerLogStackTrace);
            return this;
        }

        default public AmqpComponentBuilder password(String password) {
            this.doSetProperty("password", password);
            return this;
        }

        default public AmqpComponentBuilder username(String username) {
            this.doSetProperty("username", username);
            return this;
        }

        default public AmqpComponentBuilder transacted(boolean transacted) {
            this.doSetProperty("transacted", transacted);
            return this;
        }

        default public AmqpComponentBuilder transactedInOut(boolean transactedInOut) {
            this.doSetProperty("transactedInOut", transactedInOut);
            return this;
        }

        default public AmqpComponentBuilder lazyCreateTransactionManager(boolean lazyCreateTransactionManager) {
            this.doSetProperty("lazyCreateTransactionManager", lazyCreateTransactionManager);
            return this;
        }

        default public AmqpComponentBuilder transactionManager(PlatformTransactionManager transactionManager) {
            this.doSetProperty("transactionManager", transactionManager);
            return this;
        }

        default public AmqpComponentBuilder transactionName(String transactionName) {
            this.doSetProperty("transactionName", transactionName);
            return this;
        }

        default public AmqpComponentBuilder transactionTimeout(int transactionTimeout) {
            this.doSetProperty("transactionTimeout", transactionTimeout);
            return this;
        }
    }
}

