/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import io.atomix.Atomix;
import io.atomix.catalyst.transport.Address;
import io.atomix.resource.ReadConsistency;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.atomix.client.map.AtomixMap;
import org.apache.camel.component.atomix.client.map.AtomixMapComponent;
import org.apache.camel.component.atomix.client.map.AtomixMapConfiguration;

public interface AtomixMapComponentBuilderFactory {
    public static AtomixMapComponentBuilder atomixMap() {
        return new AtomixMapComponentBuilderImpl();
    }

    public static class AtomixMapComponentBuilderImpl
    extends AbstractComponentBuilder<AtomixMapComponent>
    implements AtomixMapComponentBuilder {
        @Override
        protected AtomixMapComponent buildConcreteComponent() {
            return new AtomixMapComponent();
        }

        private AtomixMapConfiguration getOrCreateConfiguration(AtomixMapComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new AtomixMapConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "atomix": {
                    this.getOrCreateConfiguration((AtomixMapComponent)component).setAtomix((Atomix)value);
                    return true;
                }
                case "configuration": {
                    ((AtomixMapComponent)component).setConfiguration((AtomixMapConfiguration)value);
                    return true;
                }
                case "configurationUri": {
                    ((AtomixMapComponent)component).setConfigurationUri((String)value);
                    return true;
                }
                case "defaultAction": {
                    this.getOrCreateConfiguration((AtomixMapComponent)component).setDefaultAction((AtomixMap.Action)value);
                    return true;
                }
                case "key": {
                    this.getOrCreateConfiguration((AtomixMapComponent)component).setKey(value);
                    return true;
                }
                case "nodes": {
                    ((AtomixMapComponent)component).setNodes((List)value);
                    return true;
                }
                case "resultHeader": {
                    this.getOrCreateConfiguration((AtomixMapComponent)component).setResultHeader((String)value);
                    return true;
                }
                case "transportClassName": {
                    this.getOrCreateConfiguration((AtomixMapComponent)component).setTransportClassName((String)value);
                    return true;
                }
                case "ttl": {
                    this.getOrCreateConfiguration((AtomixMapComponent)component).setTtl(((Long)value).longValue());
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((AtomixMapComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((AtomixMapComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((AtomixMapComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "defaultResourceConfig": {
                    this.getOrCreateConfiguration((AtomixMapComponent)component).setDefaultResourceConfig((Properties)value);
                    return true;
                }
                case "defaultResourceOptions": {
                    this.getOrCreateConfiguration((AtomixMapComponent)component).setDefaultResourceOptions((Properties)value);
                    return true;
                }
                case "ephemeral": {
                    this.getOrCreateConfiguration((AtomixMapComponent)component).setEphemeral(((Boolean)value).booleanValue());
                    return true;
                }
                case "readConsistency": {
                    this.getOrCreateConfiguration((AtomixMapComponent)component).setReadConsistency((ReadConsistency)value);
                    return true;
                }
                case "resourceConfigs": {
                    this.getOrCreateConfiguration((AtomixMapComponent)component).setResourceConfigs((Map)value);
                    return true;
                }
                case "resourceOptions": {
                    this.getOrCreateConfiguration((AtomixMapComponent)component).setResourceOptions((Map)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AtomixMapComponentBuilder
    extends ComponentBuilder<AtomixMapComponent> {
        default public AtomixMapComponentBuilder atomix(Atomix atomix) {
            this.doSetProperty("atomix", atomix);
            return this;
        }

        default public AtomixMapComponentBuilder configuration(AtomixMapConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AtomixMapComponentBuilder configurationUri(String configurationUri) {
            this.doSetProperty("configurationUri", configurationUri);
            return this;
        }

        default public AtomixMapComponentBuilder defaultAction(AtomixMap.Action defaultAction) {
            this.doSetProperty("defaultAction", defaultAction);
            return this;
        }

        default public AtomixMapComponentBuilder key(Object key) {
            this.doSetProperty("key", key);
            return this;
        }

        default public AtomixMapComponentBuilder nodes(List<Address> nodes) {
            this.doSetProperty("nodes", nodes);
            return this;
        }

        default public AtomixMapComponentBuilder resultHeader(String resultHeader) {
            this.doSetProperty("resultHeader", resultHeader);
            return this;
        }

        default public AtomixMapComponentBuilder transportClassName(String transportClassName) {
            this.doSetProperty("transportClassName", transportClassName);
            return this;
        }

        default public AtomixMapComponentBuilder ttl(long ttl) {
            this.doSetProperty("ttl", ttl);
            return this;
        }

        default public AtomixMapComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AtomixMapComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        @Deprecated
        default public AtomixMapComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AtomixMapComponentBuilder defaultResourceConfig(Properties defaultResourceConfig) {
            this.doSetProperty("defaultResourceConfig", defaultResourceConfig);
            return this;
        }

        default public AtomixMapComponentBuilder defaultResourceOptions(Properties defaultResourceOptions) {
            this.doSetProperty("defaultResourceOptions", defaultResourceOptions);
            return this;
        }

        default public AtomixMapComponentBuilder ephemeral(boolean ephemeral) {
            this.doSetProperty("ephemeral", ephemeral);
            return this;
        }

        default public AtomixMapComponentBuilder readConsistency(ReadConsistency readConsistency) {
            this.doSetProperty("readConsistency", readConsistency);
            return this;
        }

        default public AtomixMapComponentBuilder resourceConfigs(Map<String, Properties> resourceConfigs) {
            this.doSetProperty("resourceConfigs", resourceConfigs);
            return this;
        }

        default public AtomixMapComponentBuilder resourceOptions(Map<String, Properties> resourceOptions) {
            this.doSetProperty("resourceOptions", resourceOptions);
            return this;
        }
    }
}

