/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import io.atomix.Atomix;
import io.atomix.catalyst.transport.Address;
import io.atomix.resource.ReadConsistency;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.atomix.client.multimap.AtomixMultiMap;
import org.apache.camel.component.atomix.client.multimap.AtomixMultiMapComponent;
import org.apache.camel.component.atomix.client.multimap.AtomixMultiMapConfiguration;

public interface AtomixMultimapComponentBuilderFactory {
    public static AtomixMultimapComponentBuilder atomixMultimap() {
        return new AtomixMultimapComponentBuilderImpl();
    }

    public static class AtomixMultimapComponentBuilderImpl
    extends AbstractComponentBuilder<AtomixMultiMapComponent>
    implements AtomixMultimapComponentBuilder {
        @Override
        protected AtomixMultiMapComponent buildConcreteComponent() {
            return new AtomixMultiMapComponent();
        }

        private AtomixMultiMapConfiguration getOrCreateConfiguration(AtomixMultiMapComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new AtomixMultiMapConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "atomix": {
                    this.getOrCreateConfiguration((AtomixMultiMapComponent)component).setAtomix((Atomix)value);
                    return true;
                }
                case "configuration": {
                    ((AtomixMultiMapComponent)component).setConfiguration((AtomixMultiMapConfiguration)value);
                    return true;
                }
                case "configurationUri": {
                    ((AtomixMultiMapComponent)component).setConfigurationUri((String)value);
                    return true;
                }
                case "defaultAction": {
                    this.getOrCreateConfiguration((AtomixMultiMapComponent)component).setDefaultAction((AtomixMultiMap.Action)value);
                    return true;
                }
                case "key": {
                    this.getOrCreateConfiguration((AtomixMultiMapComponent)component).setKey(value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((AtomixMultiMapComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "nodes": {
                    ((AtomixMultiMapComponent)component).setNodes((List)value);
                    return true;
                }
                case "resultHeader": {
                    this.getOrCreateConfiguration((AtomixMultiMapComponent)component).setResultHeader((String)value);
                    return true;
                }
                case "transportClassName": {
                    this.getOrCreateConfiguration((AtomixMultiMapComponent)component).setTransportClassName((String)value);
                    return true;
                }
                case "ttl": {
                    this.getOrCreateConfiguration((AtomixMultiMapComponent)component).setTtl(((Long)value).longValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((AtomixMultiMapComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "defaultResourceConfig": {
                    this.getOrCreateConfiguration((AtomixMultiMapComponent)component).setDefaultResourceConfig((Properties)value);
                    return true;
                }
                case "defaultResourceOptions": {
                    this.getOrCreateConfiguration((AtomixMultiMapComponent)component).setDefaultResourceOptions((Properties)value);
                    return true;
                }
                case "ephemeral": {
                    this.getOrCreateConfiguration((AtomixMultiMapComponent)component).setEphemeral(((Boolean)value).booleanValue());
                    return true;
                }
                case "readConsistency": {
                    this.getOrCreateConfiguration((AtomixMultiMapComponent)component).setReadConsistency((ReadConsistency)value);
                    return true;
                }
                case "resourceConfigs": {
                    this.getOrCreateConfiguration((AtomixMultiMapComponent)component).setResourceConfigs((Map)value);
                    return true;
                }
                case "resourceOptions": {
                    this.getOrCreateConfiguration((AtomixMultiMapComponent)component).setResourceOptions((Map)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AtomixMultimapComponentBuilder
    extends ComponentBuilder<AtomixMultiMapComponent> {
        default public AtomixMultimapComponentBuilder atomix(Atomix atomix) {
            this.doSetProperty("atomix", atomix);
            return this;
        }

        default public AtomixMultimapComponentBuilder configuration(AtomixMultiMapConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AtomixMultimapComponentBuilder configurationUri(String configurationUri) {
            this.doSetProperty("configurationUri", configurationUri);
            return this;
        }

        default public AtomixMultimapComponentBuilder defaultAction(AtomixMultiMap.Action defaultAction) {
            this.doSetProperty("defaultAction", defaultAction);
            return this;
        }

        default public AtomixMultimapComponentBuilder key(Object key) {
            this.doSetProperty("key", key);
            return this;
        }

        default public AtomixMultimapComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AtomixMultimapComponentBuilder nodes(List<Address> nodes) {
            this.doSetProperty("nodes", nodes);
            return this;
        }

        default public AtomixMultimapComponentBuilder resultHeader(String resultHeader) {
            this.doSetProperty("resultHeader", resultHeader);
            return this;
        }

        default public AtomixMultimapComponentBuilder transportClassName(String transportClassName) {
            this.doSetProperty("transportClassName", transportClassName);
            return this;
        }

        default public AtomixMultimapComponentBuilder ttl(long ttl) {
            this.doSetProperty("ttl", ttl);
            return this;
        }

        @Deprecated
        default public AtomixMultimapComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AtomixMultimapComponentBuilder defaultResourceConfig(Properties defaultResourceConfig) {
            this.doSetProperty("defaultResourceConfig", defaultResourceConfig);
            return this;
        }

        default public AtomixMultimapComponentBuilder defaultResourceOptions(Properties defaultResourceOptions) {
            this.doSetProperty("defaultResourceOptions", defaultResourceOptions);
            return this;
        }

        default public AtomixMultimapComponentBuilder ephemeral(boolean ephemeral) {
            this.doSetProperty("ephemeral", ephemeral);
            return this;
        }

        default public AtomixMultimapComponentBuilder readConsistency(ReadConsistency readConsistency) {
            this.doSetProperty("readConsistency", readConsistency);
            return this;
        }

        default public AtomixMultimapComponentBuilder resourceConfigs(Map<String, Properties> resourceConfigs) {
            this.doSetProperty("resourceConfigs", resourceConfigs);
            return this;
        }

        default public AtomixMultimapComponentBuilder resourceOptions(Map<String, Properties> resourceOptions) {
            this.doSetProperty("resourceOptions", resourceOptions);
            return this;
        }
    }
}

