/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.avro.Protocol;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.avro.AvroComponent;
import org.apache.camel.component.avro.AvroConfiguration;

public interface AvroComponentBuilderFactory {
    public static AvroComponentBuilder avro() {
        return new AvroComponentBuilderImpl();
    }

    public static class AvroComponentBuilderImpl
    extends AbstractComponentBuilder<AvroComponent>
    implements AvroComponentBuilder {
        @Override
        protected AvroComponent buildConcreteComponent() {
            return new AvroComponent();
        }

        private AvroConfiguration getOrCreateConfiguration(AvroComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new AvroConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "protocol": {
                    this.getOrCreateConfiguration((AvroComponent)component).setProtocol((Protocol)value);
                    return true;
                }
                case "protocolClassName": {
                    this.getOrCreateConfiguration((AvroComponent)component).setProtocolClassName((String)value);
                    return true;
                }
                case "protocolLocation": {
                    this.getOrCreateConfiguration((AvroComponent)component).setProtocolLocation((String)value);
                    return true;
                }
                case "reflectionProtocol": {
                    this.getOrCreateConfiguration((AvroComponent)component).setReflectionProtocol(((Boolean)value).booleanValue());
                    return true;
                }
                case "singleParameter": {
                    this.getOrCreateConfiguration((AvroComponent)component).setSingleParameter(((Boolean)value).booleanValue());
                    return true;
                }
                case "uriAuthority": {
                    this.getOrCreateConfiguration((AvroComponent)component).setUriAuthority((String)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((AvroComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((AvroComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((AvroComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((AvroComponent)component).setConfiguration((AvroConfiguration)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AvroComponentBuilder
    extends ComponentBuilder<AvroComponent> {
        default public AvroComponentBuilder protocol(Protocol protocol) {
            this.doSetProperty("protocol", protocol);
            return this;
        }

        default public AvroComponentBuilder protocolClassName(String protocolClassName) {
            this.doSetProperty("protocolClassName", protocolClassName);
            return this;
        }

        default public AvroComponentBuilder protocolLocation(String protocolLocation) {
            this.doSetProperty("protocolLocation", protocolLocation);
            return this;
        }

        default public AvroComponentBuilder reflectionProtocol(boolean reflectionProtocol) {
            this.doSetProperty("reflectionProtocol", reflectionProtocol);
            return this;
        }

        default public AvroComponentBuilder singleParameter(boolean singleParameter) {
            this.doSetProperty("singleParameter", singleParameter);
            return this;
        }

        default public AvroComponentBuilder uriAuthority(String uriAuthority) {
            this.doSetProperty("uriAuthority", uriAuthority);
            return this;
        }

        default public AvroComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AvroComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        @Deprecated
        default public AvroComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AvroComponentBuilder configuration(AvroConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }
    }
}

