/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.ecs.ECS2Component;
import org.apache.camel.component.aws2.ecs.ECS2Configuration;
import org.apache.camel.component.aws2.ecs.ECS2Operations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.ecs.EcsClient;

public interface Aws2EcsComponentBuilderFactory {
    public static Aws2EcsComponentBuilder aws2Ecs() {
        return new Aws2EcsComponentBuilderImpl();
    }

    public static class Aws2EcsComponentBuilderImpl
    extends AbstractComponentBuilder<ECS2Component>
    implements Aws2EcsComponentBuilder {
        @Override
        protected ECS2Component buildConcreteComponent() {
            return new ECS2Component();
        }

        private ECS2Configuration getOrCreateConfiguration(ECS2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new ECS2Configuration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "autoDiscoverClient": {
                    this.getOrCreateConfiguration((ECS2Component)component).setAutoDiscoverClient(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((ECS2Component)component).setConfiguration((ECS2Configuration)value);
                    return true;
                }
                case "ecsClient": {
                    this.getOrCreateConfiguration((ECS2Component)component).setEcsClient((EcsClient)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((ECS2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((ECS2Component)component).setOperation((ECS2Operations)value);
                    return true;
                }
                case "pojoRequest": {
                    this.getOrCreateConfiguration((ECS2Component)component).setPojoRequest(((Boolean)value).booleanValue());
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((ECS2Component)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((ECS2Component)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((ECS2Component)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((ECS2Component)component).setRegion((String)value);
                    return true;
                }
                case "trustAllCertificates": {
                    this.getOrCreateConfiguration((ECS2Component)component).setTrustAllCertificates(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((ECS2Component)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((ECS2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((ECS2Component)component).setSecretKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2EcsComponentBuilder
    extends ComponentBuilder<ECS2Component> {
        default public Aws2EcsComponentBuilder autoDiscoverClient(boolean autoDiscoverClient) {
            this.doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }

        default public Aws2EcsComponentBuilder configuration(ECS2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Aws2EcsComponentBuilder ecsClient(EcsClient ecsClient) {
            this.doSetProperty("ecsClient", ecsClient);
            return this;
        }

        default public Aws2EcsComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2EcsComponentBuilder operation(ECS2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Aws2EcsComponentBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public Aws2EcsComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Aws2EcsComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Aws2EcsComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Aws2EcsComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2EcsComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        @Deprecated
        default public Aws2EcsComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public Aws2EcsComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2EcsComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

