/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.translate.Translate2Component;
import org.apache.camel.component.aws2.translate.Translate2Configuration;
import org.apache.camel.component.aws2.translate.Translate2Operations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.translate.TranslateClient;

public interface Aws2TranslateComponentBuilderFactory {
    public static Aws2TranslateComponentBuilder aws2Translate() {
        return new Aws2TranslateComponentBuilderImpl();
    }

    public static class Aws2TranslateComponentBuilderImpl
    extends AbstractComponentBuilder<Translate2Component>
    implements Aws2TranslateComponentBuilder {
        @Override
        protected Translate2Component buildConcreteComponent() {
            return new Translate2Component();
        }

        private Translate2Configuration getOrCreateConfiguration(Translate2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new Translate2Configuration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "autodetectSourceLanguage": {
                    this.getOrCreateConfiguration((Translate2Component)component).setAutodetectSourceLanguage(((Boolean)value).booleanValue());
                    return true;
                }
                case "autoDiscoverClient": {
                    this.getOrCreateConfiguration((Translate2Component)component).setAutoDiscoverClient(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((Translate2Component)component).setConfiguration((Translate2Configuration)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((Translate2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((Translate2Component)component).setOperation((Translate2Operations)value);
                    return true;
                }
                case "pojoRequest": {
                    this.getOrCreateConfiguration((Translate2Component)component).setPojoRequest(((Boolean)value).booleanValue());
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((Translate2Component)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((Translate2Component)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((Translate2Component)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((Translate2Component)component).setRegion((String)value);
                    return true;
                }
                case "sourceLanguage": {
                    this.getOrCreateConfiguration((Translate2Component)component).setSourceLanguage((String)value);
                    return true;
                }
                case "targetLanguage": {
                    this.getOrCreateConfiguration((Translate2Component)component).setTargetLanguage((String)value);
                    return true;
                }
                case "translateClient": {
                    this.getOrCreateConfiguration((Translate2Component)component).setTranslateClient((TranslateClient)value);
                    return true;
                }
                case "trustAllCertificates": {
                    this.getOrCreateConfiguration((Translate2Component)component).setTrustAllCertificates(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((Translate2Component)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((Translate2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((Translate2Component)component).setSecretKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2TranslateComponentBuilder
    extends ComponentBuilder<Translate2Component> {
        default public Aws2TranslateComponentBuilder autodetectSourceLanguage(boolean autodetectSourceLanguage) {
            this.doSetProperty("autodetectSourceLanguage", autodetectSourceLanguage);
            return this;
        }

        default public Aws2TranslateComponentBuilder autoDiscoverClient(boolean autoDiscoverClient) {
            this.doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }

        default public Aws2TranslateComponentBuilder configuration(Translate2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Aws2TranslateComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2TranslateComponentBuilder operation(Translate2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Aws2TranslateComponentBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public Aws2TranslateComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Aws2TranslateComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Aws2TranslateComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Aws2TranslateComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2TranslateComponentBuilder sourceLanguage(String sourceLanguage) {
            this.doSetProperty("sourceLanguage", sourceLanguage);
            return this;
        }

        default public Aws2TranslateComponentBuilder targetLanguage(String targetLanguage) {
            this.doSetProperty("targetLanguage", targetLanguage);
            return this;
        }

        default public Aws2TranslateComponentBuilder translateClient(TranslateClient translateClient) {
            this.doSetProperty("translateClient", translateClient);
            return this;
        }

        default public Aws2TranslateComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        @Deprecated
        default public Aws2TranslateComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public Aws2TranslateComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2TranslateComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

