/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import com.amazonaws.Protocol;
import com.amazonaws.services.kafka.AWSKafka;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws.msk.MSKComponent;
import org.apache.camel.component.aws.msk.MSKConfiguration;
import org.apache.camel.component.aws.msk.MSKOperations;

public interface AwsMskComponentBuilderFactory {
    public static AwsMskComponentBuilder awsMsk() {
        return new AwsMskComponentBuilderImpl();
    }

    public static class AwsMskComponentBuilderImpl
    extends AbstractComponentBuilder<MSKComponent>
    implements AwsMskComponentBuilder {
        @Override
        protected MSKComponent buildConcreteComponent() {
            return new MSKComponent();
        }

        private MSKConfiguration getOrCreateConfiguration(MSKComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new MSKConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "autoDiscoverClient": {
                    this.getOrCreateConfiguration((MSKComponent)component).setAutoDiscoverClient(((Boolean)value).booleanValue());
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((MSKComponent)component).setAccessKey((String)value);
                    return true;
                }
                case "configuration": {
                    ((MSKComponent)component).setConfiguration((MSKConfiguration)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((MSKComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "mskClient": {
                    this.getOrCreateConfiguration((MSKComponent)component).setMskClient((AWSKafka)value);
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((MSKComponent)component).setOperation((MSKOperations)value);
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((MSKComponent)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((MSKComponent)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((MSKComponent)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((MSKComponent)component).setRegion((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((MSKComponent)component).setSecretKey((String)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((MSKComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AwsMskComponentBuilder
    extends ComponentBuilder<MSKComponent> {
        default public AwsMskComponentBuilder autoDiscoverClient(boolean autoDiscoverClient) {
            this.doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }

        default public AwsMskComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public AwsMskComponentBuilder configuration(MSKConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AwsMskComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AwsMskComponentBuilder mskClient(AWSKafka mskClient) {
            this.doSetProperty("mskClient", mskClient);
            return this;
        }

        default public AwsMskComponentBuilder operation(MSKOperations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public AwsMskComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public AwsMskComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public AwsMskComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public AwsMskComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public AwsMskComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        @Deprecated
        default public AwsMskComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
    }
}

