/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import com.amazonaws.Protocol;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws.s3.S3Component;
import org.apache.camel.component.aws.s3.S3Configuration;
import org.apache.camel.component.aws.s3.S3Operations;

public interface AwsS3ComponentBuilderFactory {
    public static AwsS3ComponentBuilder awsS3() {
        return new AwsS3ComponentBuilderImpl();
    }

    public static class AwsS3ComponentBuilderImpl
    extends AbstractComponentBuilder<S3Component>
    implements AwsS3ComponentBuilder {
        @Override
        protected S3Component buildConcreteComponent() {
            return new S3Component();
        }

        private S3Configuration getOrCreateConfiguration(S3Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new S3Configuration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "amazonS3Client": {
                    this.getOrCreateConfiguration((S3Component)component).setAmazonS3Client((AmazonS3)value);
                    return true;
                }
                case "autoCreateBucket": {
                    this.getOrCreateConfiguration((S3Component)component).setAutoCreateBucket(((Boolean)value).booleanValue());
                    return true;
                }
                case "autoDiscoverClient": {
                    this.getOrCreateConfiguration((S3Component)component).setAutoDiscoverClient(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((S3Component)component).setConfiguration((S3Configuration)value);
                    return true;
                }
                case "endpointConfiguration": {
                    this.getOrCreateConfiguration((S3Component)component).setEndpointConfiguration((AwsClientBuilder.EndpointConfiguration)value);
                    return true;
                }
                case "pathStyleAccess": {
                    this.getOrCreateConfiguration((S3Component)component).setPathStyleAccess(((Boolean)value).booleanValue());
                    return true;
                }
                case "policy": {
                    this.getOrCreateConfiguration((S3Component)component).setPolicy((String)value);
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((S3Component)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((S3Component)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((S3Component)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((S3Component)component).setRegion((String)value);
                    return true;
                }
                case "useIAMCredentials": {
                    this.getOrCreateConfiguration((S3Component)component).setUseIAMCredentials(Boolean.valueOf((Boolean)value));
                    return true;
                }
                case "encryptionMaterials": {
                    this.getOrCreateConfiguration((S3Component)component).setEncryptionMaterials((EncryptionMaterials)value);
                    return true;
                }
                case "useEncryption": {
                    this.getOrCreateConfiguration((S3Component)component).setUseEncryption(((Boolean)value).booleanValue());
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((S3Component)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "deleteAfterRead": {
                    this.getOrCreateConfiguration((S3Component)component).setDeleteAfterRead(((Boolean)value).booleanValue());
                    return true;
                }
                case "delimiter": {
                    this.getOrCreateConfiguration((S3Component)component).setDelimiter((String)value);
                    return true;
                }
                case "fileName": {
                    this.getOrCreateConfiguration((S3Component)component).setFileName((String)value);
                    return true;
                }
                case "includeBody": {
                    this.getOrCreateConfiguration((S3Component)component).setIncludeBody(((Boolean)value).booleanValue());
                    return true;
                }
                case "prefix": {
                    this.getOrCreateConfiguration((S3Component)component).setPrefix((String)value);
                    return true;
                }
                case "autocloseBody": {
                    this.getOrCreateConfiguration((S3Component)component).setAutocloseBody(((Boolean)value).booleanValue());
                    return true;
                }
                case "deleteAfterWrite": {
                    this.getOrCreateConfiguration((S3Component)component).setDeleteAfterWrite(((Boolean)value).booleanValue());
                    return true;
                }
                case "keyName": {
                    this.getOrCreateConfiguration((S3Component)component).setKeyName((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((S3Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "multiPartUpload": {
                    this.getOrCreateConfiguration((S3Component)component).setMultiPartUpload(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((S3Component)component).setOperation((S3Operations)value);
                    return true;
                }
                case "partSize": {
                    this.getOrCreateConfiguration((S3Component)component).setPartSize(((Long)value).longValue());
                    return true;
                }
                case "serverSideEncryption": {
                    this.getOrCreateConfiguration((S3Component)component).setServerSideEncryption((String)value);
                    return true;
                }
                case "storageClass": {
                    this.getOrCreateConfiguration((S3Component)component).setStorageClass((String)value);
                    return true;
                }
                case "awsKMSKeyId": {
                    this.getOrCreateConfiguration((S3Component)component).setAwsKMSKeyId((String)value);
                    return true;
                }
                case "useAwsKMS": {
                    this.getOrCreateConfiguration((S3Component)component).setUseAwsKMS(((Boolean)value).booleanValue());
                    return true;
                }
                case "accelerateModeEnabled": {
                    this.getOrCreateConfiguration((S3Component)component).setAccelerateModeEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "chunkedEncodingDisabled": {
                    this.getOrCreateConfiguration((S3Component)component).setChunkedEncodingDisabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "dualstackEnabled": {
                    this.getOrCreateConfiguration((S3Component)component).setDualstackEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "forceGlobalBucketAccessEnabled": {
                    this.getOrCreateConfiguration((S3Component)component).setForceGlobalBucketAccessEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "payloadSigningEnabled": {
                    this.getOrCreateConfiguration((S3Component)component).setPayloadSigningEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((S3Component)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((S3Component)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((S3Component)component).setSecretKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AwsS3ComponentBuilder
    extends ComponentBuilder<S3Component> {
        default public AwsS3ComponentBuilder amazonS3Client(AmazonS3 amazonS3Client) {
            this.doSetProperty("amazonS3Client", amazonS3Client);
            return this;
        }

        default public AwsS3ComponentBuilder autoCreateBucket(boolean autoCreateBucket) {
            this.doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }

        default public AwsS3ComponentBuilder autoDiscoverClient(boolean autoDiscoverClient) {
            this.doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }

        default public AwsS3ComponentBuilder configuration(S3Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AwsS3ComponentBuilder endpointConfiguration(AwsClientBuilder.EndpointConfiguration endpointConfiguration) {
            this.doSetProperty("endpointConfiguration", endpointConfiguration);
            return this;
        }

        default public AwsS3ComponentBuilder pathStyleAccess(boolean pathStyleAccess) {
            this.doSetProperty("pathStyleAccess", pathStyleAccess);
            return this;
        }

        default public AwsS3ComponentBuilder policy(String policy) {
            this.doSetProperty("policy", policy);
            return this;
        }

        default public AwsS3ComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public AwsS3ComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public AwsS3ComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public AwsS3ComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public AwsS3ComponentBuilder useIAMCredentials(boolean useIAMCredentials) {
            this.doSetProperty("useIAMCredentials", useIAMCredentials);
            return this;
        }

        default public AwsS3ComponentBuilder encryptionMaterials(EncryptionMaterials encryptionMaterials) {
            this.doSetProperty("encryptionMaterials", encryptionMaterials);
            return this;
        }

        default public AwsS3ComponentBuilder useEncryption(boolean useEncryption) {
            this.doSetProperty("useEncryption", useEncryption);
            return this;
        }

        default public AwsS3ComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AwsS3ComponentBuilder deleteAfterRead(boolean deleteAfterRead) {
            this.doSetProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }

        default public AwsS3ComponentBuilder delimiter(String delimiter) {
            this.doSetProperty("delimiter", delimiter);
            return this;
        }

        default public AwsS3ComponentBuilder fileName(String fileName) {
            this.doSetProperty("fileName", fileName);
            return this;
        }

        default public AwsS3ComponentBuilder includeBody(boolean includeBody) {
            this.doSetProperty("includeBody", includeBody);
            return this;
        }

        default public AwsS3ComponentBuilder prefix(String prefix) {
            this.doSetProperty("prefix", prefix);
            return this;
        }

        default public AwsS3ComponentBuilder autocloseBody(boolean autocloseBody) {
            this.doSetProperty("autocloseBody", autocloseBody);
            return this;
        }

        default public AwsS3ComponentBuilder deleteAfterWrite(boolean deleteAfterWrite) {
            this.doSetProperty("deleteAfterWrite", deleteAfterWrite);
            return this;
        }

        default public AwsS3ComponentBuilder keyName(String keyName) {
            this.doSetProperty("keyName", keyName);
            return this;
        }

        default public AwsS3ComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AwsS3ComponentBuilder multiPartUpload(boolean multiPartUpload) {
            this.doSetProperty("multiPartUpload", multiPartUpload);
            return this;
        }

        default public AwsS3ComponentBuilder operation(S3Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public AwsS3ComponentBuilder partSize(long partSize) {
            this.doSetProperty("partSize", partSize);
            return this;
        }

        default public AwsS3ComponentBuilder serverSideEncryption(String serverSideEncryption) {
            this.doSetProperty("serverSideEncryption", serverSideEncryption);
            return this;
        }

        default public AwsS3ComponentBuilder storageClass(String storageClass) {
            this.doSetProperty("storageClass", storageClass);
            return this;
        }

        default public AwsS3ComponentBuilder awsKMSKeyId(String awsKMSKeyId) {
            this.doSetProperty("awsKMSKeyId", awsKMSKeyId);
            return this;
        }

        default public AwsS3ComponentBuilder useAwsKMS(boolean useAwsKMS) {
            this.doSetProperty("useAwsKMS", useAwsKMS);
            return this;
        }

        default public AwsS3ComponentBuilder accelerateModeEnabled(boolean accelerateModeEnabled) {
            this.doSetProperty("accelerateModeEnabled", accelerateModeEnabled);
            return this;
        }

        default public AwsS3ComponentBuilder chunkedEncodingDisabled(boolean chunkedEncodingDisabled) {
            this.doSetProperty("chunkedEncodingDisabled", chunkedEncodingDisabled);
            return this;
        }

        default public AwsS3ComponentBuilder dualstackEnabled(boolean dualstackEnabled) {
            this.doSetProperty("dualstackEnabled", dualstackEnabled);
            return this;
        }

        default public AwsS3ComponentBuilder forceGlobalBucketAccessEnabled(boolean forceGlobalBucketAccessEnabled) {
            this.doSetProperty("forceGlobalBucketAccessEnabled", forceGlobalBucketAccessEnabled);
            return this;
        }

        default public AwsS3ComponentBuilder payloadSigningEnabled(boolean payloadSigningEnabled) {
            this.doSetProperty("payloadSigningEnabled", payloadSigningEnabled);
            return this;
        }

        @Deprecated
        default public AwsS3ComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AwsS3ComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public AwsS3ComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

