/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import com.amazonaws.Protocol;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailService;
import java.util.List;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws.ses.SesComponent;
import org.apache.camel.component.aws.ses.SesConfiguration;

public interface AwsSesComponentBuilderFactory {
    public static AwsSesComponentBuilder awsSes() {
        return new AwsSesComponentBuilderImpl();
    }

    public static class AwsSesComponentBuilderImpl
    extends AbstractComponentBuilder<SesComponent>
    implements AwsSesComponentBuilder {
        @Override
        protected SesComponent buildConcreteComponent() {
            return new SesComponent();
        }

        private SesConfiguration getOrCreateConfiguration(SesComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new SesConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "amazonSESClient": {
                    this.getOrCreateConfiguration((SesComponent)component).setAmazonSESClient((AmazonSimpleEmailService)value);
                    return true;
                }
                case "autoDiscoverClient": {
                    this.getOrCreateConfiguration((SesComponent)component).setAutoDiscoverClient(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((SesComponent)component).setConfiguration((SesConfiguration)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((SesComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((SesComponent)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((SesComponent)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((SesComponent)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((SesComponent)component).setRegion((String)value);
                    return true;
                }
                case "replyToAddresses": {
                    this.getOrCreateConfiguration((SesComponent)component).setReplyToAddresses((List)value);
                    return true;
                }
                case "returnPath": {
                    this.getOrCreateConfiguration((SesComponent)component).setReturnPath((String)value);
                    return true;
                }
                case "subject": {
                    this.getOrCreateConfiguration((SesComponent)component).setSubject((String)value);
                    return true;
                }
                case "to": {
                    this.getOrCreateConfiguration((SesComponent)component).setTo((List)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((SesComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((SesComponent)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((SesComponent)component).setSecretKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AwsSesComponentBuilder
    extends ComponentBuilder<SesComponent> {
        default public AwsSesComponentBuilder amazonSESClient(AmazonSimpleEmailService amazonSESClient) {
            this.doSetProperty("amazonSESClient", amazonSESClient);
            return this;
        }

        default public AwsSesComponentBuilder autoDiscoverClient(boolean autoDiscoverClient) {
            this.doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }

        default public AwsSesComponentBuilder configuration(SesConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AwsSesComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AwsSesComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public AwsSesComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public AwsSesComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public AwsSesComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public AwsSesComponentBuilder replyToAddresses(List<String> replyToAddresses) {
            this.doSetProperty("replyToAddresses", replyToAddresses);
            return this;
        }

        default public AwsSesComponentBuilder returnPath(String returnPath) {
            this.doSetProperty("returnPath", returnPath);
            return this;
        }

        default public AwsSesComponentBuilder subject(String subject) {
            this.doSetProperty("subject", subject);
            return this;
        }

        default public AwsSesComponentBuilder to(List<String> to) {
            this.doSetProperty("to", to);
            return this;
        }

        @Deprecated
        default public AwsSesComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AwsSesComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public AwsSesComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

