/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import com.amazonaws.Protocol;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sqs.AmazonSQS;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws.sns.SnsComponent;
import org.apache.camel.component.aws.sns.SnsConfiguration;

public interface AwsSnsComponentBuilderFactory {
    public static AwsSnsComponentBuilder awsSns() {
        return new AwsSnsComponentBuilderImpl();
    }

    public static class AwsSnsComponentBuilderImpl
    extends AbstractComponentBuilder<SnsComponent>
    implements AwsSnsComponentBuilder {
        @Override
        protected SnsComponent buildConcreteComponent() {
            return new SnsComponent();
        }

        private SnsConfiguration getOrCreateConfiguration(SnsComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new SnsConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "amazonSNSClient": {
                    this.getOrCreateConfiguration((SnsComponent)component).setAmazonSNSClient((AmazonSNS)value);
                    return true;
                }
                case "amazonSQSClient": {
                    this.getOrCreateConfiguration((SnsComponent)component).setAmazonSQSClient((AmazonSQS)value);
                    return true;
                }
                case "autoCreateTopic": {
                    this.getOrCreateConfiguration((SnsComponent)component).setAutoCreateTopic(((Boolean)value).booleanValue());
                    return true;
                }
                case "autoDiscoverClient": {
                    this.getOrCreateConfiguration((SnsComponent)component).setAutoDiscoverClient(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((SnsComponent)component).setConfiguration((SnsConfiguration)value);
                    return true;
                }
                case "kmsMasterKeyId": {
                    this.getOrCreateConfiguration((SnsComponent)component).setKmsMasterKeyId((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((SnsComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "messageStructure": {
                    this.getOrCreateConfiguration((SnsComponent)component).setMessageStructure((String)value);
                    return true;
                }
                case "policy": {
                    this.getOrCreateConfiguration((SnsComponent)component).setPolicy((String)value);
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((SnsComponent)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((SnsComponent)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((SnsComponent)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "queueUrl": {
                    this.getOrCreateConfiguration((SnsComponent)component).setQueueUrl((String)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((SnsComponent)component).setRegion((String)value);
                    return true;
                }
                case "serverSideEncryptionEnabled": {
                    this.getOrCreateConfiguration((SnsComponent)component).setServerSideEncryptionEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "subject": {
                    this.getOrCreateConfiguration((SnsComponent)component).setSubject((String)value);
                    return true;
                }
                case "subscribeSNStoSQS": {
                    this.getOrCreateConfiguration((SnsComponent)component).setSubscribeSNStoSQS(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((SnsComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((SnsComponent)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((SnsComponent)component).setSecretKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AwsSnsComponentBuilder
    extends ComponentBuilder<SnsComponent> {
        default public AwsSnsComponentBuilder amazonSNSClient(AmazonSNS amazonSNSClient) {
            this.doSetProperty("amazonSNSClient", amazonSNSClient);
            return this;
        }

        default public AwsSnsComponentBuilder amazonSQSClient(AmazonSQS amazonSQSClient) {
            this.doSetProperty("amazonSQSClient", amazonSQSClient);
            return this;
        }

        default public AwsSnsComponentBuilder autoCreateTopic(boolean autoCreateTopic) {
            this.doSetProperty("autoCreateTopic", autoCreateTopic);
            return this;
        }

        default public AwsSnsComponentBuilder autoDiscoverClient(boolean autoDiscoverClient) {
            this.doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }

        default public AwsSnsComponentBuilder configuration(SnsConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AwsSnsComponentBuilder kmsMasterKeyId(String kmsMasterKeyId) {
            this.doSetProperty("kmsMasterKeyId", kmsMasterKeyId);
            return this;
        }

        default public AwsSnsComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AwsSnsComponentBuilder messageStructure(String messageStructure) {
            this.doSetProperty("messageStructure", messageStructure);
            return this;
        }

        default public AwsSnsComponentBuilder policy(String policy) {
            this.doSetProperty("policy", policy);
            return this;
        }

        default public AwsSnsComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public AwsSnsComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public AwsSnsComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public AwsSnsComponentBuilder queueUrl(String queueUrl) {
            this.doSetProperty("queueUrl", queueUrl);
            return this;
        }

        default public AwsSnsComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public AwsSnsComponentBuilder serverSideEncryptionEnabled(boolean serverSideEncryptionEnabled) {
            this.doSetProperty("serverSideEncryptionEnabled", serverSideEncryptionEnabled);
            return this;
        }

        default public AwsSnsComponentBuilder subject(String subject) {
            this.doSetProperty("subject", subject);
            return this;
        }

        default public AwsSnsComponentBuilder subscribeSNStoSQS(boolean subscribeSNStoSQS) {
            this.doSetProperty("subscribeSNStoSQS", subscribeSNStoSQS);
            return this;
        }

        @Deprecated
        default public AwsSnsComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AwsSnsComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public AwsSnsComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

