/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import com.amazonaws.Protocol;
import com.amazonaws.services.sqs.AmazonSQS;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws.sqs.SqsComponent;
import org.apache.camel.component.aws.sqs.SqsConfiguration;
import org.apache.camel.component.aws.sqs.SqsOperations;

public interface AwsSqsComponentBuilderFactory {
    public static AwsSqsComponentBuilder awsSqs() {
        return new AwsSqsComponentBuilderImpl();
    }

    public static class AwsSqsComponentBuilderImpl
    extends AbstractComponentBuilder<SqsComponent>
    implements AwsSqsComponentBuilder {
        @Override
        protected SqsComponent buildConcreteComponent() {
            return new SqsComponent();
        }

        private SqsConfiguration getOrCreateConfiguration(SqsComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new SqsConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "amazonAWSHost": {
                    this.getOrCreateConfiguration((SqsComponent)component).setAmazonAWSHost((String)value);
                    return true;
                }
                case "amazonSQSClient": {
                    this.getOrCreateConfiguration((SqsComponent)component).setAmazonSQSClient((AmazonSQS)value);
                    return true;
                }
                case "autoCreateQueue": {
                    this.getOrCreateConfiguration((SqsComponent)component).setAutoCreateQueue(((Boolean)value).booleanValue());
                    return true;
                }
                case "autoDiscoverClient": {
                    this.getOrCreateConfiguration((SqsComponent)component).setAutoDiscoverClient(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((SqsComponent)component).setConfiguration((SqsConfiguration)value);
                    return true;
                }
                case "protocol": {
                    this.getOrCreateConfiguration((SqsComponent)component).setProtocol((String)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((SqsComponent)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "queueOwnerAWSAccountId": {
                    this.getOrCreateConfiguration((SqsComponent)component).setQueueOwnerAWSAccountId((String)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((SqsComponent)component).setRegion((String)value);
                    return true;
                }
                case "attributeNames": {
                    this.getOrCreateConfiguration((SqsComponent)component).setAttributeNames((String)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((SqsComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "concurrentConsumers": {
                    this.getOrCreateConfiguration((SqsComponent)component).setConcurrentConsumers(((Integer)value).intValue());
                    return true;
                }
                case "defaultVisibilityTimeout": {
                    this.getOrCreateConfiguration((SqsComponent)component).setDefaultVisibilityTimeout((Integer)value);
                    return true;
                }
                case "deleteAfterRead": {
                    this.getOrCreateConfiguration((SqsComponent)component).setDeleteAfterRead(((Boolean)value).booleanValue());
                    return true;
                }
                case "deleteIfFiltered": {
                    this.getOrCreateConfiguration((SqsComponent)component).setDeleteIfFiltered(((Boolean)value).booleanValue());
                    return true;
                }
                case "extendMessageVisibility": {
                    this.getOrCreateConfiguration((SqsComponent)component).setExtendMessageVisibility(((Boolean)value).booleanValue());
                    return true;
                }
                case "kmsDataKeyReusePeriodSeconds": {
                    this.getOrCreateConfiguration((SqsComponent)component).setKmsDataKeyReusePeriodSeconds((Integer)value);
                    return true;
                }
                case "kmsMasterKeyId": {
                    this.getOrCreateConfiguration((SqsComponent)component).setKmsMasterKeyId((String)value);
                    return true;
                }
                case "messageAttributeNames": {
                    this.getOrCreateConfiguration((SqsComponent)component).setMessageAttributeNames((String)value);
                    return true;
                }
                case "serverSideEncryptionEnabled": {
                    this.getOrCreateConfiguration((SqsComponent)component).setServerSideEncryptionEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "visibilityTimeout": {
                    this.getOrCreateConfiguration((SqsComponent)component).setVisibilityTimeout((Integer)value);
                    return true;
                }
                case "waitTimeSeconds": {
                    this.getOrCreateConfiguration((SqsComponent)component).setWaitTimeSeconds((Integer)value);
                    return true;
                }
                case "delaySeconds": {
                    this.getOrCreateConfiguration((SqsComponent)component).setDelaySeconds((Integer)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((SqsComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "messageDeduplicationIdStrategy": {
                    this.getOrCreateConfiguration((SqsComponent)component).setMessageDeduplicationIdStrategy((String)value);
                    return true;
                }
                case "messageGroupIdStrategy": {
                    this.getOrCreateConfiguration((SqsComponent)component).setMessageGroupIdStrategy((String)value);
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((SqsComponent)component).setOperation((SqsOperations)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((SqsComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "delayQueue": {
                    this.getOrCreateConfiguration((SqsComponent)component).setDelayQueue(((Boolean)value).booleanValue());
                    return true;
                }
                case "queueUrl": {
                    this.getOrCreateConfiguration((SqsComponent)component).setQueueUrl((String)value);
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((SqsComponent)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((SqsComponent)component).setProxyPort((Integer)value);
                    return true;
                }
                case "maximumMessageSize": {
                    this.getOrCreateConfiguration((SqsComponent)component).setMaximumMessageSize((Integer)value);
                    return true;
                }
                case "messageRetentionPeriod": {
                    this.getOrCreateConfiguration((SqsComponent)component).setMessageRetentionPeriod((Integer)value);
                    return true;
                }
                case "policy": {
                    this.getOrCreateConfiguration((SqsComponent)component).setPolicy((String)value);
                    return true;
                }
                case "receiveMessageWaitTimeSeconds": {
                    this.getOrCreateConfiguration((SqsComponent)component).setReceiveMessageWaitTimeSeconds((Integer)value);
                    return true;
                }
                case "redrivePolicy": {
                    this.getOrCreateConfiguration((SqsComponent)component).setRedrivePolicy((String)value);
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((SqsComponent)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((SqsComponent)component).setSecretKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AwsSqsComponentBuilder
    extends ComponentBuilder<SqsComponent> {
        default public AwsSqsComponentBuilder amazonAWSHost(String amazonAWSHost) {
            this.doSetProperty("amazonAWSHost", amazonAWSHost);
            return this;
        }

        default public AwsSqsComponentBuilder amazonSQSClient(AmazonSQS amazonSQSClient) {
            this.doSetProperty("amazonSQSClient", amazonSQSClient);
            return this;
        }

        default public AwsSqsComponentBuilder autoCreateQueue(boolean autoCreateQueue) {
            this.doSetProperty("autoCreateQueue", autoCreateQueue);
            return this;
        }

        default public AwsSqsComponentBuilder autoDiscoverClient(boolean autoDiscoverClient) {
            this.doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }

        default public AwsSqsComponentBuilder configuration(SqsConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AwsSqsComponentBuilder protocol(String protocol) {
            this.doSetProperty("protocol", protocol);
            return this;
        }

        default public AwsSqsComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public AwsSqsComponentBuilder queueOwnerAWSAccountId(String queueOwnerAWSAccountId) {
            this.doSetProperty("queueOwnerAWSAccountId", queueOwnerAWSAccountId);
            return this;
        }

        default public AwsSqsComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public AwsSqsComponentBuilder attributeNames(String attributeNames) {
            this.doSetProperty("attributeNames", attributeNames);
            return this;
        }

        default public AwsSqsComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AwsSqsComponentBuilder concurrentConsumers(int concurrentConsumers) {
            this.doSetProperty("concurrentConsumers", concurrentConsumers);
            return this;
        }

        default public AwsSqsComponentBuilder defaultVisibilityTimeout(Integer defaultVisibilityTimeout) {
            this.doSetProperty("defaultVisibilityTimeout", defaultVisibilityTimeout);
            return this;
        }

        default public AwsSqsComponentBuilder deleteAfterRead(boolean deleteAfterRead) {
            this.doSetProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }

        default public AwsSqsComponentBuilder deleteIfFiltered(boolean deleteIfFiltered) {
            this.doSetProperty("deleteIfFiltered", deleteIfFiltered);
            return this;
        }

        default public AwsSqsComponentBuilder extendMessageVisibility(boolean extendMessageVisibility) {
            this.doSetProperty("extendMessageVisibility", extendMessageVisibility);
            return this;
        }

        default public AwsSqsComponentBuilder kmsDataKeyReusePeriodSeconds(Integer kmsDataKeyReusePeriodSeconds) {
            this.doSetProperty("kmsDataKeyReusePeriodSeconds", kmsDataKeyReusePeriodSeconds);
            return this;
        }

        default public AwsSqsComponentBuilder kmsMasterKeyId(String kmsMasterKeyId) {
            this.doSetProperty("kmsMasterKeyId", kmsMasterKeyId);
            return this;
        }

        default public AwsSqsComponentBuilder messageAttributeNames(String messageAttributeNames) {
            this.doSetProperty("messageAttributeNames", messageAttributeNames);
            return this;
        }

        default public AwsSqsComponentBuilder serverSideEncryptionEnabled(boolean serverSideEncryptionEnabled) {
            this.doSetProperty("serverSideEncryptionEnabled", serverSideEncryptionEnabled);
            return this;
        }

        default public AwsSqsComponentBuilder visibilityTimeout(Integer visibilityTimeout) {
            this.doSetProperty("visibilityTimeout", visibilityTimeout);
            return this;
        }

        default public AwsSqsComponentBuilder waitTimeSeconds(Integer waitTimeSeconds) {
            this.doSetProperty("waitTimeSeconds", waitTimeSeconds);
            return this;
        }

        default public AwsSqsComponentBuilder delaySeconds(Integer delaySeconds) {
            this.doSetProperty("delaySeconds", delaySeconds);
            return this;
        }

        default public AwsSqsComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AwsSqsComponentBuilder messageDeduplicationIdStrategy(String messageDeduplicationIdStrategy) {
            this.doSetProperty("messageDeduplicationIdStrategy", messageDeduplicationIdStrategy);
            return this;
        }

        default public AwsSqsComponentBuilder messageGroupIdStrategy(String messageGroupIdStrategy) {
            this.doSetProperty("messageGroupIdStrategy", messageGroupIdStrategy);
            return this;
        }

        default public AwsSqsComponentBuilder operation(SqsOperations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        @Deprecated
        default public AwsSqsComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AwsSqsComponentBuilder delayQueue(boolean delayQueue) {
            this.doSetProperty("delayQueue", delayQueue);
            return this;
        }

        default public AwsSqsComponentBuilder queueUrl(String queueUrl) {
            this.doSetProperty("queueUrl", queueUrl);
            return this;
        }

        default public AwsSqsComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public AwsSqsComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public AwsSqsComponentBuilder maximumMessageSize(Integer maximumMessageSize) {
            this.doSetProperty("maximumMessageSize", maximumMessageSize);
            return this;
        }

        default public AwsSqsComponentBuilder messageRetentionPeriod(Integer messageRetentionPeriod) {
            this.doSetProperty("messageRetentionPeriod", messageRetentionPeriod);
            return this;
        }

        default public AwsSqsComponentBuilder policy(String policy) {
            this.doSetProperty("policy", policy);
            return this;
        }

        default public AwsSqsComponentBuilder receiveMessageWaitTimeSeconds(Integer receiveMessageWaitTimeSeconds) {
            this.doSetProperty("receiveMessageWaitTimeSeconds", receiveMessageWaitTimeSeconds);
            return this;
        }

        default public AwsSqsComponentBuilder redrivePolicy(String redrivePolicy) {
            this.doSetProperty("redrivePolicy", redrivePolicy);
            return this;
        }

        default public AwsSqsComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public AwsSqsComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

