/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.queue.QueueServiceClient;
import java.time.Duration;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.azure.storage.queue.QueueComponent;
import org.apache.camel.component.azure.storage.queue.QueueConfiguration;
import org.apache.camel.component.azure.storage.queue.QueueOperationDefinition;

public interface AzureStorageQueueComponentBuilderFactory {
    public static AzureStorageQueueComponentBuilder azureStorageQueue() {
        return new AzureStorageQueueComponentBuilderImpl();
    }

    public static class AzureStorageQueueComponentBuilderImpl
    extends AbstractComponentBuilder<QueueComponent>
    implements AzureStorageQueueComponentBuilder {
        @Override
        protected QueueComponent buildConcreteComponent() {
            return new QueueComponent();
        }

        private QueueConfiguration getOrCreateConfiguration(QueueComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new QueueConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "autoDiscoverClient": {
                    this.getOrCreateConfiguration((QueueComponent)component).setAutoDiscoverClient(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((QueueComponent)component).setConfiguration((QueueConfiguration)value);
                    return true;
                }
                case "serviceClient": {
                    this.getOrCreateConfiguration((QueueComponent)component).setServiceClient((QueueServiceClient)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((QueueComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "createQueue": {
                    this.getOrCreateConfiguration((QueueComponent)component).setCreateQueue(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((QueueComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((QueueComponent)component).setOperation((QueueOperationDefinition)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((QueueComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "maxMessages": {
                    this.getOrCreateConfiguration((QueueComponent)component).setMaxMessages((Integer)value);
                    return true;
                }
                case "messageId": {
                    this.getOrCreateConfiguration((QueueComponent)component).setMessageId((String)value);
                    return true;
                }
                case "popReceipt": {
                    this.getOrCreateConfiguration((QueueComponent)component).setPopReceipt((String)value);
                    return true;
                }
                case "timeout": {
                    this.getOrCreateConfiguration((QueueComponent)component).setTimeout((Duration)value);
                    return true;
                }
                case "timeToLive": {
                    this.getOrCreateConfiguration((QueueComponent)component).setTimeToLive((Duration)value);
                    return true;
                }
                case "visibilityTimeout": {
                    this.getOrCreateConfiguration((QueueComponent)component).setVisibilityTimeout((Duration)value);
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((QueueComponent)component).setAccessKey((String)value);
                    return true;
                }
                case "credentials": {
                    this.getOrCreateConfiguration((QueueComponent)component).setCredentials((StorageSharedKeyCredential)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AzureStorageQueueComponentBuilder
    extends ComponentBuilder<QueueComponent> {
        default public AzureStorageQueueComponentBuilder autoDiscoverClient(boolean autoDiscoverClient) {
            this.doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }

        default public AzureStorageQueueComponentBuilder configuration(QueueConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AzureStorageQueueComponentBuilder serviceClient(QueueServiceClient serviceClient) {
            this.doSetProperty("serviceClient", serviceClient);
            return this;
        }

        default public AzureStorageQueueComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AzureStorageQueueComponentBuilder createQueue(boolean createQueue) {
            this.doSetProperty("createQueue", createQueue);
            return this;
        }

        default public AzureStorageQueueComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AzureStorageQueueComponentBuilder operation(QueueOperationDefinition operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        @Deprecated
        default public AzureStorageQueueComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public AzureStorageQueueComponentBuilder maxMessages(Integer maxMessages) {
            this.doSetProperty("maxMessages", maxMessages);
            return this;
        }

        default public AzureStorageQueueComponentBuilder messageId(String messageId) {
            this.doSetProperty("messageId", messageId);
            return this;
        }

        default public AzureStorageQueueComponentBuilder popReceipt(String popReceipt) {
            this.doSetProperty("popReceipt", popReceipt);
            return this;
        }

        default public AzureStorageQueueComponentBuilder timeout(Duration timeout) {
            this.doSetProperty("timeout", timeout);
            return this;
        }

        default public AzureStorageQueueComponentBuilder timeToLive(Duration timeToLive) {
            this.doSetProperty("timeToLive", timeToLive);
            return this;
        }

        default public AzureStorageQueueComponentBuilder visibilityTimeout(Duration visibilityTimeout) {
            this.doSetProperty("visibilityTimeout", visibilityTimeout);
            return this;
        }

        default public AzureStorageQueueComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public AzureStorageQueueComponentBuilder credentials(StorageSharedKeyCredential credentials) {
            this.doSetProperty("credentials", credentials);
            return this;
        }
    }
}

