/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import java.util.List;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.google.drive.GoogleDriveClientFactory;
import org.apache.camel.component.google.drive.GoogleDriveComponent;
import org.apache.camel.component.google.drive.GoogleDriveConfiguration;

public interface GoogleDriveComponentBuilderFactory {
    public static GoogleDriveComponentBuilder googleDrive() {
        return new GoogleDriveComponentBuilderImpl();
    }

    public static class GoogleDriveComponentBuilderImpl
    extends AbstractComponentBuilder<GoogleDriveComponent>
    implements GoogleDriveComponentBuilder {
        @Override
        protected GoogleDriveComponent buildConcreteComponent() {
            return new GoogleDriveComponent();
        }

        private GoogleDriveConfiguration getOrCreateConfiguration(GoogleDriveComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new GoogleDriveConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "applicationName": {
                    this.getOrCreateConfiguration((GoogleDriveComponent)component).setApplicationName((String)value);
                    return true;
                }
                case "clientId": {
                    this.getOrCreateConfiguration((GoogleDriveComponent)component).setClientId((String)value);
                    return true;
                }
                case "configuration": {
                    ((GoogleDriveComponent)component).setConfiguration((GoogleDriveConfiguration)value);
                    return true;
                }
                case "scopes": {
                    this.getOrCreateConfiguration((GoogleDriveComponent)component).setScopes((List)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((GoogleDriveComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((GoogleDriveComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((GoogleDriveComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "clientFactory": {
                    ((GoogleDriveComponent)component).setClientFactory((GoogleDriveClientFactory)value);
                    return true;
                }
                case "accessToken": {
                    this.getOrCreateConfiguration((GoogleDriveComponent)component).setAccessToken((String)value);
                    return true;
                }
                case "clientSecret": {
                    this.getOrCreateConfiguration((GoogleDriveComponent)component).setClientSecret((String)value);
                    return true;
                }
                case "refreshToken": {
                    this.getOrCreateConfiguration((GoogleDriveComponent)component).setRefreshToken((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface GoogleDriveComponentBuilder
    extends ComponentBuilder<GoogleDriveComponent> {
        default public GoogleDriveComponentBuilder applicationName(String applicationName) {
            this.doSetProperty("applicationName", applicationName);
            return this;
        }

        default public GoogleDriveComponentBuilder clientId(String clientId) {
            this.doSetProperty("clientId", clientId);
            return this;
        }

        default public GoogleDriveComponentBuilder configuration(GoogleDriveConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public GoogleDriveComponentBuilder scopes(List<String> scopes) {
            this.doSetProperty("scopes", scopes);
            return this;
        }

        default public GoogleDriveComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public GoogleDriveComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        @Deprecated
        default public GoogleDriveComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public GoogleDriveComponentBuilder clientFactory(GoogleDriveClientFactory clientFactory) {
            this.doSetProperty("clientFactory", clientFactory);
            return this;
        }

        default public GoogleDriveComponentBuilder accessToken(String accessToken) {
            this.doSetProperty("accessToken", accessToken);
            return this;
        }

        default public GoogleDriveComponentBuilder clientSecret(String clientSecret) {
            this.doSetProperty("clientSecret", clientSecret);
            return this;
        }

        default public GoogleDriveComponentBuilder refreshToken(String refreshToken) {
            this.doSetProperty("refreshToken", refreshToken);
            return this;
        }
    }
}

