/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import java.util.Map;
import java.util.function.BiFunction;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.infinispan.InfinispanComponent;
import org.apache.camel.component.infinispan.InfinispanConfiguration;
import org.apache.camel.component.infinispan.InfinispanCustomListener;
import org.apache.camel.component.infinispan.InfinispanOperation;
import org.apache.camel.component.infinispan.InfinispanQueryBuilder;
import org.infinispan.commons.api.BasicCacheContainer;

public interface InfinispanComponentBuilderFactory {
    public static InfinispanComponentBuilder infinispan() {
        return new InfinispanComponentBuilderImpl();
    }

    public static class InfinispanComponentBuilderImpl
    extends AbstractComponentBuilder<InfinispanComponent>
    implements InfinispanComponentBuilder {
        @Override
        protected InfinispanComponent buildConcreteComponent() {
            return new InfinispanComponent();
        }

        private InfinispanConfiguration getOrCreateConfiguration(InfinispanComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new InfinispanConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((InfinispanComponent)component).setConfiguration((InfinispanConfiguration)value);
                    return true;
                }
                case "hosts": {
                    this.getOrCreateConfiguration((InfinispanComponent)component).setHosts((String)value);
                    return true;
                }
                case "queryBuilder": {
                    this.getOrCreateConfiguration((InfinispanComponent)component).setQueryBuilder((InfinispanQueryBuilder)value);
                    return true;
                }
                case "secure": {
                    this.getOrCreateConfiguration((InfinispanComponent)component).setSecure(((Boolean)value).booleanValue());
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((InfinispanComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "clusteredListener": {
                    this.getOrCreateConfiguration((InfinispanComponent)component).setClusteredListener(((Boolean)value).booleanValue());
                    return true;
                }
                case "command": {
                    this.getOrCreateConfiguration((InfinispanComponent)component).setCommand((String)value);
                    return true;
                }
                case "customListener": {
                    this.getOrCreateConfiguration((InfinispanComponent)component).setCustomListener((InfinispanCustomListener)value);
                    return true;
                }
                case "eventTypes": {
                    this.getOrCreateConfiguration((InfinispanComponent)component).setEventTypes((String)value);
                    return true;
                }
                case "sync": {
                    this.getOrCreateConfiguration((InfinispanComponent)component).setSync(((Boolean)value).booleanValue());
                    return true;
                }
                case "defaultValue": {
                    this.getOrCreateConfiguration((InfinispanComponent)component).setDefaultValue(value);
                    return true;
                }
                case "key": {
                    this.getOrCreateConfiguration((InfinispanComponent)component).setKey(value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((InfinispanComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "oldValue": {
                    this.getOrCreateConfiguration((InfinispanComponent)component).setOldValue(value);
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((InfinispanComponent)component).setOperation((InfinispanOperation)value);
                    return true;
                }
                case "value": {
                    this.getOrCreateConfiguration((InfinispanComponent)component).setValue(value);
                    return true;
                }
                case "password": {
                    this.getOrCreateConfiguration((InfinispanComponent)component).setPassword((String)value);
                    return true;
                }
                case "saslMechanism": {
                    this.getOrCreateConfiguration((InfinispanComponent)component).setSaslMechanism((String)value);
                    return true;
                }
                case "securityRealm": {
                    this.getOrCreateConfiguration((InfinispanComponent)component).setSecurityRealm((String)value);
                    return true;
                }
                case "securityServerName": {
                    this.getOrCreateConfiguration((InfinispanComponent)component).setSecurityServerName((String)value);
                    return true;
                }
                case "username": {
                    this.getOrCreateConfiguration((InfinispanComponent)component).setUsername((String)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((InfinispanComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "cacheContainer": {
                    this.getOrCreateConfiguration((InfinispanComponent)component).setCacheContainer((BasicCacheContainer)value);
                    return true;
                }
                case "cacheContainerConfiguration": {
                    this.getOrCreateConfiguration((InfinispanComponent)component).setCacheContainerConfiguration(value);
                    return true;
                }
                case "configurationProperties": {
                    this.getOrCreateConfiguration((InfinispanComponent)component).setConfigurationProperties((Map)value);
                    return true;
                }
                case "configurationUri": {
                    this.getOrCreateConfiguration((InfinispanComponent)component).setConfigurationUri((String)value);
                    return true;
                }
                case "flags": {
                    this.getOrCreateConfiguration((InfinispanComponent)component).setFlags((String)value);
                    return true;
                }
                case "remappingFunction": {
                    this.getOrCreateConfiguration((InfinispanComponent)component).setRemappingFunction((BiFunction)value);
                    return true;
                }
                case "resultHeader": {
                    this.getOrCreateConfiguration((InfinispanComponent)component).setResultHeader(value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface InfinispanComponentBuilder
    extends ComponentBuilder<InfinispanComponent> {
        default public InfinispanComponentBuilder configuration(InfinispanConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public InfinispanComponentBuilder hosts(String hosts) {
            this.doSetProperty("hosts", hosts);
            return this;
        }

        default public InfinispanComponentBuilder queryBuilder(InfinispanQueryBuilder queryBuilder) {
            this.doSetProperty("queryBuilder", queryBuilder);
            return this;
        }

        default public InfinispanComponentBuilder secure(boolean secure) {
            this.doSetProperty("secure", secure);
            return this;
        }

        default public InfinispanComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public InfinispanComponentBuilder clusteredListener(boolean clusteredListener) {
            this.doSetProperty("clusteredListener", clusteredListener);
            return this;
        }

        @Deprecated
        default public InfinispanComponentBuilder command(String command) {
            this.doSetProperty("command", command);
            return this;
        }

        default public InfinispanComponentBuilder customListener(InfinispanCustomListener customListener) {
            this.doSetProperty("customListener", customListener);
            return this;
        }

        default public InfinispanComponentBuilder eventTypes(String eventTypes) {
            this.doSetProperty("eventTypes", eventTypes);
            return this;
        }

        default public InfinispanComponentBuilder sync(boolean sync) {
            this.doSetProperty("sync", sync);
            return this;
        }

        default public InfinispanComponentBuilder defaultValue(Object defaultValue) {
            this.doSetProperty("defaultValue", defaultValue);
            return this;
        }

        default public InfinispanComponentBuilder key(Object key) {
            this.doSetProperty("key", key);
            return this;
        }

        default public InfinispanComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public InfinispanComponentBuilder oldValue(Object oldValue) {
            this.doSetProperty("oldValue", oldValue);
            return this;
        }

        default public InfinispanComponentBuilder operation(InfinispanOperation operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public InfinispanComponentBuilder value(Object value) {
            this.doSetProperty("value", value);
            return this;
        }

        default public InfinispanComponentBuilder password(String password) {
            this.doSetProperty("password", password);
            return this;
        }

        default public InfinispanComponentBuilder saslMechanism(String saslMechanism) {
            this.doSetProperty("saslMechanism", saslMechanism);
            return this;
        }

        default public InfinispanComponentBuilder securityRealm(String securityRealm) {
            this.doSetProperty("securityRealm", securityRealm);
            return this;
        }

        default public InfinispanComponentBuilder securityServerName(String securityServerName) {
            this.doSetProperty("securityServerName", securityServerName);
            return this;
        }

        default public InfinispanComponentBuilder username(String username) {
            this.doSetProperty("username", username);
            return this;
        }

        @Deprecated
        default public InfinispanComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public InfinispanComponentBuilder cacheContainer(BasicCacheContainer cacheContainer) {
            this.doSetProperty("cacheContainer", cacheContainer);
            return this;
        }

        default public InfinispanComponentBuilder cacheContainerConfiguration(Object cacheContainerConfiguration) {
            this.doSetProperty("cacheContainerConfiguration", cacheContainerConfiguration);
            return this;
        }

        default public InfinispanComponentBuilder configurationProperties(Map<String, String> configurationProperties) {
            this.doSetProperty("configurationProperties", configurationProperties);
            return this;
        }

        default public InfinispanComponentBuilder configurationUri(String configurationUri) {
            this.doSetProperty("configurationUri", configurationUri);
            return this;
        }

        default public InfinispanComponentBuilder flags(String flags) {
            this.doSetProperty("flags", flags);
            return this;
        }

        default public InfinispanComponentBuilder remappingFunction(BiFunction remappingFunction) {
            this.doSetProperty("remappingFunction", remappingFunction);
            return this;
        }

        default public InfinispanComponentBuilder resultHeader(Object resultHeader) {
            this.doSetProperty("resultHeader", resultHeader);
            return this;
        }
    }
}

