/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import java.util.List;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.jclouds.JcloudsComponent;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.compute.ComputeService;

public interface JcloudsComponentBuilderFactory {
    public static JcloudsComponentBuilder jclouds() {
        return new JcloudsComponentBuilderImpl();
    }

    public static class JcloudsComponentBuilderImpl
    extends AbstractComponentBuilder<JcloudsComponent>
    implements JcloudsComponentBuilder {
        @Override
        protected JcloudsComponent buildConcreteComponent() {
            return new JcloudsComponent();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "blobStores": {
                    ((JcloudsComponent)component).setBlobStores((List)value);
                    return true;
                }
                case "computeServices": {
                    ((JcloudsComponent)component).setComputeServices((List)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((JcloudsComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((JcloudsComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((JcloudsComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface JcloudsComponentBuilder
    extends ComponentBuilder<JcloudsComponent> {
        default public JcloudsComponentBuilder blobStores(List<BlobStore> blobStores) {
            this.doSetProperty("blobStores", blobStores);
            return this;
        }

        default public JcloudsComponentBuilder computeServices(List<ComputeService> computeServices) {
            this.doSetProperty("computeServices", computeServices);
            return this;
        }

        default public JcloudsComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public JcloudsComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        @Deprecated
        default public JcloudsComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
    }
}

