/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import javax.sql.DataSource;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.jdbc.JdbcComponent;

public interface JdbcComponentBuilderFactory {
    public static JdbcComponentBuilder jdbc() {
        return new JdbcComponentBuilderImpl();
    }

    public static class JdbcComponentBuilderImpl
    extends AbstractComponentBuilder<JdbcComponent>
    implements JdbcComponentBuilder {
        @Override
        protected JdbcComponent buildConcreteComponent() {
            return new JdbcComponent();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "dataSource": {
                    ((JdbcComponent)component).setDataSource((DataSource)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((JdbcComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((JdbcComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface JdbcComponentBuilder
    extends ComponentBuilder<JdbcComponent> {
        default public JdbcComponentBuilder dataSource(DataSource dataSource) {
            this.doSetProperty("dataSource", dataSource);
            return this;
        }

        default public JdbcComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        @Deprecated
        default public JdbcComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
    }
}

