/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.jira.JiraComponent;
import org.apache.camel.component.jira.JiraConfiguration;

public interface JiraComponentBuilderFactory {
    public static JiraComponentBuilder jira() {
        return new JiraComponentBuilderImpl();
    }

    public static class JiraComponentBuilderImpl
    extends AbstractComponentBuilder<JiraComponent>
    implements JiraComponentBuilder {
        @Override
        protected JiraComponent buildConcreteComponent() {
            return new JiraComponent();
        }

        private JiraConfiguration getOrCreateConfiguration(JiraComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new JiraConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "delay": {
                    this.getOrCreateConfiguration((JiraComponent)component).setDelay((Integer)value);
                    return true;
                }
                case "jiraUrl": {
                    this.getOrCreateConfiguration((JiraComponent)component).setJiraUrl((String)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((JiraComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((JiraComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((JiraComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((JiraComponent)component).setConfiguration((JiraConfiguration)value);
                    return true;
                }
                case "accessToken": {
                    this.getOrCreateConfiguration((JiraComponent)component).setAccessToken((String)value);
                    return true;
                }
                case "consumerKey": {
                    this.getOrCreateConfiguration((JiraComponent)component).setConsumerKey((String)value);
                    return true;
                }
                case "password": {
                    this.getOrCreateConfiguration((JiraComponent)component).setPassword((String)value);
                    return true;
                }
                case "privateKey": {
                    this.getOrCreateConfiguration((JiraComponent)component).setPrivateKey((String)value);
                    return true;
                }
                case "username": {
                    this.getOrCreateConfiguration((JiraComponent)component).setUsername((String)value);
                    return true;
                }
                case "verificationCode": {
                    this.getOrCreateConfiguration((JiraComponent)component).setVerificationCode((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface JiraComponentBuilder
    extends ComponentBuilder<JiraComponent> {
        default public JiraComponentBuilder delay(Integer delay) {
            this.doSetProperty("delay", delay);
            return this;
        }

        default public JiraComponentBuilder jiraUrl(String jiraUrl) {
            this.doSetProperty("jiraUrl", jiraUrl);
            return this;
        }

        default public JiraComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public JiraComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        @Deprecated
        default public JiraComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public JiraComponentBuilder configuration(JiraConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public JiraComponentBuilder accessToken(String accessToken) {
            this.doSetProperty("accessToken", accessToken);
            return this;
        }

        default public JiraComponentBuilder consumerKey(String consumerKey) {
            this.doSetProperty("consumerKey", consumerKey);
            return this;
        }

        default public JiraComponentBuilder password(String password) {
            this.doSetProperty("password", password);
            return this;
        }

        default public JiraComponentBuilder privateKey(String privateKey) {
            this.doSetProperty("privateKey", privateKey);
            return this;
        }

        default public JiraComponentBuilder username(String username) {
            this.doSetProperty("username", username);
            return this;
        }

        default public JiraComponentBuilder verificationCode(String verificationCode) {
            this.doSetProperty("verificationCode", verificationCode);
            return this;
        }
    }
}

