/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.jooq.JooqComponent;
import org.apache.camel.component.jooq.JooqConfiguration;
import org.apache.camel.component.jooq.JooqOperation;
import org.jooq.Configuration;

public interface JooqComponentBuilderFactory {
    public static JooqComponentBuilder jooq() {
        return new JooqComponentBuilderImpl();
    }

    public static class JooqComponentBuilderImpl
    extends AbstractComponentBuilder<JooqComponent>
    implements JooqComponentBuilder {
        @Override
        protected JooqComponent buildConcreteComponent() {
            return new JooqComponent();
        }

        private JooqConfiguration getOrCreateConfiguration(JooqComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new JooqConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((JooqComponent)component).setConfiguration((JooqConfiguration)value);
                    return true;
                }
                case "databaseConfiguration": {
                    this.getOrCreateConfiguration((JooqComponent)component).setDatabaseConfiguration((Configuration)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((JooqComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "consumeDelete": {
                    this.getOrCreateConfiguration((JooqComponent)component).setConsumeDelete(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((JooqComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((JooqComponent)component).setOperation((JooqOperation)value);
                    return true;
                }
                case "query": {
                    this.getOrCreateConfiguration((JooqComponent)component).setQuery((String)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((JooqComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface JooqComponentBuilder
    extends ComponentBuilder<JooqComponent> {
        default public JooqComponentBuilder configuration(JooqConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public JooqComponentBuilder databaseConfiguration(Configuration databaseConfiguration) {
            this.doSetProperty("databaseConfiguration", databaseConfiguration);
            return this;
        }

        default public JooqComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public JooqComponentBuilder consumeDelete(boolean consumeDelete) {
            this.doSetProperty("consumeDelete", consumeDelete);
            return this;
        }

        default public JooqComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public JooqComponentBuilder operation(JooqOperation operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public JooqComponentBuilder query(String query) {
            this.doSetProperty("query", query);
            return this;
        }

        @Deprecated
        default public JooqComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
    }
}

