/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.olingo2.Olingo2Component;
import org.apache.camel.component.olingo2.Olingo2Configuration;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.http.HttpHost;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.olingo.odata2.api.ep.EntityProviderReadProperties;
import org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties;

public interface Olingo2ComponentBuilderFactory {
    public static Olingo2ComponentBuilder olingo2() {
        return new Olingo2ComponentBuilderImpl();
    }

    public static class Olingo2ComponentBuilderImpl
    extends AbstractComponentBuilder<Olingo2Component>
    implements Olingo2ComponentBuilder {
        @Override
        protected Olingo2Component buildConcreteComponent() {
            return new Olingo2Component();
        }

        private Olingo2Configuration getOrCreateConfiguration(Olingo2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new Olingo2Configuration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((Olingo2Component)component).setConfiguration((Olingo2Configuration)value);
                    return true;
                }
                case "connectTimeout": {
                    this.getOrCreateConfiguration((Olingo2Component)component).setConnectTimeout(((Integer)value).intValue());
                    return true;
                }
                case "contentType": {
                    this.getOrCreateConfiguration((Olingo2Component)component).setContentType((String)value);
                    return true;
                }
                case "entityProviderReadProperties": {
                    this.getOrCreateConfiguration((Olingo2Component)component).setEntityProviderReadProperties((EntityProviderReadProperties)value);
                    return true;
                }
                case "entityProviderWriteProperties": {
                    this.getOrCreateConfiguration((Olingo2Component)component).setEntityProviderWriteProperties((EntityProviderWriteProperties)value);
                    return true;
                }
                case "filterAlreadySeen": {
                    this.getOrCreateConfiguration((Olingo2Component)component).setFilterAlreadySeen(((Boolean)value).booleanValue());
                    return true;
                }
                case "httpHeaders": {
                    this.getOrCreateConfiguration((Olingo2Component)component).setHttpHeaders((Map)value);
                    return true;
                }
                case "proxy": {
                    this.getOrCreateConfiguration((Olingo2Component)component).setProxy((HttpHost)value);
                    return true;
                }
                case "serviceUri": {
                    this.getOrCreateConfiguration((Olingo2Component)component).setServiceUri((String)value);
                    return true;
                }
                case "socketTimeout": {
                    this.getOrCreateConfiguration((Olingo2Component)component).setSocketTimeout(((Integer)value).intValue());
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((Olingo2Component)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "splitResult": {
                    this.getOrCreateConfiguration((Olingo2Component)component).setSplitResult(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((Olingo2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((Olingo2Component)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "httpAsyncClientBuilder": {
                    this.getOrCreateConfiguration((Olingo2Component)component).setHttpAsyncClientBuilder((HttpAsyncClientBuilder)value);
                    return true;
                }
                case "httpClientBuilder": {
                    this.getOrCreateConfiguration((Olingo2Component)component).setHttpClientBuilder((HttpClientBuilder)value);
                    return true;
                }
                case "sslContextParameters": {
                    this.getOrCreateConfiguration((Olingo2Component)component).setSslContextParameters((SSLContextParameters)value);
                    return true;
                }
                case "useGlobalSslContextParameters": {
                    ((Olingo2Component)component).setUseGlobalSslContextParameters(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Olingo2ComponentBuilder
    extends ComponentBuilder<Olingo2Component> {
        default public Olingo2ComponentBuilder configuration(Olingo2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Olingo2ComponentBuilder connectTimeout(int connectTimeout) {
            this.doSetProperty("connectTimeout", connectTimeout);
            return this;
        }

        default public Olingo2ComponentBuilder contentType(String contentType) {
            this.doSetProperty("contentType", contentType);
            return this;
        }

        default public Olingo2ComponentBuilder entityProviderReadProperties(EntityProviderReadProperties entityProviderReadProperties) {
            this.doSetProperty("entityProviderReadProperties", entityProviderReadProperties);
            return this;
        }

        default public Olingo2ComponentBuilder entityProviderWriteProperties(EntityProviderWriteProperties entityProviderWriteProperties) {
            this.doSetProperty("entityProviderWriteProperties", entityProviderWriteProperties);
            return this;
        }

        default public Olingo2ComponentBuilder filterAlreadySeen(boolean filterAlreadySeen) {
            this.doSetProperty("filterAlreadySeen", filterAlreadySeen);
            return this;
        }

        default public Olingo2ComponentBuilder httpHeaders(Map<String, String> httpHeaders) {
            this.doSetProperty("httpHeaders", httpHeaders);
            return this;
        }

        default public Olingo2ComponentBuilder proxy(HttpHost proxy) {
            this.doSetProperty("proxy", proxy);
            return this;
        }

        default public Olingo2ComponentBuilder serviceUri(String serviceUri) {
            this.doSetProperty("serviceUri", serviceUri);
            return this;
        }

        default public Olingo2ComponentBuilder socketTimeout(int socketTimeout) {
            this.doSetProperty("socketTimeout", socketTimeout);
            return this;
        }

        default public Olingo2ComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public Olingo2ComponentBuilder splitResult(boolean splitResult) {
            this.doSetProperty("splitResult", splitResult);
            return this;
        }

        default public Olingo2ComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        @Deprecated
        default public Olingo2ComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public Olingo2ComponentBuilder httpAsyncClientBuilder(HttpAsyncClientBuilder httpAsyncClientBuilder) {
            this.doSetProperty("httpAsyncClientBuilder", httpAsyncClientBuilder);
            return this;
        }

        default public Olingo2ComponentBuilder httpClientBuilder(HttpClientBuilder httpClientBuilder) {
            this.doSetProperty("httpClientBuilder", httpClientBuilder);
            return this;
        }

        default public Olingo2ComponentBuilder sslContextParameters(SSLContextParameters sslContextParameters) {
            this.doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }

        default public Olingo2ComponentBuilder useGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
            this.doSetProperty("useGlobalSslContextParameters", useGlobalSslContextParameters);
            return this;
        }
    }
}

