/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.paho.PahoComponent;
import org.apache.camel.component.paho.PahoConfiguration;
import org.apache.camel.component.paho.PahoPersistence;
import org.eclipse.paho.client.mqttv3.MqttClient;

public interface PahoComponentBuilderFactory {
    public static PahoComponentBuilder paho() {
        return new PahoComponentBuilderImpl();
    }

    public static class PahoComponentBuilderImpl
    extends AbstractComponentBuilder<PahoComponent>
    implements PahoComponentBuilder {
        @Override
        protected PahoComponent buildConcreteComponent() {
            return new PahoComponent();
        }

        private PahoConfiguration getOrCreateConfiguration(PahoComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new PahoConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "automaticReconnect": {
                    this.getOrCreateConfiguration((PahoComponent)component).setAutomaticReconnect(((Boolean)value).booleanValue());
                    return true;
                }
                case "brokerUrl": {
                    this.getOrCreateConfiguration((PahoComponent)component).setBrokerUrl((String)value);
                    return true;
                }
                case "cleanSession": {
                    this.getOrCreateConfiguration((PahoComponent)component).setCleanSession(((Boolean)value).booleanValue());
                    return true;
                }
                case "clientId": {
                    this.getOrCreateConfiguration((PahoComponent)component).setClientId((String)value);
                    return true;
                }
                case "configuration": {
                    ((PahoComponent)component).setConfiguration((PahoConfiguration)value);
                    return true;
                }
                case "connectionTimeout": {
                    this.getOrCreateConfiguration((PahoComponent)component).setConnectionTimeout(((Integer)value).intValue());
                    return true;
                }
                case "filePersistenceDirectory": {
                    this.getOrCreateConfiguration((PahoComponent)component).setFilePersistenceDirectory((String)value);
                    return true;
                }
                case "keepAliveInterval": {
                    this.getOrCreateConfiguration((PahoComponent)component).setKeepAliveInterval(((Integer)value).intValue());
                    return true;
                }
                case "maxInflight": {
                    this.getOrCreateConfiguration((PahoComponent)component).setMaxInflight(((Integer)value).intValue());
                    return true;
                }
                case "maxReconnectDelay": {
                    this.getOrCreateConfiguration((PahoComponent)component).setMaxReconnectDelay(((Integer)value).intValue());
                    return true;
                }
                case "mqttVersion": {
                    this.getOrCreateConfiguration((PahoComponent)component).setMqttVersion(((Integer)value).intValue());
                    return true;
                }
                case "persistence": {
                    this.getOrCreateConfiguration((PahoComponent)component).setPersistence((PahoPersistence)value);
                    return true;
                }
                case "qos": {
                    this.getOrCreateConfiguration((PahoComponent)component).setQos(((Integer)value).intValue());
                    return true;
                }
                case "retained": {
                    this.getOrCreateConfiguration((PahoComponent)component).setRetained(((Boolean)value).booleanValue());
                    return true;
                }
                case "serverURIs": {
                    this.getOrCreateConfiguration((PahoComponent)component).setServerURIs((String)value);
                    return true;
                }
                case "willPayload": {
                    this.getOrCreateConfiguration((PahoComponent)component).setWillPayload((String)value);
                    return true;
                }
                case "willQos": {
                    this.getOrCreateConfiguration((PahoComponent)component).setWillQos(((Integer)value).intValue());
                    return true;
                }
                case "willRetained": {
                    this.getOrCreateConfiguration((PahoComponent)component).setWillRetained(((Boolean)value).booleanValue());
                    return true;
                }
                case "willTopic": {
                    this.getOrCreateConfiguration((PahoComponent)component).setWillTopic((String)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((PahoComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((PahoComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((PahoComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "client": {
                    ((PahoComponent)component).setClient((MqttClient)value);
                    return true;
                }
                case "customWebSocketHeaders": {
                    this.getOrCreateConfiguration((PahoComponent)component).setCustomWebSocketHeaders((Properties)value);
                    return true;
                }
                case "executorServiceTimeout": {
                    this.getOrCreateConfiguration((PahoComponent)component).setExecutorServiceTimeout(((Integer)value).intValue());
                    return true;
                }
                case "httpsHostnameVerificationEnabled": {
                    this.getOrCreateConfiguration((PahoComponent)component).setHttpsHostnameVerificationEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "password": {
                    this.getOrCreateConfiguration((PahoComponent)component).setPassword((String)value);
                    return true;
                }
                case "socketFactory": {
                    this.getOrCreateConfiguration((PahoComponent)component).setSocketFactory((SocketFactory)value);
                    return true;
                }
                case "sslClientProps": {
                    this.getOrCreateConfiguration((PahoComponent)component).setSslClientProps((Properties)value);
                    return true;
                }
                case "sslHostnameVerifier": {
                    this.getOrCreateConfiguration((PahoComponent)component).setSslHostnameVerifier((HostnameVerifier)value);
                    return true;
                }
                case "userName": {
                    this.getOrCreateConfiguration((PahoComponent)component).setUserName((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface PahoComponentBuilder
    extends ComponentBuilder<PahoComponent> {
        default public PahoComponentBuilder automaticReconnect(boolean automaticReconnect) {
            this.doSetProperty("automaticReconnect", automaticReconnect);
            return this;
        }

        default public PahoComponentBuilder brokerUrl(String brokerUrl) {
            this.doSetProperty("brokerUrl", brokerUrl);
            return this;
        }

        default public PahoComponentBuilder cleanSession(boolean cleanSession) {
            this.doSetProperty("cleanSession", cleanSession);
            return this;
        }

        default public PahoComponentBuilder clientId(String clientId) {
            this.doSetProperty("clientId", clientId);
            return this;
        }

        default public PahoComponentBuilder configuration(PahoConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public PahoComponentBuilder connectionTimeout(int connectionTimeout) {
            this.doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }

        default public PahoComponentBuilder filePersistenceDirectory(String filePersistenceDirectory) {
            this.doSetProperty("filePersistenceDirectory", filePersistenceDirectory);
            return this;
        }

        default public PahoComponentBuilder keepAliveInterval(int keepAliveInterval) {
            this.doSetProperty("keepAliveInterval", keepAliveInterval);
            return this;
        }

        default public PahoComponentBuilder maxInflight(int maxInflight) {
            this.doSetProperty("maxInflight", maxInflight);
            return this;
        }

        default public PahoComponentBuilder maxReconnectDelay(int maxReconnectDelay) {
            this.doSetProperty("maxReconnectDelay", maxReconnectDelay);
            return this;
        }

        default public PahoComponentBuilder mqttVersion(int mqttVersion) {
            this.doSetProperty("mqttVersion", mqttVersion);
            return this;
        }

        default public PahoComponentBuilder persistence(PahoPersistence persistence) {
            this.doSetProperty("persistence", persistence);
            return this;
        }

        default public PahoComponentBuilder qos(int qos) {
            this.doSetProperty("qos", qos);
            return this;
        }

        default public PahoComponentBuilder retained(boolean retained) {
            this.doSetProperty("retained", retained);
            return this;
        }

        default public PahoComponentBuilder serverURIs(String serverURIs) {
            this.doSetProperty("serverURIs", serverURIs);
            return this;
        }

        default public PahoComponentBuilder willPayload(String willPayload) {
            this.doSetProperty("willPayload", willPayload);
            return this;
        }

        default public PahoComponentBuilder willQos(int willQos) {
            this.doSetProperty("willQos", willQos);
            return this;
        }

        default public PahoComponentBuilder willRetained(boolean willRetained) {
            this.doSetProperty("willRetained", willRetained);
            return this;
        }

        default public PahoComponentBuilder willTopic(String willTopic) {
            this.doSetProperty("willTopic", willTopic);
            return this;
        }

        default public PahoComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public PahoComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        @Deprecated
        default public PahoComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public PahoComponentBuilder client(MqttClient client) {
            this.doSetProperty("client", client);
            return this;
        }

        default public PahoComponentBuilder customWebSocketHeaders(Properties customWebSocketHeaders) {
            this.doSetProperty("customWebSocketHeaders", customWebSocketHeaders);
            return this;
        }

        default public PahoComponentBuilder executorServiceTimeout(int executorServiceTimeout) {
            this.doSetProperty("executorServiceTimeout", executorServiceTimeout);
            return this;
        }

        default public PahoComponentBuilder httpsHostnameVerificationEnabled(boolean httpsHostnameVerificationEnabled) {
            this.doSetProperty("httpsHostnameVerificationEnabled", httpsHostnameVerificationEnabled);
            return this;
        }

        default public PahoComponentBuilder password(String password) {
            this.doSetProperty("password", password);
            return this;
        }

        default public PahoComponentBuilder socketFactory(SocketFactory socketFactory) {
            this.doSetProperty("socketFactory", socketFactory);
            return this;
        }

        default public PahoComponentBuilder sslClientProps(Properties sslClientProps) {
            this.doSetProperty("sslClientProps", sslClientProps);
            return this;
        }

        default public PahoComponentBuilder sslHostnameVerifier(HostnameVerifier sslHostnameVerifier) {
            this.doSetProperty("sslHostnameVerifier", sslHostnameVerifier);
            return this;
        }

        default public PahoComponentBuilder userName(String userName) {
            this.doSetProperty("userName", userName);
            return this;
        }
    }
}

