/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.spring.batch.SpringBatchComponent;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.launch.JobLauncher;

public interface SpringBatchComponentBuilderFactory {
    public static SpringBatchComponentBuilder springBatch() {
        return new SpringBatchComponentBuilderImpl();
    }

    public static class SpringBatchComponentBuilderImpl
    extends AbstractComponentBuilder<SpringBatchComponent>
    implements SpringBatchComponentBuilder {
        @Override
        protected SpringBatchComponent buildConcreteComponent() {
            return new SpringBatchComponent();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "jobLauncher": {
                    ((SpringBatchComponent)component).setJobLauncher((JobLauncher)value);
                    return true;
                }
                case "jobRegistry": {
                    ((SpringBatchComponent)component).setJobRegistry((JobRegistry)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((SpringBatchComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((SpringBatchComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface SpringBatchComponentBuilder
    extends ComponentBuilder<SpringBatchComponent> {
        default public SpringBatchComponentBuilder jobLauncher(JobLauncher jobLauncher) {
            this.doSetProperty("jobLauncher", jobLauncher);
            return this;
        }

        default public SpringBatchComponentBuilder jobRegistry(JobRegistry jobRegistry) {
            this.doSetProperty("jobRegistry", jobRegistry);
            return this;
        }

        default public SpringBatchComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        @Deprecated
        default public SpringBatchComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
    }
}

