/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import java.util.Properties;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.stomp.StompComponent;
import org.apache.camel.component.stomp.StompConfiguration;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.jsse.SSLContextParameters;

public interface StompComponentBuilderFactory {
    public static StompComponentBuilder stomp() {
        return new StompComponentBuilderImpl();
    }

    public static class StompComponentBuilderImpl
    extends AbstractComponentBuilder<StompComponent>
    implements StompComponentBuilder {
        @Override
        protected StompComponent buildConcreteComponent() {
            return new StompComponent();
        }

        private StompConfiguration getOrCreateConfiguration(StompComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new StompConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "brokerURL": {
                    this.getOrCreateConfiguration((StompComponent)component).setBrokerURL((String)value);
                    return true;
                }
                case "customHeaders": {
                    this.getOrCreateConfiguration((StompComponent)component).setCustomHeaders((Properties)value);
                    return true;
                }
                case "host": {
                    this.getOrCreateConfiguration((StompComponent)component).setHost((String)value);
                    return true;
                }
                case "version": {
                    this.getOrCreateConfiguration((StompComponent)component).setVersion((String)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((StompComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((StompComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((StompComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((StompComponent)component).setConfiguration((StompConfiguration)value);
                    return true;
                }
                case "headerFilterStrategy": {
                    ((StompComponent)component).setHeaderFilterStrategy((HeaderFilterStrategy)value);
                    return true;
                }
                case "login": {
                    this.getOrCreateConfiguration((StompComponent)component).setLogin((String)value);
                    return true;
                }
                case "passcode": {
                    this.getOrCreateConfiguration((StompComponent)component).setPasscode((String)value);
                    return true;
                }
                case "sslContextParameters": {
                    this.getOrCreateConfiguration((StompComponent)component).setSslContextParameters((SSLContextParameters)value);
                    return true;
                }
                case "useGlobalSslContextParameters": {
                    ((StompComponent)component).setUseGlobalSslContextParameters(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface StompComponentBuilder
    extends ComponentBuilder<StompComponent> {
        default public StompComponentBuilder brokerURL(String brokerURL) {
            this.doSetProperty("brokerURL", brokerURL);
            return this;
        }

        default public StompComponentBuilder customHeaders(Properties customHeaders) {
            this.doSetProperty("customHeaders", customHeaders);
            return this;
        }

        default public StompComponentBuilder host(String host) {
            this.doSetProperty("host", host);
            return this;
        }

        default public StompComponentBuilder version(String version) {
            this.doSetProperty("version", version);
            return this;
        }

        default public StompComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public StompComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        @Deprecated
        default public StompComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public StompComponentBuilder configuration(StompConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public StompComponentBuilder headerFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
            this.doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }

        default public StompComponentBuilder login(String login) {
            this.doSetProperty("login", login);
            return this;
        }

        default public StompComponentBuilder passcode(String passcode) {
            this.doSetProperty("passcode", passcode);
            return this;
        }

        default public StompComponentBuilder sslContextParameters(SSLContextParameters sslContextParameters) {
            this.doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }

        default public StompComponentBuilder useGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
            this.doSetProperty("useGlobalSslContextParameters", useGlobalSslContextParameters);
            return this;
        }
    }
}

