/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.webhook.WebhookComponent;
import org.apache.camel.component.webhook.WebhookConfiguration;

public interface WebhookComponentBuilderFactory {
    public static WebhookComponentBuilder webhook() {
        return new WebhookComponentBuilderImpl();
    }

    public static class WebhookComponentBuilderImpl
    extends AbstractComponentBuilder<WebhookComponent>
    implements WebhookComponentBuilder {
        @Override
        protected WebhookComponent buildConcreteComponent() {
            return new WebhookComponent();
        }

        private WebhookConfiguration getOrCreateConfiguration(WebhookComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new WebhookConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "bridgeErrorHandler": {
                    ((WebhookComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "webhookAutoRegister": {
                    this.getOrCreateConfiguration((WebhookComponent)component).setWebhookAutoRegister(((Boolean)value).booleanValue());
                    return true;
                }
                case "webhookBasePath": {
                    this.getOrCreateConfiguration((WebhookComponent)component).setWebhookBasePath((String)value);
                    return true;
                }
                case "webhookComponentName": {
                    this.getOrCreateConfiguration((WebhookComponent)component).setWebhookComponentName((String)value);
                    return true;
                }
                case "webhookExternalUrl": {
                    this.getOrCreateConfiguration((WebhookComponent)component).setWebhookExternalUrl((String)value);
                    return true;
                }
                case "webhookPath": {
                    this.getOrCreateConfiguration((WebhookComponent)component).setWebhookPath((String)value);
                    return true;
                }
                case "basicPropertyBinding": {
                    ((WebhookComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((WebhookComponent)component).setConfiguration((WebhookConfiguration)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface WebhookComponentBuilder
    extends ComponentBuilder<WebhookComponent> {
        default public WebhookComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public WebhookComponentBuilder webhookAutoRegister(boolean webhookAutoRegister) {
            this.doSetProperty("webhookAutoRegister", webhookAutoRegister);
            return this;
        }

        default public WebhookComponentBuilder webhookBasePath(String webhookBasePath) {
            this.doSetProperty("webhookBasePath", webhookBasePath);
            return this;
        }

        default public WebhookComponentBuilder webhookComponentName(String webhookComponentName) {
            this.doSetProperty("webhookComponentName", webhookComponentName);
            return this;
        }

        default public WebhookComponentBuilder webhookExternalUrl(String webhookExternalUrl) {
            this.doSetProperty("webhookExternalUrl", webhookExternalUrl);
            return this;
        }

        default public WebhookComponentBuilder webhookPath(String webhookPath) {
            this.doSetProperty("webhookPath", webhookPath);
            return this;
        }

        @Deprecated
        default public WebhookComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public WebhookComponentBuilder configuration(WebhookConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }
    }
}

