/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.zookeeper.ZooKeeperComponent;
import org.apache.camel.component.zookeeper.ZooKeeperConfiguration;

public interface ZookeeperComponentBuilderFactory {
    public static ZookeeperComponentBuilder zookeeper() {
        return new ZookeeperComponentBuilderImpl();
    }

    public static class ZookeeperComponentBuilderImpl
    extends AbstractComponentBuilder<ZooKeeperComponent>
    implements ZookeeperComponentBuilder {
        @Override
        protected ZooKeeperComponent buildConcreteComponent() {
            return new ZooKeeperComponent();
        }

        private ZooKeeperConfiguration getOrCreateConfiguration(ZooKeeperComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new ZooKeeperConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "listChildren": {
                    this.getOrCreateConfiguration((ZooKeeperComponent)component).setListChildren(((Boolean)value).booleanValue());
                    return true;
                }
                case "timeout": {
                    this.getOrCreateConfiguration((ZooKeeperComponent)component).setTimeout(((Integer)value).intValue());
                    return true;
                }
                case "backoff": {
                    this.getOrCreateConfiguration((ZooKeeperComponent)component).setBackoff(((Long)value).longValue());
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((ZooKeeperComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "repeat": {
                    this.getOrCreateConfiguration((ZooKeeperComponent)component).setRepeat(((Boolean)value).booleanValue());
                    return true;
                }
                case "sendEmptyMessageOnDelete": {
                    this.getOrCreateConfiguration((ZooKeeperComponent)component).setSendEmptyMessageOnDelete(((Boolean)value).booleanValue());
                    return true;
                }
                case "create": {
                    this.getOrCreateConfiguration((ZooKeeperComponent)component).setCreate(((Boolean)value).booleanValue());
                    return true;
                }
                case "createMode": {
                    this.getOrCreateConfiguration((ZooKeeperComponent)component).setCreateMode((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((ZooKeeperComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "basicPropertyBinding": {
                    ((ZooKeeperComponent)component).setBasicPropertyBinding(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((ZooKeeperComponent)component).setConfiguration((ZooKeeperConfiguration)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface ZookeeperComponentBuilder
    extends ComponentBuilder<ZooKeeperComponent> {
        default public ZookeeperComponentBuilder listChildren(boolean listChildren) {
            this.doSetProperty("listChildren", listChildren);
            return this;
        }

        default public ZookeeperComponentBuilder timeout(int timeout) {
            this.doSetProperty("timeout", timeout);
            return this;
        }

        default public ZookeeperComponentBuilder backoff(long backoff) {
            this.doSetProperty("backoff", backoff);
            return this;
        }

        default public ZookeeperComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public ZookeeperComponentBuilder repeat(boolean repeat) {
            this.doSetProperty("repeat", repeat);
            return this;
        }

        default public ZookeeperComponentBuilder sendEmptyMessageOnDelete(boolean sendEmptyMessageOnDelete) {
            this.doSetProperty("sendEmptyMessageOnDelete", sendEmptyMessageOnDelete);
            return this;
        }

        default public ZookeeperComponentBuilder create(boolean create) {
            this.doSetProperty("create", create);
            return this;
        }

        default public ZookeeperComponentBuilder createMode(String createMode) {
            this.doSetProperty("createMode", createMode);
            return this;
        }

        default public ZookeeperComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        @Deprecated
        default public ZookeeperComponentBuilder basicPropertyBinding(boolean basicPropertyBinding) {
            this.doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }

        default public ZookeeperComponentBuilder configuration(ZooKeeperConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }
    }
}

