/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.azure.blob.BlobServiceComponent;

/**
 * Store and retrieve blobs from Azure Storage Blob Service.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface AzureBlobComponentBuilderFactory {

    /**
     * Azure Storage Blob Service (Deprecated) (camel-azure)
     * Store and retrieve blobs from Azure Storage Blob Service.
     * 
     * Category: cloud,file
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-azure
     */
    @Deprecated
    static AzureBlobComponentBuilder azureBlob() {
        return new AzureBlobComponentBuilderImpl();
    }

    /**
     * Builder for the Azure Storage Blob Service (Deprecated) component.
     */
    interface AzureBlobComponentBuilder
            extends
                ComponentBuilder<BlobServiceComponent> {
        /**
         * The blob service client.
         * 
         * The option is a:
         * <code>com.microsoft.azure.storage.blob.CloudBlob</code> type.
         * 
         * Group: common
         */
        default AzureBlobComponentBuilder azureBlobClient(
                com.microsoft.azure.storage.blob.CloudBlob azureBlobClient) {
            doSetProperty("azureBlobClient", azureBlobClient);
            return this;
        }
        /**
         * Set the blob offset for the upload or download operations, default is
         * 0.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Default: 0
         * Group: common
         */
        default AzureBlobComponentBuilder blobOffset(java.lang.Long blobOffset) {
            doSetProperty("blobOffset", blobOffset);
            return this;
        }
        /**
         * Set a blob type, 'blockblob' is default.
         * 
         * The option is a:
         * <code>org.apache.camel.component.azure.blob.BlobType</code> type.
         * 
         * Default: blockblob
         * Group: common
         */
        default AzureBlobComponentBuilder blobType(
                org.apache.camel.component.azure.blob.BlobType blobType) {
            doSetProperty("blobType", blobType);
            return this;
        }
        /**
         * Close the stream after read or keep it open, default is true.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default AzureBlobComponentBuilder closeStreamAfterRead(
                boolean closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * Set the storage credentials, required in most cases.
         * 
         * The option is a:
         * <code>com.microsoft.azure.storage.StorageCredentials</code> type.
         * 
         * Group: common
         */
        default AzureBlobComponentBuilder credentials(
                com.microsoft.azure.storage.StorageCredentials credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * Set the data length for the download or page blob upload operations.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default AzureBlobComponentBuilder dataLength(java.lang.Long dataLength) {
            doSetProperty("dataLength", dataLength);
            return this;
        }
        /**
         * Set the file directory where the downloaded blobs will be saved to.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default AzureBlobComponentBuilder fileDir(java.lang.String fileDir) {
            doSetProperty("fileDir", fileDir);
            return this;
        }
        /**
         * Storage resources can be public for reading their content, if this
         * property is enabled then the credentials do not have to be set.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default AzureBlobComponentBuilder publicForRead(boolean publicForRead) {
            doSetProperty("publicForRead", publicForRead);
            return this;
        }
        /**
         * Set the minimum read size in bytes when reading the blob content.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default AzureBlobComponentBuilder streamReadSize(int streamReadSize) {
            doSetProperty("streamReadSize", streamReadSize);
            return this;
        }
        /**
         * Whether to validate the Azure client URI.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         */
        default AzureBlobComponentBuilder validateClientURI(
                boolean validateClientURI) {
            doSetProperty("validateClientURI", validateClientURI);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default AzureBlobComponentBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Set the blob meta-data.
         * 
         * The option is a: <code>java.util.Map<java.lang.String,
         * java.lang.String></code> type.
         * 
         * Group: producer
         */
        default AzureBlobComponentBuilder blobMetadata(
                java.util.Map<java.lang.String, java.lang.String> blobMetadata) {
            doSetProperty("blobMetadata", blobMetadata);
            return this;
        }
        /**
         * Set a prefix which can be used for listing the blobs.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default AzureBlobComponentBuilder blobPrefix(java.lang.String blobPrefix) {
            doSetProperty("blobPrefix", blobPrefix);
            return this;
        }
        /**
         * Close the stream after write or keep it open, default is true.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         */
        default AzureBlobComponentBuilder closeStreamAfterWrite(
                boolean closeStreamAfterWrite) {
            doSetProperty("closeStreamAfterWrite", closeStreamAfterWrite);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default AzureBlobComponentBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Blob service operation hint to the producer.
         * 
         * The option is a:
         * <code>org.apache.camel.component.azure.blob.BlobServiceOperations</code> type.
         * 
         * Default: listBlobs
         * Group: producer
         */
        default AzureBlobComponentBuilder operation(
                org.apache.camel.component.azure.blob.BlobServiceOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Set the size of the buffer for writing block and page blocks.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: producer
         */
        default AzureBlobComponentBuilder streamWriteSize(int streamWriteSize) {
            doSetProperty("streamWriteSize", streamWriteSize);
            return this;
        }
        /**
         * Specify if the flat or hierarchical blob listing should be used.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         */
        default AzureBlobComponentBuilder useFlatListing(boolean useFlatListing) {
            doSetProperty("useFlatListing", useFlatListing);
            return this;
        }
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default AzureBlobComponentBuilder autowiredEnabled(
                boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
        /**
         * The Blob Service configuration.
         * 
         * The option is a:
         * <code>org.apache.camel.component.azure.blob.BlobServiceConfiguration</code> type.
         * 
         * Group: advanced
         */
        default AzureBlobComponentBuilder configuration(
                org.apache.camel.component.azure.blob.BlobServiceConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * Set the storage account key used during authentication phase.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default AzureBlobComponentBuilder credentialsAccountKey(
                java.lang.String credentialsAccountKey) {
            doSetProperty("credentialsAccountKey", credentialsAccountKey);
            return this;
        }
        /**
         * Set the storage account name used during authentication phase.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default AzureBlobComponentBuilder credentialsAccountName(
                java.lang.String credentialsAccountName) {
            doSetProperty("credentialsAccountName", credentialsAccountName);
            return this;
        }
    }

    class AzureBlobComponentBuilderImpl
            extends
                AbstractComponentBuilder<BlobServiceComponent>
            implements
                AzureBlobComponentBuilder {
        @Override
        protected BlobServiceComponent buildConcreteComponent() {
            return new BlobServiceComponent();
        }
        private org.apache.camel.component.azure.blob.BlobServiceConfiguration getOrCreateConfiguration(
                org.apache.camel.component.azure.blob.BlobServiceComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.azure.blob.BlobServiceConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "azureBlobClient": getOrCreateConfiguration((BlobServiceComponent) component).setAzureBlobClient((com.microsoft.azure.storage.blob.CloudBlob) value); return true;
            case "blobOffset": getOrCreateConfiguration((BlobServiceComponent) component).setBlobOffset((java.lang.Long) value); return true;
            case "blobType": getOrCreateConfiguration((BlobServiceComponent) component).setBlobType((org.apache.camel.component.azure.blob.BlobType) value); return true;
            case "closeStreamAfterRead": getOrCreateConfiguration((BlobServiceComponent) component).setCloseStreamAfterRead((boolean) value); return true;
            case "credentials": getOrCreateConfiguration((BlobServiceComponent) component).setCredentials((com.microsoft.azure.storage.StorageCredentials) value); return true;
            case "dataLength": getOrCreateConfiguration((BlobServiceComponent) component).setDataLength((java.lang.Long) value); return true;
            case "fileDir": getOrCreateConfiguration((BlobServiceComponent) component).setFileDir((java.lang.String) value); return true;
            case "publicForRead": getOrCreateConfiguration((BlobServiceComponent) component).setPublicForRead((boolean) value); return true;
            case "streamReadSize": getOrCreateConfiguration((BlobServiceComponent) component).setStreamReadSize((int) value); return true;
            case "validateClientURI": getOrCreateConfiguration((BlobServiceComponent) component).setValidateClientURI((boolean) value); return true;
            case "bridgeErrorHandler": ((BlobServiceComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "blobMetadata": getOrCreateConfiguration((BlobServiceComponent) component).setBlobMetadata((java.util.Map) value); return true;
            case "blobPrefix": getOrCreateConfiguration((BlobServiceComponent) component).setBlobPrefix((java.lang.String) value); return true;
            case "closeStreamAfterWrite": getOrCreateConfiguration((BlobServiceComponent) component).setCloseStreamAfterWrite((boolean) value); return true;
            case "lazyStartProducer": ((BlobServiceComponent) component).setLazyStartProducer((boolean) value); return true;
            case "operation": getOrCreateConfiguration((BlobServiceComponent) component).setOperation((org.apache.camel.component.azure.blob.BlobServiceOperations) value); return true;
            case "streamWriteSize": getOrCreateConfiguration((BlobServiceComponent) component).setStreamWriteSize((int) value); return true;
            case "useFlatListing": getOrCreateConfiguration((BlobServiceComponent) component).setUseFlatListing((boolean) value); return true;
            case "autowiredEnabled": ((BlobServiceComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "configuration": ((BlobServiceComponent) component).setConfiguration((org.apache.camel.component.azure.blob.BlobServiceConfiguration) value); return true;
            case "credentialsAccountKey": getOrCreateConfiguration((BlobServiceComponent) component).setCredentialsAccountKey((java.lang.String) value); return true;
            case "credentialsAccountName": getOrCreateConfiguration((BlobServiceComponent) component).setCredentialsAccountName((java.lang.String) value); return true;
            default: return false;
            }
        }
    }
}