/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.google.calendar.stream.GoogleCalendarStreamComponent;

/**
 * Poll for changes in a Google Calendar.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface GoogleCalendarStreamComponentBuilderFactory {

    /**
     * Google Calendar Stream (camel-google-calendar)
     * Poll for changes in a Google Calendar.
     * 
     * Category: api,cloud
     * Since: 2.23
     * Maven coordinates: org.apache.camel:camel-google-calendar
     */
    static GoogleCalendarStreamComponentBuilder googleCalendarStream() {
        return new GoogleCalendarStreamComponentBuilderImpl();
    }

    /**
     * Builder for the Google Calendar Stream component.
     */
    interface GoogleCalendarStreamComponentBuilder
            extends
                ComponentBuilder<GoogleCalendarStreamComponent> {
        /**
         * Google Calendar application name. Example would be
         * camel-google-calendar/1.0.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default GoogleCalendarStreamComponentBuilder applicationName(
                java.lang.String applicationName) {
            doSetProperty("applicationName", applicationName);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default GoogleCalendarStreamComponentBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * The calendarId to be used.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: primary
         * Group: consumer
         */
        default GoogleCalendarStreamComponentBuilder calendarId(
                java.lang.String calendarId) {
            doSetProperty("calendarId", calendarId);
            return this;
        }
        /**
         * Client ID of the calendar application.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default GoogleCalendarStreamComponentBuilder clientId(
                java.lang.String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * The configuration.
         * 
         * The option is a:
         * <code>org.apache.camel.component.google.calendar.stream.GoogleCalendarStreamConfiguration</code> type.
         * 
         * Group: consumer
         */
        default GoogleCalendarStreamComponentBuilder configuration(
                org.apache.camel.component.google.calendar.stream.GoogleCalendarStreamConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * Take into account the lastUpdate of the last event polled as start
         * date for the next poll.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default GoogleCalendarStreamComponentBuilder considerLastUpdate(
                boolean considerLastUpdate) {
            doSetProperty("considerLastUpdate", considerLastUpdate);
            return this;
        }
        /**
         * Consume events in the selected calendar from now on.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         */
        default GoogleCalendarStreamComponentBuilder consumeFromNow(
                boolean consumeFromNow) {
            doSetProperty("consumeFromNow", consumeFromNow);
            return this;
        }
        /**
         * Max results to be returned.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 10
         * Group: consumer
         */
        default GoogleCalendarStreamComponentBuilder maxResults(int maxResults) {
            doSetProperty("maxResults", maxResults);
            return this;
        }
        /**
         * The query to execute on calendar.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default GoogleCalendarStreamComponentBuilder query(
                java.lang.String query) {
            doSetProperty("query", query);
            return this;
        }
        /**
         * Specifies the level of permissions you want a calendar application to
         * have to a user account. See
         * https://developers.google.com/calendar/auth for more info.
         * 
         * The option is a: <code>java.util.List<java.lang.String></code> type.
         * 
         * Group: consumer
         */
        default GoogleCalendarStreamComponentBuilder scopes(
                java.util.List<java.lang.String> scopes) {
            doSetProperty("scopes", scopes);
            return this;
        }
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default GoogleCalendarStreamComponentBuilder autowiredEnabled(
                boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
        /**
         * The client Factory.
         * 
         * The option is a:
         * <code>org.apache.camel.component.google.calendar.GoogleCalendarClientFactory</code> type.
         * 
         * Group: advanced
         */
        default GoogleCalendarStreamComponentBuilder clientFactory(
                org.apache.camel.component.google.calendar.GoogleCalendarClientFactory clientFactory) {
            doSetProperty("clientFactory", clientFactory);
            return this;
        }
        /**
         * OAuth 2 access token. This typically expires after an hour so
         * refreshToken is recommended for long term usage.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default GoogleCalendarStreamComponentBuilder accessToken(
                java.lang.String accessToken) {
            doSetProperty("accessToken", accessToken);
            return this;
        }
        /**
         * Client secret of the calendar application.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default GoogleCalendarStreamComponentBuilder clientSecret(
                java.lang.String clientSecret) {
            doSetProperty("clientSecret", clientSecret);
            return this;
        }
        /**
         * OAuth 2 refresh token. Using this, the Google Calendar component can
         * obtain a new accessToken whenever the current one expires - a
         * necessity if the application is long-lived.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default GoogleCalendarStreamComponentBuilder refreshToken(
                java.lang.String refreshToken) {
            doSetProperty("refreshToken", refreshToken);
            return this;
        }
    }

    class GoogleCalendarStreamComponentBuilderImpl
            extends
                AbstractComponentBuilder<GoogleCalendarStreamComponent>
            implements
                GoogleCalendarStreamComponentBuilder {
        @Override
        protected GoogleCalendarStreamComponent buildConcreteComponent() {
            return new GoogleCalendarStreamComponent();
        }
        private org.apache.camel.component.google.calendar.stream.GoogleCalendarStreamConfiguration getOrCreateConfiguration(
                org.apache.camel.component.google.calendar.stream.GoogleCalendarStreamComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.google.calendar.stream.GoogleCalendarStreamConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "applicationName": getOrCreateConfiguration((GoogleCalendarStreamComponent) component).setApplicationName((java.lang.String) value); return true;
            case "bridgeErrorHandler": ((GoogleCalendarStreamComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "calendarId": getOrCreateConfiguration((GoogleCalendarStreamComponent) component).setCalendarId((java.lang.String) value); return true;
            case "clientId": getOrCreateConfiguration((GoogleCalendarStreamComponent) component).setClientId((java.lang.String) value); return true;
            case "configuration": ((GoogleCalendarStreamComponent) component).setConfiguration((org.apache.camel.component.google.calendar.stream.GoogleCalendarStreamConfiguration) value); return true;
            case "considerLastUpdate": getOrCreateConfiguration((GoogleCalendarStreamComponent) component).setConsiderLastUpdate((boolean) value); return true;
            case "consumeFromNow": getOrCreateConfiguration((GoogleCalendarStreamComponent) component).setConsumeFromNow((boolean) value); return true;
            case "maxResults": getOrCreateConfiguration((GoogleCalendarStreamComponent) component).setMaxResults((int) value); return true;
            case "query": getOrCreateConfiguration((GoogleCalendarStreamComponent) component).setQuery((java.lang.String) value); return true;
            case "scopes": getOrCreateConfiguration((GoogleCalendarStreamComponent) component).setScopes((java.util.List) value); return true;
            case "autowiredEnabled": ((GoogleCalendarStreamComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "clientFactory": ((GoogleCalendarStreamComponent) component).setClientFactory((org.apache.camel.component.google.calendar.GoogleCalendarClientFactory) value); return true;
            case "accessToken": getOrCreateConfiguration((GoogleCalendarStreamComponent) component).setAccessToken((java.lang.String) value); return true;
            case "clientSecret": getOrCreateConfiguration((GoogleCalendarStreamComponent) component).setClientSecret((java.lang.String) value); return true;
            case "refreshToken": getOrCreateConfiguration((GoogleCalendarStreamComponent) component).setRefreshToken((java.lang.String) value); return true;
            default: return false;
            }
        }
    }
}