/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.rest.swagger.RestSwaggerComponent;

/**
 * Configure REST producers based on a Swagger (OpenAPI) specification document
 * delegating to a component implementing the RestProducerFactory interface.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface RestSwaggerComponentBuilderFactory {

    /**
     * REST Swagger (camel-rest-swagger)
     * Configure REST producers based on a Swagger (OpenAPI) specification
     * document delegating to a component implementing the RestProducerFactory
     * interface.
     * 
     * Category: rest,swagger,http
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-rest-swagger
     */
    static RestSwaggerComponentBuilder restSwagger() {
        return new RestSwaggerComponentBuilderImpl();
    }

    /**
     * Builder for the REST Swagger component.
     */
    interface RestSwaggerComponentBuilder
            extends
                ComponentBuilder<RestSwaggerComponent> {
        /**
         * API basePath, for example /v2. Default is unset, if set overrides the
         * value present in Swagger specification.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default RestSwaggerComponentBuilder basePath(java.lang.String basePath) {
            doSetProperty("basePath", basePath);
            return this;
        }
        /**
         * Name of the Camel component that will perform the requests. The
         * component must be present in Camel registry and it must implement
         * RestProducerFactory service provider interface. If not set CLASSPATH
         * is searched for single component that implements RestProducerFactory
         * SPI. Can be overridden in endpoint configuration.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default RestSwaggerComponentBuilder componentName(
                java.lang.String componentName) {
            doSetProperty("componentName", componentName);
            return this;
        }
        /**
         * What payload type this component capable of consuming. Could be one
         * type, like application/json or multiple types as application/json,
         * application/xml; q=0.5 according to the RFC7231. This equates to the
         * value of Accept HTTP header. If set overrides any value found in the
         * Swagger specification. Can be overridden in endpoint configuration.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default RestSwaggerComponentBuilder consumes(java.lang.String consumes) {
            doSetProperty("consumes", consumes);
            return this;
        }
        /**
         * Scheme hostname and port to direct the HTTP requests to in the form
         * of https://hostname:port. Can be configured at the endpoint,
         * component or in the corresponding REST configuration in the Camel
         * Context. If you give this component a name (e.g. petstore) that REST
         * configuration is consulted first, rest-swagger next, and global
         * configuration last. If set overrides any value found in the Swagger
         * specification, RestConfiguration. Can be overridden in endpoint
         * configuration.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default RestSwaggerComponentBuilder host(java.lang.String host) {
            doSetProperty("host", host);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default RestSwaggerComponentBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * What payload type this component is producing. For example
         * application/json according to the RFC7231. This equates to the value
         * of Content-Type HTTP header. If set overrides any value present in
         * the Swagger specification. Can be overridden in endpoint
         * configuration.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default RestSwaggerComponentBuilder produces(java.lang.String produces) {
            doSetProperty("produces", produces);
            return this;
        }
        /**
         * Path to the Swagger specification file. The scheme, host base path
         * are taken from this specification, but these can be overridden with
         * properties on the component or endpoint level. If not given the
         * component tries to load swagger.json resource. Note that the host
         * defined on the component and endpoint of this Component should
         * contain the scheme, hostname and optionally the port in the URI
         * syntax (i.e. https://api.example.com:8080). Can be overridden in
         * endpoint configuration.
         * 
         * The option is a: <code>java.net.URI</code> type.
         * 
         * Default: swagger.json
         * Group: producer
         */
        default RestSwaggerComponentBuilder specificationUri(
                java.net.URI specificationUri) {
            doSetProperty("specificationUri", specificationUri);
            return this;
        }
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default RestSwaggerComponentBuilder autowiredEnabled(
                boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
        /**
         * Customize TLS parameters used by the component. If not set defaults
         * to the TLS parameters set in the Camel context.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default RestSwaggerComponentBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Enable usage of global SSL context parameters.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         */
        default RestSwaggerComponentBuilder useGlobalSslContextParameters(
                boolean useGlobalSslContextParameters) {
            doSetProperty("useGlobalSslContextParameters", useGlobalSslContextParameters);
            return this;
        }
    }

    class RestSwaggerComponentBuilderImpl
            extends
                AbstractComponentBuilder<RestSwaggerComponent>
            implements
                RestSwaggerComponentBuilder {
        @Override
        protected RestSwaggerComponent buildConcreteComponent() {
            return new RestSwaggerComponent();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "basePath": ((RestSwaggerComponent) component).setBasePath((java.lang.String) value); return true;
            case "componentName": ((RestSwaggerComponent) component).setComponentName((java.lang.String) value); return true;
            case "consumes": ((RestSwaggerComponent) component).setConsumes((java.lang.String) value); return true;
            case "host": ((RestSwaggerComponent) component).setHost((java.lang.String) value); return true;
            case "lazyStartProducer": ((RestSwaggerComponent) component).setLazyStartProducer((boolean) value); return true;
            case "produces": ((RestSwaggerComponent) component).setProduces((java.lang.String) value); return true;
            case "specificationUri": ((RestSwaggerComponent) component).setSpecificationUri((java.net.URI) value); return true;
            case "autowiredEnabled": ((RestSwaggerComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "sslContextParameters": ((RestSwaggerComponent) component).setSslContextParameters((org.apache.camel.support.jsse.SSLContextParameters) value); return true;
            case "useGlobalSslContextParameters": ((RestSwaggerComponent) component).setUseGlobalSslContextParameters((boolean) value); return true;
            default: return false;
            }
        }
    }
}