/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.zookeeper.ZooKeeperComponent;

/**
 * Manage ZooKeeper clusters.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface ZookeeperComponentBuilderFactory {

    /**
     * ZooKeeper (camel-zookeeper)
     * Manage ZooKeeper clusters.
     * 
     * Category: clustering,management,bigdata
     * Since: 2.9
     * Maven coordinates: org.apache.camel:camel-zookeeper
     */
    static ZookeeperComponentBuilder zookeeper() {
        return new ZookeeperComponentBuilderImpl();
    }

    /**
     * Builder for the ZooKeeper component.
     */
    interface ZookeeperComponentBuilder
            extends
                ComponentBuilder<ZooKeeperComponent> {
        /**
         * Whether the children of the node should be listed.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default ZookeeperComponentBuilder listChildren(boolean listChildren) {
            doSetProperty("listChildren", listChildren);
            return this;
        }
        /**
         * The time interval to wait on connection before timing out.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 5000
         * Group: common
         */
        default ZookeeperComponentBuilder timeout(int timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * The time interval to backoff for after an error before retrying.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 5000
         * Group: consumer
         */
        default ZookeeperComponentBuilder backoff(long backoff) {
            doSetProperty("backoff", backoff);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default ZookeeperComponentBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Should changes to the znode be 'watched' and repeatedly processed.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default ZookeeperComponentBuilder repeat(boolean repeat) {
            doSetProperty("repeat", repeat);
            return this;
        }
        /**
         * Upon the delete of a znode, should an empty message be send to the
         * consumer.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         */
        default ZookeeperComponentBuilder sendEmptyMessageOnDelete(
                boolean sendEmptyMessageOnDelete) {
            doSetProperty("sendEmptyMessageOnDelete", sendEmptyMessageOnDelete);
            return this;
        }
        /**
         * Should the endpoint create the node if it does not currently exist.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default ZookeeperComponentBuilder create(boolean create) {
            doSetProperty("create", create);
            return this;
        }
        /**
         * The create mode that should be used for the newly created node.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: EPHEMERAL
         * Group: producer
         */
        default ZookeeperComponentBuilder createMode(java.lang.String createMode) {
            doSetProperty("createMode", createMode);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default ZookeeperComponentBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         */
        default ZookeeperComponentBuilder autowiredEnabled(
                boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
        /**
         * To use a shared ZooKeeperConfiguration.
         * 
         * The option is a:
         * <code>org.apache.camel.component.zookeeper.ZooKeeperConfiguration</code> type.
         * 
         * Group: advanced
         */
        default ZookeeperComponentBuilder configuration(
                org.apache.camel.component.zookeeper.ZooKeeperConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    }

    class ZookeeperComponentBuilderImpl
            extends
                AbstractComponentBuilder<ZooKeeperComponent>
            implements
                ZookeeperComponentBuilder {
        @Override
        protected ZooKeeperComponent buildConcreteComponent() {
            return new ZooKeeperComponent();
        }
        private org.apache.camel.component.zookeeper.ZooKeeperConfiguration getOrCreateConfiguration(
                org.apache.camel.component.zookeeper.ZooKeeperComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.zookeeper.ZooKeeperConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "listChildren": getOrCreateConfiguration((ZooKeeperComponent) component).setListChildren((boolean) value); return true;
            case "timeout": getOrCreateConfiguration((ZooKeeperComponent) component).setTimeout((int) value); return true;
            case "backoff": getOrCreateConfiguration((ZooKeeperComponent) component).setBackoff((long) value); return true;
            case "bridgeErrorHandler": ((ZooKeeperComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "repeat": getOrCreateConfiguration((ZooKeeperComponent) component).setRepeat((boolean) value); return true;
            case "sendEmptyMessageOnDelete": getOrCreateConfiguration((ZooKeeperComponent) component).setSendEmptyMessageOnDelete((boolean) value); return true;
            case "create": getOrCreateConfiguration((ZooKeeperComponent) component).setCreate((boolean) value); return true;
            case "createMode": getOrCreateConfiguration((ZooKeeperComponent) component).setCreateMode((java.lang.String) value); return true;
            case "lazyStartProducer": ((ZooKeeperComponent) component).setLazyStartProducer((boolean) value); return true;
            case "autowiredEnabled": ((ZooKeeperComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "configuration": ((ZooKeeperComponent) component).setConfiguration((org.apache.camel.component.zookeeper.ZooKeeperConfiguration) value); return true;
            default: return false;
            }
        }
    }
}