/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.firehose.KinesisFirehose2Component;
import org.apache.camel.component.aws2.firehose.KinesisFirehose2Configuration;
import org.apache.camel.component.aws2.firehose.KinesisFirehose2Operations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.firehose.FirehoseClient;

public interface Aws2KinesisFirehoseComponentBuilderFactory {
    public static Aws2KinesisFirehoseComponentBuilder aws2KinesisFirehose() {
        return new Aws2KinesisFirehoseComponentBuilderImpl();
    }

    public static class Aws2KinesisFirehoseComponentBuilderImpl
    extends AbstractComponentBuilder<KinesisFirehose2Component>
    implements Aws2KinesisFirehoseComponentBuilder {
        @Override
        protected KinesisFirehose2Component buildConcreteComponent() {
            return new KinesisFirehose2Component();
        }

        private KinesisFirehose2Configuration getOrCreateConfiguration(KinesisFirehose2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new KinesisFirehose2Configuration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "amazonKinesisFirehoseClient": {
                    this.getOrCreateConfiguration((KinesisFirehose2Component)component).setAmazonKinesisFirehoseClient((FirehoseClient)value);
                    return true;
                }
                case "cborEnabled": {
                    this.getOrCreateConfiguration((KinesisFirehose2Component)component).setCborEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((KinesisFirehose2Component)component).setConfiguration((KinesisFirehose2Configuration)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((KinesisFirehose2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((KinesisFirehose2Component)component).setOperation((KinesisFirehose2Operations)value);
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((KinesisFirehose2Component)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((KinesisFirehose2Component)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((KinesisFirehose2Component)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((KinesisFirehose2Component)component).setRegion((String)value);
                    return true;
                }
                case "trustAllCertificates": {
                    this.getOrCreateConfiguration((KinesisFirehose2Component)component).setTrustAllCertificates(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((KinesisFirehose2Component)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((KinesisFirehose2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((KinesisFirehose2Component)component).setSecretKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2KinesisFirehoseComponentBuilder
    extends ComponentBuilder<KinesisFirehose2Component> {
        default public Aws2KinesisFirehoseComponentBuilder amazonKinesisFirehoseClient(FirehoseClient amazonKinesisFirehoseClient) {
            this.doSetProperty("amazonKinesisFirehoseClient", amazonKinesisFirehoseClient);
            return this;
        }

        default public Aws2KinesisFirehoseComponentBuilder cborEnabled(boolean cborEnabled) {
            this.doSetProperty("cborEnabled", cborEnabled);
            return this;
        }

        default public Aws2KinesisFirehoseComponentBuilder configuration(KinesisFirehose2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Aws2KinesisFirehoseComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2KinesisFirehoseComponentBuilder operation(KinesisFirehose2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Aws2KinesisFirehoseComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Aws2KinesisFirehoseComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Aws2KinesisFirehoseComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Aws2KinesisFirehoseComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2KinesisFirehoseComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Aws2KinesisFirehoseComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public Aws2KinesisFirehoseComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2KinesisFirehoseComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

