/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.sqs.Sqs2Component;
import org.apache.camel.component.aws2.sqs.Sqs2Configuration;
import org.apache.camel.component.aws2.sqs.Sqs2Operations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.sqs.SqsClient;

public interface Aws2SqsComponentBuilderFactory {
    public static Aws2SqsComponentBuilder aws2Sqs() {
        return new Aws2SqsComponentBuilderImpl();
    }

    public static class Aws2SqsComponentBuilderImpl
    extends AbstractComponentBuilder<Sqs2Component>
    implements Aws2SqsComponentBuilder {
        @Override
        protected Sqs2Component buildConcreteComponent() {
            return new Sqs2Component();
        }

        private Sqs2Configuration getOrCreateConfiguration(Sqs2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new Sqs2Configuration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "amazonAWSHost": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setAmazonAWSHost((String)value);
                    return true;
                }
                case "amazonSQSClient": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setAmazonSQSClient((SqsClient)value);
                    return true;
                }
                case "autoCreateQueue": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setAutoCreateQueue(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((Sqs2Component)component).setConfiguration((Sqs2Configuration)value);
                    return true;
                }
                case "protocol": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setProtocol((String)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "queueOwnerAWSAccountId": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setQueueOwnerAWSAccountId((String)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setRegion((String)value);
                    return true;
                }
                case "trustAllCertificates": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setTrustAllCertificates(((Boolean)value).booleanValue());
                    return true;
                }
                case "useDefaultCredentialsProvider": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setUseDefaultCredentialsProvider(((Boolean)value).booleanValue());
                    return true;
                }
                case "attributeNames": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setAttributeNames((String)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((Sqs2Component)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "concurrentConsumers": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setConcurrentConsumers(((Integer)value).intValue());
                    return true;
                }
                case "defaultVisibilityTimeout": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setDefaultVisibilityTimeout((Integer)value);
                    return true;
                }
                case "deleteAfterRead": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setDeleteAfterRead(((Boolean)value).booleanValue());
                    return true;
                }
                case "deleteIfFiltered": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setDeleteIfFiltered(((Boolean)value).booleanValue());
                    return true;
                }
                case "extendMessageVisibility": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setExtendMessageVisibility(((Boolean)value).booleanValue());
                    return true;
                }
                case "kmsDataKeyReusePeriodSeconds": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setKmsDataKeyReusePeriodSeconds((Integer)value);
                    return true;
                }
                case "kmsMasterKeyId": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setKmsMasterKeyId((String)value);
                    return true;
                }
                case "messageAttributeNames": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setMessageAttributeNames((String)value);
                    return true;
                }
                case "serverSideEncryptionEnabled": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setServerSideEncryptionEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "visibilityTimeout": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setVisibilityTimeout((Integer)value);
                    return true;
                }
                case "waitTimeSeconds": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setWaitTimeSeconds((Integer)value);
                    return true;
                }
                case "delaySeconds": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setDelaySeconds((Integer)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((Sqs2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "messageDeduplicationIdStrategy": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setMessageDeduplicationIdStrategy((String)value);
                    return true;
                }
                case "messageGroupIdStrategy": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setMessageGroupIdStrategy((String)value);
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setOperation((Sqs2Operations)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((Sqs2Component)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "delayQueue": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setDelayQueue(((Boolean)value).booleanValue());
                    return true;
                }
                case "queueUrl": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setQueueUrl((String)value);
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setProxyPort((Integer)value);
                    return true;
                }
                case "maximumMessageSize": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setMaximumMessageSize((Integer)value);
                    return true;
                }
                case "messageRetentionPeriod": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setMessageRetentionPeriod((Integer)value);
                    return true;
                }
                case "policy": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setPolicy((String)value);
                    return true;
                }
                case "receiveMessageWaitTimeSeconds": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setReceiveMessageWaitTimeSeconds((Integer)value);
                    return true;
                }
                case "redrivePolicy": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setRedrivePolicy((String)value);
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((Sqs2Component)component).setSecretKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2SqsComponentBuilder
    extends ComponentBuilder<Sqs2Component> {
        default public Aws2SqsComponentBuilder amazonAWSHost(String amazonAWSHost) {
            this.doSetProperty("amazonAWSHost", amazonAWSHost);
            return this;
        }

        default public Aws2SqsComponentBuilder amazonSQSClient(SqsClient amazonSQSClient) {
            this.doSetProperty("amazonSQSClient", amazonSQSClient);
            return this;
        }

        default public Aws2SqsComponentBuilder autoCreateQueue(boolean autoCreateQueue) {
            this.doSetProperty("autoCreateQueue", autoCreateQueue);
            return this;
        }

        default public Aws2SqsComponentBuilder configuration(Sqs2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Aws2SqsComponentBuilder protocol(String protocol) {
            this.doSetProperty("protocol", protocol);
            return this;
        }

        default public Aws2SqsComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Aws2SqsComponentBuilder queueOwnerAWSAccountId(String queueOwnerAWSAccountId) {
            this.doSetProperty("queueOwnerAWSAccountId", queueOwnerAWSAccountId);
            return this;
        }

        default public Aws2SqsComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2SqsComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Aws2SqsComponentBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public Aws2SqsComponentBuilder attributeNames(String attributeNames) {
            this.doSetProperty("attributeNames", attributeNames);
            return this;
        }

        default public Aws2SqsComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public Aws2SqsComponentBuilder concurrentConsumers(int concurrentConsumers) {
            this.doSetProperty("concurrentConsumers", concurrentConsumers);
            return this;
        }

        default public Aws2SqsComponentBuilder defaultVisibilityTimeout(Integer defaultVisibilityTimeout) {
            this.doSetProperty("defaultVisibilityTimeout", defaultVisibilityTimeout);
            return this;
        }

        default public Aws2SqsComponentBuilder deleteAfterRead(boolean deleteAfterRead) {
            this.doSetProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }

        default public Aws2SqsComponentBuilder deleteIfFiltered(boolean deleteIfFiltered) {
            this.doSetProperty("deleteIfFiltered", deleteIfFiltered);
            return this;
        }

        default public Aws2SqsComponentBuilder extendMessageVisibility(boolean extendMessageVisibility) {
            this.doSetProperty("extendMessageVisibility", extendMessageVisibility);
            return this;
        }

        default public Aws2SqsComponentBuilder kmsDataKeyReusePeriodSeconds(Integer kmsDataKeyReusePeriodSeconds) {
            this.doSetProperty("kmsDataKeyReusePeriodSeconds", kmsDataKeyReusePeriodSeconds);
            return this;
        }

        default public Aws2SqsComponentBuilder kmsMasterKeyId(String kmsMasterKeyId) {
            this.doSetProperty("kmsMasterKeyId", kmsMasterKeyId);
            return this;
        }

        default public Aws2SqsComponentBuilder messageAttributeNames(String messageAttributeNames) {
            this.doSetProperty("messageAttributeNames", messageAttributeNames);
            return this;
        }

        default public Aws2SqsComponentBuilder serverSideEncryptionEnabled(boolean serverSideEncryptionEnabled) {
            this.doSetProperty("serverSideEncryptionEnabled", serverSideEncryptionEnabled);
            return this;
        }

        default public Aws2SqsComponentBuilder visibilityTimeout(Integer visibilityTimeout) {
            this.doSetProperty("visibilityTimeout", visibilityTimeout);
            return this;
        }

        default public Aws2SqsComponentBuilder waitTimeSeconds(Integer waitTimeSeconds) {
            this.doSetProperty("waitTimeSeconds", waitTimeSeconds);
            return this;
        }

        default public Aws2SqsComponentBuilder delaySeconds(Integer delaySeconds) {
            this.doSetProperty("delaySeconds", delaySeconds);
            return this;
        }

        default public Aws2SqsComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2SqsComponentBuilder messageDeduplicationIdStrategy(String messageDeduplicationIdStrategy) {
            this.doSetProperty("messageDeduplicationIdStrategy", messageDeduplicationIdStrategy);
            return this;
        }

        default public Aws2SqsComponentBuilder messageGroupIdStrategy(String messageGroupIdStrategy) {
            this.doSetProperty("messageGroupIdStrategy", messageGroupIdStrategy);
            return this;
        }

        default public Aws2SqsComponentBuilder operation(Sqs2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Aws2SqsComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public Aws2SqsComponentBuilder delayQueue(boolean delayQueue) {
            this.doSetProperty("delayQueue", delayQueue);
            return this;
        }

        default public Aws2SqsComponentBuilder queueUrl(String queueUrl) {
            this.doSetProperty("queueUrl", queueUrl);
            return this;
        }

        default public Aws2SqsComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Aws2SqsComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Aws2SqsComponentBuilder maximumMessageSize(Integer maximumMessageSize) {
            this.doSetProperty("maximumMessageSize", maximumMessageSize);
            return this;
        }

        default public Aws2SqsComponentBuilder messageRetentionPeriod(Integer messageRetentionPeriod) {
            this.doSetProperty("messageRetentionPeriod", messageRetentionPeriod);
            return this;
        }

        default public Aws2SqsComponentBuilder policy(String policy) {
            this.doSetProperty("policy", policy);
            return this;
        }

        default public Aws2SqsComponentBuilder receiveMessageWaitTimeSeconds(Integer receiveMessageWaitTimeSeconds) {
            this.doSetProperty("receiveMessageWaitTimeSeconds", receiveMessageWaitTimeSeconds);
            return this;
        }

        default public Aws2SqsComponentBuilder redrivePolicy(String redrivePolicy) {
            this.doSetProperty("redrivePolicy", redrivePolicy);
            return this;
        }

        default public Aws2SqsComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2SqsComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

