/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import com.amazonaws.Protocol;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import java.util.Date;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws.cw.CwComponent;
import org.apache.camel.component.aws.cw.CwConfiguration;

public interface AwsCwComponentBuilderFactory {
    public static AwsCwComponentBuilder awsCw() {
        return new AwsCwComponentBuilderImpl();
    }

    public static class AwsCwComponentBuilderImpl
    extends AbstractComponentBuilder<CwComponent>
    implements AwsCwComponentBuilder {
        @Override
        protected CwComponent buildConcreteComponent() {
            return new CwComponent();
        }

        private CwConfiguration getOrCreateConfiguration(CwComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new CwConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "amazonCwClient": {
                    this.getOrCreateConfiguration((CwComponent)component).setAmazonCwClient((AmazonCloudWatch)value);
                    return true;
                }
                case "autoDiscoverClient": {
                    this.getOrCreateConfiguration((CwComponent)component).setAutoDiscoverClient(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((CwComponent)component).setConfiguration((CwConfiguration)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((CwComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "name": {
                    this.getOrCreateConfiguration((CwComponent)component).setName((String)value);
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((CwComponent)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((CwComponent)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((CwComponent)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((CwComponent)component).setRegion((String)value);
                    return true;
                }
                case "timestamp": {
                    this.getOrCreateConfiguration((CwComponent)component).setTimestamp((Date)value);
                    return true;
                }
                case "unit": {
                    this.getOrCreateConfiguration((CwComponent)component).setUnit((String)value);
                    return true;
                }
                case "value": {
                    this.getOrCreateConfiguration((CwComponent)component).setValue((Double)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((CwComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((CwComponent)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((CwComponent)component).setSecretKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AwsCwComponentBuilder
    extends ComponentBuilder<CwComponent> {
        default public AwsCwComponentBuilder amazonCwClient(AmazonCloudWatch amazonCwClient) {
            this.doSetProperty("amazonCwClient", amazonCwClient);
            return this;
        }

        default public AwsCwComponentBuilder autoDiscoverClient(boolean autoDiscoverClient) {
            this.doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }

        default public AwsCwComponentBuilder configuration(CwConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AwsCwComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AwsCwComponentBuilder name(String name) {
            this.doSetProperty("name", name);
            return this;
        }

        default public AwsCwComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public AwsCwComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public AwsCwComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public AwsCwComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public AwsCwComponentBuilder timestamp(Date timestamp) {
            this.doSetProperty("timestamp", timestamp);
            return this;
        }

        default public AwsCwComponentBuilder unit(String unit) {
            this.doSetProperty("unit", unit);
            return this;
        }

        default public AwsCwComponentBuilder value(Double value) {
            this.doSetProperty("value", value);
            return this;
        }

        default public AwsCwComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public AwsCwComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public AwsCwComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

