/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.spi.VertxFactory;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.vertx.VertxComponent;

public interface VertxComponentBuilderFactory {
    public static VertxComponentBuilder vertx() {
        return new VertxComponentBuilderImpl();
    }

    public static class VertxComponentBuilderImpl
    extends AbstractComponentBuilder<VertxComponent>
    implements VertxComponentBuilder {
        @Override
        protected VertxComponent buildConcreteComponent() {
            return new VertxComponent();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "host": {
                    ((VertxComponent)component).setHost((String)value);
                    return true;
                }
                case "port": {
                    ((VertxComponent)component).setPort(((Integer)value).intValue());
                    return true;
                }
                case "timeout": {
                    ((VertxComponent)component).setTimeout(((Integer)value).intValue());
                    return true;
                }
                case "vertx": {
                    ((VertxComponent)component).setVertx((Vertx)value);
                    return true;
                }
                case "vertxOptions": {
                    ((VertxComponent)component).setVertxOptions((VertxOptions)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((VertxComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((VertxComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((VertxComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "vertxFactory": {
                    ((VertxComponent)component).setVertxFactory((VertxFactory)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface VertxComponentBuilder
    extends ComponentBuilder<VertxComponent> {
        default public VertxComponentBuilder host(String host) {
            this.doSetProperty("host", host);
            return this;
        }

        default public VertxComponentBuilder port(int port) {
            this.doSetProperty("port", port);
            return this;
        }

        default public VertxComponentBuilder timeout(int timeout) {
            this.doSetProperty("timeout", timeout);
            return this;
        }

        default public VertxComponentBuilder vertx(Vertx vertx) {
            this.doSetProperty("vertx", vertx);
            return this;
        }

        default public VertxComponentBuilder vertxOptions(VertxOptions vertxOptions) {
            this.doSetProperty("vertxOptions", vertxOptions);
            return this;
        }

        default public VertxComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public VertxComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public VertxComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public VertxComponentBuilder vertxFactory(VertxFactory vertxFactory) {
            this.doSetProperty("vertxFactory", vertxFactory);
            return this;
        }
    }
}

