/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.google.calendar.GoogleCalendarClientFactory;
import org.apache.camel.component.google.calendar.GoogleCalendarComponent;
import org.apache.camel.component.google.calendar.GoogleCalendarConfiguration;

public interface GoogleCalendarComponentBuilderFactory {
    public static GoogleCalendarComponentBuilder googleCalendar() {
        return new GoogleCalendarComponentBuilderImpl();
    }

    public static class GoogleCalendarComponentBuilderImpl
    extends AbstractComponentBuilder<GoogleCalendarComponent>
    implements GoogleCalendarComponentBuilder {
        @Override
        protected GoogleCalendarComponent buildConcreteComponent() {
            return new GoogleCalendarComponent();
        }

        private GoogleCalendarConfiguration getOrCreateConfiguration(GoogleCalendarComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new GoogleCalendarConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "applicationName": {
                    this.getOrCreateConfiguration((GoogleCalendarComponent)component).setApplicationName((String)value);
                    return true;
                }
                case "clientId": {
                    this.getOrCreateConfiguration((GoogleCalendarComponent)component).setClientId((String)value);
                    return true;
                }
                case "configuration": {
                    ((GoogleCalendarComponent)component).setConfiguration((GoogleCalendarConfiguration)value);
                    return true;
                }
                case "emailAddress": {
                    this.getOrCreateConfiguration((GoogleCalendarComponent)component).setEmailAddress((String)value);
                    return true;
                }
                case "p12FileName": {
                    this.getOrCreateConfiguration((GoogleCalendarComponent)component).setP12FileName((String)value);
                    return true;
                }
                case "scopes": {
                    this.getOrCreateConfiguration((GoogleCalendarComponent)component).setScopes((String)value);
                    return true;
                }
                case "user": {
                    this.getOrCreateConfiguration((GoogleCalendarComponent)component).setUser((String)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((GoogleCalendarComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((GoogleCalendarComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((GoogleCalendarComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "clientFactory": {
                    ((GoogleCalendarComponent)component).setClientFactory((GoogleCalendarClientFactory)value);
                    return true;
                }
                case "accessToken": {
                    this.getOrCreateConfiguration((GoogleCalendarComponent)component).setAccessToken((String)value);
                    return true;
                }
                case "clientSecret": {
                    this.getOrCreateConfiguration((GoogleCalendarComponent)component).setClientSecret((String)value);
                    return true;
                }
                case "refreshToken": {
                    this.getOrCreateConfiguration((GoogleCalendarComponent)component).setRefreshToken((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface GoogleCalendarComponentBuilder
    extends ComponentBuilder<GoogleCalendarComponent> {
        default public GoogleCalendarComponentBuilder applicationName(String applicationName) {
            this.doSetProperty("applicationName", applicationName);
            return this;
        }

        default public GoogleCalendarComponentBuilder clientId(String clientId) {
            this.doSetProperty("clientId", clientId);
            return this;
        }

        default public GoogleCalendarComponentBuilder configuration(GoogleCalendarConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public GoogleCalendarComponentBuilder emailAddress(String emailAddress) {
            this.doSetProperty("emailAddress", emailAddress);
            return this;
        }

        default public GoogleCalendarComponentBuilder p12FileName(String p12FileName) {
            this.doSetProperty("p12FileName", p12FileName);
            return this;
        }

        default public GoogleCalendarComponentBuilder scopes(String scopes) {
            this.doSetProperty("scopes", scopes);
            return this;
        }

        default public GoogleCalendarComponentBuilder user(String user) {
            this.doSetProperty("user", user);
            return this;
        }

        default public GoogleCalendarComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public GoogleCalendarComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public GoogleCalendarComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public GoogleCalendarComponentBuilder clientFactory(GoogleCalendarClientFactory clientFactory) {
            this.doSetProperty("clientFactory", clientFactory);
            return this;
        }

        default public GoogleCalendarComponentBuilder accessToken(String accessToken) {
            this.doSetProperty("accessToken", accessToken);
            return this;
        }

        default public GoogleCalendarComponentBuilder clientSecret(String clientSecret) {
            this.doSetProperty("clientSecret", clientSecret);
            return this;
        }

        default public GoogleCalendarComponentBuilder refreshToken(String refreshToken) {
            this.doSetProperty("refreshToken", refreshToken);
            return this;
        }
    }
}

