/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.sns.Sns2Component;
import org.apache.camel.component.aws2.sns.Sns2Configuration;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.sns.SnsClient;

public interface Aws2SnsComponentBuilderFactory {
    public static Aws2SnsComponentBuilder aws2Sns() {
        return new Aws2SnsComponentBuilderImpl();
    }

    public static class Aws2SnsComponentBuilderImpl
    extends AbstractComponentBuilder<Sns2Component>
    implements Aws2SnsComponentBuilder {
        @Override
        protected Sns2Component buildConcreteComponent() {
            return new Sns2Component();
        }

        private Sns2Configuration getOrCreateConfiguration(Sns2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new Sns2Configuration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "amazonSNSClient": {
                    this.getOrCreateConfiguration((Sns2Component)component).setAmazonSNSClient((SnsClient)value);
                    return true;
                }
                case "autoCreateTopic": {
                    this.getOrCreateConfiguration((Sns2Component)component).setAutoCreateTopic(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((Sns2Component)component).setConfiguration((Sns2Configuration)value);
                    return true;
                }
                case "kmsMasterKeyId": {
                    this.getOrCreateConfiguration((Sns2Component)component).setKmsMasterKeyId((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((Sns2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "messageDeduplicationIdStrategy": {
                    this.getOrCreateConfiguration((Sns2Component)component).setMessageDeduplicationIdStrategy((String)value);
                    return true;
                }
                case "messageGroupIdStrategy": {
                    this.getOrCreateConfiguration((Sns2Component)component).setMessageGroupIdStrategy((String)value);
                    return true;
                }
                case "messageStructure": {
                    this.getOrCreateConfiguration((Sns2Component)component).setMessageStructure((String)value);
                    return true;
                }
                case "policy": {
                    this.getOrCreateConfiguration((Sns2Component)component).setPolicy((String)value);
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((Sns2Component)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((Sns2Component)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((Sns2Component)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "queueUrl": {
                    this.getOrCreateConfiguration((Sns2Component)component).setQueueUrl((String)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((Sns2Component)component).setRegion((String)value);
                    return true;
                }
                case "serverSideEncryptionEnabled": {
                    this.getOrCreateConfiguration((Sns2Component)component).setServerSideEncryptionEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "subject": {
                    this.getOrCreateConfiguration((Sns2Component)component).setSubject((String)value);
                    return true;
                }
                case "subscribeSNStoSQS": {
                    this.getOrCreateConfiguration((Sns2Component)component).setSubscribeSNStoSQS(((Boolean)value).booleanValue());
                    return true;
                }
                case "trustAllCertificates": {
                    this.getOrCreateConfiguration((Sns2Component)component).setTrustAllCertificates(((Boolean)value).booleanValue());
                    return true;
                }
                case "useDefaultCredentialsProvider": {
                    this.getOrCreateConfiguration((Sns2Component)component).setUseDefaultCredentialsProvider(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((Sns2Component)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((Sns2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((Sns2Component)component).setSecretKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2SnsComponentBuilder
    extends ComponentBuilder<Sns2Component> {
        default public Aws2SnsComponentBuilder amazonSNSClient(SnsClient amazonSNSClient) {
            this.doSetProperty("amazonSNSClient", amazonSNSClient);
            return this;
        }

        default public Aws2SnsComponentBuilder autoCreateTopic(boolean autoCreateTopic) {
            this.doSetProperty("autoCreateTopic", autoCreateTopic);
            return this;
        }

        default public Aws2SnsComponentBuilder configuration(Sns2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Aws2SnsComponentBuilder kmsMasterKeyId(String kmsMasterKeyId) {
            this.doSetProperty("kmsMasterKeyId", kmsMasterKeyId);
            return this;
        }

        default public Aws2SnsComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2SnsComponentBuilder messageDeduplicationIdStrategy(String messageDeduplicationIdStrategy) {
            this.doSetProperty("messageDeduplicationIdStrategy", messageDeduplicationIdStrategy);
            return this;
        }

        default public Aws2SnsComponentBuilder messageGroupIdStrategy(String messageGroupIdStrategy) {
            this.doSetProperty("messageGroupIdStrategy", messageGroupIdStrategy);
            return this;
        }

        default public Aws2SnsComponentBuilder messageStructure(String messageStructure) {
            this.doSetProperty("messageStructure", messageStructure);
            return this;
        }

        default public Aws2SnsComponentBuilder policy(String policy) {
            this.doSetProperty("policy", policy);
            return this;
        }

        default public Aws2SnsComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Aws2SnsComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Aws2SnsComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Aws2SnsComponentBuilder queueUrl(String queueUrl) {
            this.doSetProperty("queueUrl", queueUrl);
            return this;
        }

        default public Aws2SnsComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2SnsComponentBuilder serverSideEncryptionEnabled(boolean serverSideEncryptionEnabled) {
            this.doSetProperty("serverSideEncryptionEnabled", serverSideEncryptionEnabled);
            return this;
        }

        default public Aws2SnsComponentBuilder subject(String subject) {
            this.doSetProperty("subject", subject);
            return this;
        }

        default public Aws2SnsComponentBuilder subscribeSNStoSQS(boolean subscribeSNStoSQS) {
            this.doSetProperty("subscribeSNStoSQS", subscribeSNStoSQS);
            return this;
        }

        default public Aws2SnsComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Aws2SnsComponentBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public Aws2SnsComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public Aws2SnsComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2SnsComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

