/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws.ddbstream.DdbStreamComponent;

/**
 * Receive messages from AWS DynamoDB Stream service.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface AwsDdbstreamComponentBuilderFactory {

    /**
     * AWS DynamoDB Streams (camel-aws-ddb)
     * Receive messages from AWS DynamoDB Stream service.
     * 
     * Category: cloud,messaging,streams
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-aws-ddb
     * 
     * @return the dsl builder
     */
    static AwsDdbstreamComponentBuilder awsDdbstream() {
        return new AwsDdbstreamComponentBuilderImpl();
    }

    /**
     * Builder for the AWS DynamoDB Streams component.
     */
    interface AwsDdbstreamComponentBuilder
            extends
                ComponentBuilder<DdbStreamComponent> {
        /**
         * Setting the autoDiscoverClient mechanism, if true, the component will
         * look for a client instance in the registry automatically otherwise it
         * will skip that checking.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoDiscoverClient the value to set
         * @return the dsl builder
         */
        default AwsDdbstreamComponentBuilder autoDiscoverClient(
                boolean autoDiscoverClient) {
            doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }
        /**
         * Amazon DynamoDB client to use for all requests for this endpoint.
         * 
         * The option is a:
         * &lt;code&gt;com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param amazonDynamoDbStreamsClient the value to set
         * @return the dsl builder
         */
        default AwsDdbstreamComponentBuilder amazonDynamoDbStreamsClient(
                com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams amazonDynamoDbStreamsClient) {
            doSetProperty("amazonDynamoDbStreamsClient", amazonDynamoDbStreamsClient);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AwsDdbstreamComponentBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * The component configuration.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.aws.ddbstream.DdbStreamConfiguration&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default AwsDdbstreamComponentBuilder configuration(
                org.apache.camel.component.aws.ddbstream.DdbStreamConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * Defines where in the DynaboDB stream to start getting records. Note
         * that using TRIM_HORIZON can cause a significant delay before the
         * stream has caught up to real-time. if {AT,AFTER}_SEQUENCE_NUMBER are
         * used, then a sequenceNumberProvider MUST be supplied.
         * 
         * The option is a:
         * &lt;code&gt;com.amazonaws.services.dynamodbv2.model.ShardIteratorType&lt;/code&gt; type.
         * 
         * Default: LATEST
         * Group: consumer
         * 
         * @param iteratorType the value to set
         * @return the dsl builder
         */
        default AwsDdbstreamComponentBuilder iteratorType(
                com.amazonaws.services.dynamodbv2.model.ShardIteratorType iteratorType) {
            doSetProperty("iteratorType", iteratorType);
            return this;
        }
        /**
         * Maximum number of records that will be fetched in each poll.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param maxResultsPerRequest the value to set
         * @return the dsl builder
         */
        default AwsDdbstreamComponentBuilder maxResultsPerRequest(
                int maxResultsPerRequest) {
            doSetProperty("maxResultsPerRequest", maxResultsPerRequest);
            return this;
        }
        /**
         * To define a proxy host when instantiating the DDBStreams client.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default AwsDdbstreamComponentBuilder proxyHost(
                java.lang.String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * To define a proxy port when instantiating the DDBStreams client.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default AwsDdbstreamComponentBuilder proxyPort(
                java.lang.Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the DDBStreams client.
         * 
         * The option is a: &lt;code&gt;com.amazonaws.Protocol&lt;/code&gt;
         * type.
         * 
         * Default: HTTPS
         * Group: consumer
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default AwsDdbstreamComponentBuilder proxyProtocol(
                com.amazonaws.Protocol proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * The region in which DDBStreams client needs to work.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default AwsDdbstreamComponentBuilder region(java.lang.String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * Provider for the sequence number when using one of the two
         * ShardIteratorType.{AT,AFTER}_SEQUENCE_NUMBER iterator types. Can be a
         * registry reference or a literal sequence number.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.aws.ddbstream.SequenceNumberProvider&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param sequenceNumberProvider the value to set
         * @return the dsl builder
         */
        default AwsDdbstreamComponentBuilder sequenceNumberProvider(
                org.apache.camel.component.aws.ddbstream.SequenceNumberProvider sequenceNumberProvider) {
            doSetProperty("sequenceNumberProvider", sequenceNumberProvider);
            return this;
        }
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default AwsDdbstreamComponentBuilder autowiredEnabled(
                boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default AwsDdbstreamComponentBuilder accessKey(
                java.lang.String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default AwsDdbstreamComponentBuilder secretKey(
                java.lang.String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
    }

    class AwsDdbstreamComponentBuilderImpl
            extends
                AbstractComponentBuilder<DdbStreamComponent>
            implements
                AwsDdbstreamComponentBuilder {
        @Override
        protected DdbStreamComponent buildConcreteComponent() {
            return new DdbStreamComponent();
        }
        private org.apache.camel.component.aws.ddbstream.DdbStreamConfiguration getOrCreateConfiguration(
                org.apache.camel.component.aws.ddbstream.DdbStreamComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.aws.ddbstream.DdbStreamConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "autoDiscoverClient": getOrCreateConfiguration((DdbStreamComponent) component).setAutoDiscoverClient((boolean) value); return true;
            case "amazonDynamoDbStreamsClient": getOrCreateConfiguration((DdbStreamComponent) component).setAmazonDynamoDbStreamsClient((com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams) value); return true;
            case "bridgeErrorHandler": ((DdbStreamComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "configuration": ((DdbStreamComponent) component).setConfiguration((org.apache.camel.component.aws.ddbstream.DdbStreamConfiguration) value); return true;
            case "iteratorType": getOrCreateConfiguration((DdbStreamComponent) component).setIteratorType((com.amazonaws.services.dynamodbv2.model.ShardIteratorType) value); return true;
            case "maxResultsPerRequest": getOrCreateConfiguration((DdbStreamComponent) component).setMaxResultsPerRequest((int) value); return true;
            case "proxyHost": getOrCreateConfiguration((DdbStreamComponent) component).setProxyHost((java.lang.String) value); return true;
            case "proxyPort": getOrCreateConfiguration((DdbStreamComponent) component).setProxyPort((java.lang.Integer) value); return true;
            case "proxyProtocol": getOrCreateConfiguration((DdbStreamComponent) component).setProxyProtocol((com.amazonaws.Protocol) value); return true;
            case "region": getOrCreateConfiguration((DdbStreamComponent) component).setRegion((java.lang.String) value); return true;
            case "sequenceNumberProvider": getOrCreateConfiguration((DdbStreamComponent) component).setSequenceNumberProvider((org.apache.camel.component.aws.ddbstream.SequenceNumberProvider) value); return true;
            case "autowiredEnabled": ((DdbStreamComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "accessKey": getOrCreateConfiguration((DdbStreamComponent) component).setAccessKey((java.lang.String) value); return true;
            case "secretKey": getOrCreateConfiguration((DdbStreamComponent) component).setSecretKey((java.lang.String) value); return true;
            default: return false;
            }
        }
    }
}