/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import java.util.List;
import org.apache.camel.Component;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.mina.MinaComponent;
import org.apache.camel.component.mina.MinaConfiguration;
import org.apache.camel.component.mina.MinaTextLineDelimiter;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;

public interface MinaComponentBuilderFactory {
    public static MinaComponentBuilder mina() {
        return new MinaComponentBuilderImpl();
    }

    public static class MinaComponentBuilderImpl
    extends AbstractComponentBuilder<MinaComponent>
    implements MinaComponentBuilder {
        @Override
        protected MinaComponent buildConcreteComponent() {
            return new MinaComponent();
        }

        private MinaConfiguration getOrCreateConfiguration(MinaComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new MinaConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "disconnect": {
                    this.getOrCreateConfiguration((MinaComponent)component).setDisconnect(((Boolean)value).booleanValue());
                    return true;
                }
                case "minaLogger": {
                    this.getOrCreateConfiguration((MinaComponent)component).setMinaLogger(((Boolean)value).booleanValue());
                    return true;
                }
                case "sync": {
                    this.getOrCreateConfiguration((MinaComponent)component).setSync(((Boolean)value).booleanValue());
                    return true;
                }
                case "timeout": {
                    this.getOrCreateConfiguration((MinaComponent)component).setTimeout(((Long)value).longValue());
                    return true;
                }
                case "writeTimeout": {
                    this.getOrCreateConfiguration((MinaComponent)component).setWriteTimeout(((Long)value).longValue());
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((MinaComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "clientMode": {
                    this.getOrCreateConfiguration((MinaComponent)component).setClientMode(((Boolean)value).booleanValue());
                    return true;
                }
                case "disconnectOnNoReply": {
                    this.getOrCreateConfiguration((MinaComponent)component).setDisconnectOnNoReply(((Boolean)value).booleanValue());
                    return true;
                }
                case "noReplyLogLevel": {
                    this.getOrCreateConfiguration((MinaComponent)component).setNoReplyLogLevel((LoggingLevel)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((MinaComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "cachedAddress": {
                    this.getOrCreateConfiguration((MinaComponent)component).setCachedAddress(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazySessionCreation": {
                    this.getOrCreateConfiguration((MinaComponent)component).setLazySessionCreation(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((MinaComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((MinaComponent)component).setConfiguration((MinaConfiguration)value);
                    return true;
                }
                case "maximumPoolSize": {
                    this.getOrCreateConfiguration((MinaComponent)component).setMaximumPoolSize(((Integer)value).intValue());
                    return true;
                }
                case "orderedThreadPoolExecutor": {
                    this.getOrCreateConfiguration((MinaComponent)component).setOrderedThreadPoolExecutor(((Boolean)value).booleanValue());
                    return true;
                }
                case "transferExchange": {
                    this.getOrCreateConfiguration((MinaComponent)component).setTransferExchange(((Boolean)value).booleanValue());
                    return true;
                }
                case "allowDefaultCodec": {
                    this.getOrCreateConfiguration((MinaComponent)component).setAllowDefaultCodec(((Boolean)value).booleanValue());
                    return true;
                }
                case "codec": {
                    this.getOrCreateConfiguration((MinaComponent)component).setCodec((ProtocolCodecFactory)value);
                    return true;
                }
                case "decoderMaxLineLength": {
                    this.getOrCreateConfiguration((MinaComponent)component).setDecoderMaxLineLength(((Integer)value).intValue());
                    return true;
                }
                case "encoderMaxLineLength": {
                    this.getOrCreateConfiguration((MinaComponent)component).setEncoderMaxLineLength(((Integer)value).intValue());
                    return true;
                }
                case "encoding": {
                    this.getOrCreateConfiguration((MinaComponent)component).setEncoding((String)value);
                    return true;
                }
                case "filters": {
                    this.getOrCreateConfiguration((MinaComponent)component).setFilters((List)value);
                    return true;
                }
                case "textline": {
                    this.getOrCreateConfiguration((MinaComponent)component).setTextline(((Boolean)value).booleanValue());
                    return true;
                }
                case "textlineDelimiter": {
                    this.getOrCreateConfiguration((MinaComponent)component).setTextlineDelimiter((MinaTextLineDelimiter)value);
                    return true;
                }
                case "autoStartTls": {
                    this.getOrCreateConfiguration((MinaComponent)component).setAutoStartTls(((Boolean)value).booleanValue());
                    return true;
                }
                case "sslContextParameters": {
                    this.getOrCreateConfiguration((MinaComponent)component).setSslContextParameters((SSLContextParameters)value);
                    return true;
                }
                case "useGlobalSslContextParameters": {
                    ((MinaComponent)component).setUseGlobalSslContextParameters(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface MinaComponentBuilder
    extends ComponentBuilder<MinaComponent> {
        default public MinaComponentBuilder disconnect(boolean disconnect) {
            this.doSetProperty("disconnect", disconnect);
            return this;
        }

        default public MinaComponentBuilder minaLogger(boolean minaLogger) {
            this.doSetProperty("minaLogger", minaLogger);
            return this;
        }

        default public MinaComponentBuilder sync(boolean sync) {
            this.doSetProperty("sync", sync);
            return this;
        }

        default public MinaComponentBuilder timeout(long timeout) {
            this.doSetProperty("timeout", timeout);
            return this;
        }

        default public MinaComponentBuilder writeTimeout(long writeTimeout) {
            this.doSetProperty("writeTimeout", writeTimeout);
            return this;
        }

        default public MinaComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public MinaComponentBuilder clientMode(boolean clientMode) {
            this.doSetProperty("clientMode", clientMode);
            return this;
        }

        default public MinaComponentBuilder disconnectOnNoReply(boolean disconnectOnNoReply) {
            this.doSetProperty("disconnectOnNoReply", disconnectOnNoReply);
            return this;
        }

        default public MinaComponentBuilder noReplyLogLevel(LoggingLevel noReplyLogLevel) {
            this.doSetProperty("noReplyLogLevel", noReplyLogLevel);
            return this;
        }

        default public MinaComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public MinaComponentBuilder cachedAddress(boolean cachedAddress) {
            this.doSetProperty("cachedAddress", cachedAddress);
            return this;
        }

        default public MinaComponentBuilder lazySessionCreation(boolean lazySessionCreation) {
            this.doSetProperty("lazySessionCreation", lazySessionCreation);
            return this;
        }

        default public MinaComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public MinaComponentBuilder configuration(MinaConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public MinaComponentBuilder maximumPoolSize(int maximumPoolSize) {
            this.doSetProperty("maximumPoolSize", maximumPoolSize);
            return this;
        }

        default public MinaComponentBuilder orderedThreadPoolExecutor(boolean orderedThreadPoolExecutor) {
            this.doSetProperty("orderedThreadPoolExecutor", orderedThreadPoolExecutor);
            return this;
        }

        default public MinaComponentBuilder transferExchange(boolean transferExchange) {
            this.doSetProperty("transferExchange", transferExchange);
            return this;
        }

        default public MinaComponentBuilder allowDefaultCodec(boolean allowDefaultCodec) {
            this.doSetProperty("allowDefaultCodec", allowDefaultCodec);
            return this;
        }

        default public MinaComponentBuilder codec(ProtocolCodecFactory codec) {
            this.doSetProperty("codec", codec);
            return this;
        }

        default public MinaComponentBuilder decoderMaxLineLength(int decoderMaxLineLength) {
            this.doSetProperty("decoderMaxLineLength", decoderMaxLineLength);
            return this;
        }

        default public MinaComponentBuilder encoderMaxLineLength(int encoderMaxLineLength) {
            this.doSetProperty("encoderMaxLineLength", encoderMaxLineLength);
            return this;
        }

        default public MinaComponentBuilder encoding(String encoding) {
            this.doSetProperty("encoding", encoding);
            return this;
        }

        default public MinaComponentBuilder filters(List<IoFilter> filters) {
            this.doSetProperty("filters", filters);
            return this;
        }

        default public MinaComponentBuilder textline(boolean textline) {
            this.doSetProperty("textline", textline);
            return this;
        }

        default public MinaComponentBuilder textlineDelimiter(MinaTextLineDelimiter textlineDelimiter) {
            this.doSetProperty("textlineDelimiter", textlineDelimiter);
            return this;
        }

        default public MinaComponentBuilder autoStartTls(boolean autoStartTls) {
            this.doSetProperty("autoStartTls", autoStartTls);
            return this;
        }

        default public MinaComponentBuilder sslContextParameters(SSLContextParameters sslContextParameters) {
            this.doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }

        default public MinaComponentBuilder useGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
            this.doSetProperty("useGlobalSslContextParameters", useGlobalSslContextParameters);
            return this;
        }
    }
}

