/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import com.amazonaws.Protocol;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams;
import com.amazonaws.services.dynamodbv2.model.ShardIteratorType;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws.ddbstream.DdbStreamComponent;
import org.apache.camel.component.aws.ddbstream.DdbStreamConfiguration;
import org.apache.camel.component.aws.ddbstream.SequenceNumberProvider;

public interface AwsDdbstreamComponentBuilderFactory {
    public static AwsDdbstreamComponentBuilder awsDdbstream() {
        return new AwsDdbstreamComponentBuilderImpl();
    }

    public static class AwsDdbstreamComponentBuilderImpl
    extends AbstractComponentBuilder<DdbStreamComponent>
    implements AwsDdbstreamComponentBuilder {
        @Override
        protected DdbStreamComponent buildConcreteComponent() {
            return new DdbStreamComponent();
        }

        private DdbStreamConfiguration getOrCreateConfiguration(DdbStreamComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new DdbStreamConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "autoDiscoverClient": {
                    this.getOrCreateConfiguration((DdbStreamComponent)component).setAutoDiscoverClient(((Boolean)value).booleanValue());
                    return true;
                }
                case "amazonDynamoDbStreamsClient": {
                    this.getOrCreateConfiguration((DdbStreamComponent)component).setAmazonDynamoDbStreamsClient((AmazonDynamoDBStreams)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((DdbStreamComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((DdbStreamComponent)component).setConfiguration((DdbStreamConfiguration)value);
                    return true;
                }
                case "iteratorType": {
                    this.getOrCreateConfiguration((DdbStreamComponent)component).setIteratorType((ShardIteratorType)value);
                    return true;
                }
                case "maxResultsPerRequest": {
                    this.getOrCreateConfiguration((DdbStreamComponent)component).setMaxResultsPerRequest(((Integer)value).intValue());
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((DdbStreamComponent)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((DdbStreamComponent)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((DdbStreamComponent)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((DdbStreamComponent)component).setRegion((String)value);
                    return true;
                }
                case "sequenceNumberProvider": {
                    this.getOrCreateConfiguration((DdbStreamComponent)component).setSequenceNumberProvider((SequenceNumberProvider)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((DdbStreamComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((DdbStreamComponent)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((DdbStreamComponent)component).setSecretKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AwsDdbstreamComponentBuilder
    extends ComponentBuilder<DdbStreamComponent> {
        default public AwsDdbstreamComponentBuilder autoDiscoverClient(boolean autoDiscoverClient) {
            this.doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }

        default public AwsDdbstreamComponentBuilder amazonDynamoDbStreamsClient(AmazonDynamoDBStreams amazonDynamoDbStreamsClient) {
            this.doSetProperty("amazonDynamoDbStreamsClient", amazonDynamoDbStreamsClient);
            return this;
        }

        default public AwsDdbstreamComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AwsDdbstreamComponentBuilder configuration(DdbStreamConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AwsDdbstreamComponentBuilder iteratorType(ShardIteratorType iteratorType) {
            this.doSetProperty("iteratorType", iteratorType);
            return this;
        }

        default public AwsDdbstreamComponentBuilder maxResultsPerRequest(int maxResultsPerRequest) {
            this.doSetProperty("maxResultsPerRequest", maxResultsPerRequest);
            return this;
        }

        default public AwsDdbstreamComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public AwsDdbstreamComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public AwsDdbstreamComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public AwsDdbstreamComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public AwsDdbstreamComponentBuilder sequenceNumberProvider(SequenceNumberProvider sequenceNumberProvider) {
            this.doSetProperty("sequenceNumberProvider", sequenceNumberProvider);
            return this;
        }

        default public AwsDdbstreamComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public AwsDdbstreamComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public AwsDdbstreamComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

