/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.File;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.netty.ClientInitializerFactory;
import org.apache.camel.component.netty.NettyCamelStateCorrelationManager;
import org.apache.camel.component.netty.NettyComponent;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyServerBootstrapFactory;
import org.apache.camel.component.netty.ServerInitializerFactory;
import org.apache.camel.component.netty.TextLineDelimiter;
import org.apache.camel.support.jsse.SSLContextParameters;

public interface NettyComponentBuilderFactory {
    public static NettyComponentBuilder netty() {
        return new NettyComponentBuilderImpl();
    }

    public static class NettyComponentBuilderImpl
    extends AbstractComponentBuilder<NettyComponent>
    implements NettyComponentBuilder {
        @Override
        protected NettyComponent buildConcreteComponent() {
            return new NettyComponent();
        }

        private NettyConfiguration getOrCreateConfiguration(NettyComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new NettyConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((NettyComponent)component).setConfiguration((NettyConfiguration)value);
                    return true;
                }
                case "disconnect": {
                    this.getOrCreateConfiguration((NettyComponent)component).setDisconnect(((Boolean)value).booleanValue());
                    return true;
                }
                case "keepAlive": {
                    this.getOrCreateConfiguration((NettyComponent)component).setKeepAlive(((Boolean)value).booleanValue());
                    return true;
                }
                case "reuseAddress": {
                    this.getOrCreateConfiguration((NettyComponent)component).setReuseAddress(((Boolean)value).booleanValue());
                    return true;
                }
                case "reuseChannel": {
                    this.getOrCreateConfiguration((NettyComponent)component).setReuseChannel(((Boolean)value).booleanValue());
                    return true;
                }
                case "sync": {
                    this.getOrCreateConfiguration((NettyComponent)component).setSync(((Boolean)value).booleanValue());
                    return true;
                }
                case "tcpNoDelay": {
                    this.getOrCreateConfiguration((NettyComponent)component).setTcpNoDelay(((Boolean)value).booleanValue());
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((NettyComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "broadcast": {
                    this.getOrCreateConfiguration((NettyComponent)component).setBroadcast(((Boolean)value).booleanValue());
                    return true;
                }
                case "clientMode": {
                    this.getOrCreateConfiguration((NettyComponent)component).setClientMode(((Boolean)value).booleanValue());
                    return true;
                }
                case "reconnect": {
                    this.getOrCreateConfiguration((NettyComponent)component).setReconnect(((Boolean)value).booleanValue());
                    return true;
                }
                case "reconnectInterval": {
                    this.getOrCreateConfiguration((NettyComponent)component).setReconnectInterval(((Integer)value).intValue());
                    return true;
                }
                case "backlog": {
                    this.getOrCreateConfiguration((NettyComponent)component).setBacklog(((Integer)value).intValue());
                    return true;
                }
                case "bossCount": {
                    this.getOrCreateConfiguration((NettyComponent)component).setBossCount(((Integer)value).intValue());
                    return true;
                }
                case "bossGroup": {
                    this.getOrCreateConfiguration((NettyComponent)component).setBossGroup((EventLoopGroup)value);
                    return true;
                }
                case "disconnectOnNoReply": {
                    this.getOrCreateConfiguration((NettyComponent)component).setDisconnectOnNoReply(((Boolean)value).booleanValue());
                    return true;
                }
                case "executorService": {
                    ((NettyComponent)component).setExecutorService((EventExecutorGroup)value);
                    return true;
                }
                case "maximumPoolSize": {
                    ((NettyComponent)component).setMaximumPoolSize(((Integer)value).intValue());
                    return true;
                }
                case "nettyServerBootstrapFactory": {
                    this.getOrCreateConfiguration((NettyComponent)component).setNettyServerBootstrapFactory((NettyServerBootstrapFactory)value);
                    return true;
                }
                case "networkInterface": {
                    this.getOrCreateConfiguration((NettyComponent)component).setNetworkInterface((String)value);
                    return true;
                }
                case "noReplyLogLevel": {
                    this.getOrCreateConfiguration((NettyComponent)component).setNoReplyLogLevel((LoggingLevel)value);
                    return true;
                }
                case "serverClosedChannelExceptionCaughtLogLevel": {
                    this.getOrCreateConfiguration((NettyComponent)component).setServerClosedChannelExceptionCaughtLogLevel((LoggingLevel)value);
                    return true;
                }
                case "serverExceptionCaughtLogLevel": {
                    this.getOrCreateConfiguration((NettyComponent)component).setServerExceptionCaughtLogLevel((LoggingLevel)value);
                    return true;
                }
                case "serverInitializerFactory": {
                    this.getOrCreateConfiguration((NettyComponent)component).setServerInitializerFactory((ServerInitializerFactory)value);
                    return true;
                }
                case "usingExecutorService": {
                    this.getOrCreateConfiguration((NettyComponent)component).setUsingExecutorService(((Boolean)value).booleanValue());
                    return true;
                }
                case "connectTimeout": {
                    this.getOrCreateConfiguration((NettyComponent)component).setConnectTimeout(((Integer)value).intValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((NettyComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "requestTimeout": {
                    this.getOrCreateConfiguration((NettyComponent)component).setRequestTimeout(((Long)value).longValue());
                    return true;
                }
                case "clientInitializerFactory": {
                    this.getOrCreateConfiguration((NettyComponent)component).setClientInitializerFactory((ClientInitializerFactory)value);
                    return true;
                }
                case "correlationManager": {
                    this.getOrCreateConfiguration((NettyComponent)component).setCorrelationManager((NettyCamelStateCorrelationManager)value);
                    return true;
                }
                case "lazyChannelCreation": {
                    this.getOrCreateConfiguration((NettyComponent)component).setLazyChannelCreation(((Boolean)value).booleanValue());
                    return true;
                }
                case "producerPoolBlockWhenExhausted": {
                    this.getOrCreateConfiguration((NettyComponent)component).setProducerPoolBlockWhenExhausted(((Boolean)value).booleanValue());
                    return true;
                }
                case "producerPoolEnabled": {
                    this.getOrCreateConfiguration((NettyComponent)component).setProducerPoolEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "producerPoolMaxIdle": {
                    this.getOrCreateConfiguration((NettyComponent)component).setProducerPoolMaxIdle(((Integer)value).intValue());
                    return true;
                }
                case "producerPoolMaxTotal": {
                    this.getOrCreateConfiguration((NettyComponent)component).setProducerPoolMaxTotal(((Integer)value).intValue());
                    return true;
                }
                case "producerPoolMaxWait": {
                    this.getOrCreateConfiguration((NettyComponent)component).setProducerPoolMaxWait(((Long)value).longValue());
                    return true;
                }
                case "producerPoolMinEvictableIdle": {
                    this.getOrCreateConfiguration((NettyComponent)component).setProducerPoolMinEvictableIdle(((Long)value).longValue());
                    return true;
                }
                case "producerPoolMinIdle": {
                    this.getOrCreateConfiguration((NettyComponent)component).setProducerPoolMinIdle(((Integer)value).intValue());
                    return true;
                }
                case "udpConnectionlessSending": {
                    this.getOrCreateConfiguration((NettyComponent)component).setUdpConnectionlessSending(((Boolean)value).booleanValue());
                    return true;
                }
                case "useByteBuf": {
                    this.getOrCreateConfiguration((NettyComponent)component).setUseByteBuf(((Boolean)value).booleanValue());
                    return true;
                }
                case "hostnameVerification": {
                    this.getOrCreateConfiguration((NettyComponent)component).setHostnameVerification(((Boolean)value).booleanValue());
                    return true;
                }
                case "allowSerializedHeaders": {
                    this.getOrCreateConfiguration((NettyComponent)component).setAllowSerializedHeaders(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((NettyComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "channelGroup": {
                    this.getOrCreateConfiguration((NettyComponent)component).setChannelGroup((ChannelGroup)value);
                    return true;
                }
                case "nativeTransport": {
                    this.getOrCreateConfiguration((NettyComponent)component).setNativeTransport(((Boolean)value).booleanValue());
                    return true;
                }
                case "options": {
                    this.getOrCreateConfiguration((NettyComponent)component).setOptions((Map)value);
                    return true;
                }
                case "receiveBufferSize": {
                    this.getOrCreateConfiguration((NettyComponent)component).setReceiveBufferSize(((Integer)value).intValue());
                    return true;
                }
                case "receiveBufferSizePredictor": {
                    this.getOrCreateConfiguration((NettyComponent)component).setReceiveBufferSizePredictor(((Integer)value).intValue());
                    return true;
                }
                case "sendBufferSize": {
                    this.getOrCreateConfiguration((NettyComponent)component).setSendBufferSize(((Integer)value).intValue());
                    return true;
                }
                case "transferExchange": {
                    this.getOrCreateConfiguration((NettyComponent)component).setTransferExchange(((Boolean)value).booleanValue());
                    return true;
                }
                case "udpByteArrayCodec": {
                    this.getOrCreateConfiguration((NettyComponent)component).setUdpByteArrayCodec(((Boolean)value).booleanValue());
                    return true;
                }
                case "workerCount": {
                    this.getOrCreateConfiguration((NettyComponent)component).setWorkerCount(((Integer)value).intValue());
                    return true;
                }
                case "workerGroup": {
                    this.getOrCreateConfiguration((NettyComponent)component).setWorkerGroup((EventLoopGroup)value);
                    return true;
                }
                case "allowDefaultCodec": {
                    this.getOrCreateConfiguration((NettyComponent)component).setAllowDefaultCodec(((Boolean)value).booleanValue());
                    return true;
                }
                case "autoAppendDelimiter": {
                    this.getOrCreateConfiguration((NettyComponent)component).setAutoAppendDelimiter(((Boolean)value).booleanValue());
                    return true;
                }
                case "decoderMaxLineLength": {
                    this.getOrCreateConfiguration((NettyComponent)component).setDecoderMaxLineLength(((Integer)value).intValue());
                    return true;
                }
                case "decoders": {
                    this.getOrCreateConfiguration((NettyComponent)component).setDecoders((String)value);
                    return true;
                }
                case "delimiter": {
                    this.getOrCreateConfiguration((NettyComponent)component).setDelimiter((TextLineDelimiter)value);
                    return true;
                }
                case "encoders": {
                    this.getOrCreateConfiguration((NettyComponent)component).setEncoders((String)value);
                    return true;
                }
                case "encoding": {
                    this.getOrCreateConfiguration((NettyComponent)component).setEncoding((String)value);
                    return true;
                }
                case "textline": {
                    this.getOrCreateConfiguration((NettyComponent)component).setTextline(((Boolean)value).booleanValue());
                    return true;
                }
                case "enabledProtocols": {
                    this.getOrCreateConfiguration((NettyComponent)component).setEnabledProtocols((String)value);
                    return true;
                }
                case "keyStoreFile": {
                    this.getOrCreateConfiguration((NettyComponent)component).setKeyStoreFile((File)value);
                    return true;
                }
                case "keyStoreFormat": {
                    this.getOrCreateConfiguration((NettyComponent)component).setKeyStoreFormat((String)value);
                    return true;
                }
                case "keyStoreResource": {
                    this.getOrCreateConfiguration((NettyComponent)component).setKeyStoreResource((String)value);
                    return true;
                }
                case "needClientAuth": {
                    this.getOrCreateConfiguration((NettyComponent)component).setNeedClientAuth(((Boolean)value).booleanValue());
                    return true;
                }
                case "passphrase": {
                    this.getOrCreateConfiguration((NettyComponent)component).setPassphrase((String)value);
                    return true;
                }
                case "securityProvider": {
                    this.getOrCreateConfiguration((NettyComponent)component).setSecurityProvider((String)value);
                    return true;
                }
                case "ssl": {
                    this.getOrCreateConfiguration((NettyComponent)component).setSsl(((Boolean)value).booleanValue());
                    return true;
                }
                case "sslClientCertHeaders": {
                    this.getOrCreateConfiguration((NettyComponent)component).setSslClientCertHeaders(((Boolean)value).booleanValue());
                    return true;
                }
                case "sslContextParameters": {
                    this.getOrCreateConfiguration((NettyComponent)component).setSslContextParameters((SSLContextParameters)value);
                    return true;
                }
                case "sslHandler": {
                    this.getOrCreateConfiguration((NettyComponent)component).setSslHandler((SslHandler)value);
                    return true;
                }
                case "trustStoreFile": {
                    this.getOrCreateConfiguration((NettyComponent)component).setTrustStoreFile((File)value);
                    return true;
                }
                case "trustStoreResource": {
                    this.getOrCreateConfiguration((NettyComponent)component).setTrustStoreResource((String)value);
                    return true;
                }
                case "useGlobalSslContextParameters": {
                    ((NettyComponent)component).setUseGlobalSslContextParameters(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface NettyComponentBuilder
    extends ComponentBuilder<NettyComponent> {
        default public NettyComponentBuilder configuration(NettyConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public NettyComponentBuilder disconnect(boolean disconnect) {
            this.doSetProperty("disconnect", disconnect);
            return this;
        }

        default public NettyComponentBuilder keepAlive(boolean keepAlive) {
            this.doSetProperty("keepAlive", keepAlive);
            return this;
        }

        default public NettyComponentBuilder reuseAddress(boolean reuseAddress) {
            this.doSetProperty("reuseAddress", reuseAddress);
            return this;
        }

        default public NettyComponentBuilder reuseChannel(boolean reuseChannel) {
            this.doSetProperty("reuseChannel", reuseChannel);
            return this;
        }

        default public NettyComponentBuilder sync(boolean sync) {
            this.doSetProperty("sync", sync);
            return this;
        }

        default public NettyComponentBuilder tcpNoDelay(boolean tcpNoDelay) {
            this.doSetProperty("tcpNoDelay", tcpNoDelay);
            return this;
        }

        default public NettyComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public NettyComponentBuilder broadcast(boolean broadcast) {
            this.doSetProperty("broadcast", broadcast);
            return this;
        }

        default public NettyComponentBuilder clientMode(boolean clientMode) {
            this.doSetProperty("clientMode", clientMode);
            return this;
        }

        default public NettyComponentBuilder reconnect(boolean reconnect) {
            this.doSetProperty("reconnect", reconnect);
            return this;
        }

        default public NettyComponentBuilder reconnectInterval(int reconnectInterval) {
            this.doSetProperty("reconnectInterval", reconnectInterval);
            return this;
        }

        default public NettyComponentBuilder backlog(int backlog) {
            this.doSetProperty("backlog", backlog);
            return this;
        }

        default public NettyComponentBuilder bossCount(int bossCount) {
            this.doSetProperty("bossCount", bossCount);
            return this;
        }

        default public NettyComponentBuilder bossGroup(EventLoopGroup bossGroup) {
            this.doSetProperty("bossGroup", bossGroup);
            return this;
        }

        default public NettyComponentBuilder disconnectOnNoReply(boolean disconnectOnNoReply) {
            this.doSetProperty("disconnectOnNoReply", disconnectOnNoReply);
            return this;
        }

        default public NettyComponentBuilder executorService(EventExecutorGroup executorService) {
            this.doSetProperty("executorService", executorService);
            return this;
        }

        default public NettyComponentBuilder maximumPoolSize(int maximumPoolSize) {
            this.doSetProperty("maximumPoolSize", maximumPoolSize);
            return this;
        }

        default public NettyComponentBuilder nettyServerBootstrapFactory(NettyServerBootstrapFactory nettyServerBootstrapFactory) {
            this.doSetProperty("nettyServerBootstrapFactory", nettyServerBootstrapFactory);
            return this;
        }

        default public NettyComponentBuilder networkInterface(String networkInterface) {
            this.doSetProperty("networkInterface", networkInterface);
            return this;
        }

        default public NettyComponentBuilder noReplyLogLevel(LoggingLevel noReplyLogLevel) {
            this.doSetProperty("noReplyLogLevel", noReplyLogLevel);
            return this;
        }

        default public NettyComponentBuilder serverClosedChannelExceptionCaughtLogLevel(LoggingLevel serverClosedChannelExceptionCaughtLogLevel) {
            this.doSetProperty("serverClosedChannelExceptionCaughtLogLevel", serverClosedChannelExceptionCaughtLogLevel);
            return this;
        }

        default public NettyComponentBuilder serverExceptionCaughtLogLevel(LoggingLevel serverExceptionCaughtLogLevel) {
            this.doSetProperty("serverExceptionCaughtLogLevel", serverExceptionCaughtLogLevel);
            return this;
        }

        default public NettyComponentBuilder serverInitializerFactory(ServerInitializerFactory serverInitializerFactory) {
            this.doSetProperty("serverInitializerFactory", serverInitializerFactory);
            return this;
        }

        default public NettyComponentBuilder usingExecutorService(boolean usingExecutorService) {
            this.doSetProperty("usingExecutorService", usingExecutorService);
            return this;
        }

        default public NettyComponentBuilder connectTimeout(int connectTimeout) {
            this.doSetProperty("connectTimeout", connectTimeout);
            return this;
        }

        default public NettyComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public NettyComponentBuilder requestTimeout(long requestTimeout) {
            this.doSetProperty("requestTimeout", requestTimeout);
            return this;
        }

        default public NettyComponentBuilder clientInitializerFactory(ClientInitializerFactory clientInitializerFactory) {
            this.doSetProperty("clientInitializerFactory", clientInitializerFactory);
            return this;
        }

        default public NettyComponentBuilder correlationManager(NettyCamelStateCorrelationManager correlationManager) {
            this.doSetProperty("correlationManager", correlationManager);
            return this;
        }

        default public NettyComponentBuilder lazyChannelCreation(boolean lazyChannelCreation) {
            this.doSetProperty("lazyChannelCreation", lazyChannelCreation);
            return this;
        }

        default public NettyComponentBuilder producerPoolBlockWhenExhausted(boolean producerPoolBlockWhenExhausted) {
            this.doSetProperty("producerPoolBlockWhenExhausted", producerPoolBlockWhenExhausted);
            return this;
        }

        default public NettyComponentBuilder producerPoolEnabled(boolean producerPoolEnabled) {
            this.doSetProperty("producerPoolEnabled", producerPoolEnabled);
            return this;
        }

        default public NettyComponentBuilder producerPoolMaxIdle(int producerPoolMaxIdle) {
            this.doSetProperty("producerPoolMaxIdle", producerPoolMaxIdle);
            return this;
        }

        default public NettyComponentBuilder producerPoolMaxTotal(int producerPoolMaxTotal) {
            this.doSetProperty("producerPoolMaxTotal", producerPoolMaxTotal);
            return this;
        }

        default public NettyComponentBuilder producerPoolMaxWait(long producerPoolMaxWait) {
            this.doSetProperty("producerPoolMaxWait", producerPoolMaxWait);
            return this;
        }

        default public NettyComponentBuilder producerPoolMinEvictableIdle(long producerPoolMinEvictableIdle) {
            this.doSetProperty("producerPoolMinEvictableIdle", producerPoolMinEvictableIdle);
            return this;
        }

        default public NettyComponentBuilder producerPoolMinIdle(int producerPoolMinIdle) {
            this.doSetProperty("producerPoolMinIdle", producerPoolMinIdle);
            return this;
        }

        default public NettyComponentBuilder udpConnectionlessSending(boolean udpConnectionlessSending) {
            this.doSetProperty("udpConnectionlessSending", udpConnectionlessSending);
            return this;
        }

        default public NettyComponentBuilder useByteBuf(boolean useByteBuf) {
            this.doSetProperty("useByteBuf", useByteBuf);
            return this;
        }

        default public NettyComponentBuilder hostnameVerification(boolean hostnameVerification) {
            this.doSetProperty("hostnameVerification", hostnameVerification);
            return this;
        }

        default public NettyComponentBuilder allowSerializedHeaders(boolean allowSerializedHeaders) {
            this.doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }

        default public NettyComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public NettyComponentBuilder channelGroup(ChannelGroup channelGroup) {
            this.doSetProperty("channelGroup", channelGroup);
            return this;
        }

        default public NettyComponentBuilder nativeTransport(boolean nativeTransport) {
            this.doSetProperty("nativeTransport", nativeTransport);
            return this;
        }

        default public NettyComponentBuilder options(Map<String, Object> options) {
            this.doSetProperty("options", options);
            return this;
        }

        default public NettyComponentBuilder receiveBufferSize(int receiveBufferSize) {
            this.doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }

        default public NettyComponentBuilder receiveBufferSizePredictor(int receiveBufferSizePredictor) {
            this.doSetProperty("receiveBufferSizePredictor", receiveBufferSizePredictor);
            return this;
        }

        default public NettyComponentBuilder sendBufferSize(int sendBufferSize) {
            this.doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }

        default public NettyComponentBuilder transferExchange(boolean transferExchange) {
            this.doSetProperty("transferExchange", transferExchange);
            return this;
        }

        default public NettyComponentBuilder udpByteArrayCodec(boolean udpByteArrayCodec) {
            this.doSetProperty("udpByteArrayCodec", udpByteArrayCodec);
            return this;
        }

        default public NettyComponentBuilder workerCount(int workerCount) {
            this.doSetProperty("workerCount", workerCount);
            return this;
        }

        default public NettyComponentBuilder workerGroup(EventLoopGroup workerGroup) {
            this.doSetProperty("workerGroup", workerGroup);
            return this;
        }

        default public NettyComponentBuilder allowDefaultCodec(boolean allowDefaultCodec) {
            this.doSetProperty("allowDefaultCodec", allowDefaultCodec);
            return this;
        }

        default public NettyComponentBuilder autoAppendDelimiter(boolean autoAppendDelimiter) {
            this.doSetProperty("autoAppendDelimiter", autoAppendDelimiter);
            return this;
        }

        default public NettyComponentBuilder decoderMaxLineLength(int decoderMaxLineLength) {
            this.doSetProperty("decoderMaxLineLength", decoderMaxLineLength);
            return this;
        }

        default public NettyComponentBuilder decoders(String decoders) {
            this.doSetProperty("decoders", decoders);
            return this;
        }

        default public NettyComponentBuilder delimiter(TextLineDelimiter delimiter) {
            this.doSetProperty("delimiter", delimiter);
            return this;
        }

        default public NettyComponentBuilder encoders(String encoders) {
            this.doSetProperty("encoders", encoders);
            return this;
        }

        default public NettyComponentBuilder encoding(String encoding) {
            this.doSetProperty("encoding", encoding);
            return this;
        }

        default public NettyComponentBuilder textline(boolean textline) {
            this.doSetProperty("textline", textline);
            return this;
        }

        default public NettyComponentBuilder enabledProtocols(String enabledProtocols) {
            this.doSetProperty("enabledProtocols", enabledProtocols);
            return this;
        }

        default public NettyComponentBuilder keyStoreFile(File keyStoreFile) {
            this.doSetProperty("keyStoreFile", keyStoreFile);
            return this;
        }

        default public NettyComponentBuilder keyStoreFormat(String keyStoreFormat) {
            this.doSetProperty("keyStoreFormat", keyStoreFormat);
            return this;
        }

        default public NettyComponentBuilder keyStoreResource(String keyStoreResource) {
            this.doSetProperty("keyStoreResource", keyStoreResource);
            return this;
        }

        default public NettyComponentBuilder needClientAuth(boolean needClientAuth) {
            this.doSetProperty("needClientAuth", needClientAuth);
            return this;
        }

        default public NettyComponentBuilder passphrase(String passphrase) {
            this.doSetProperty("passphrase", passphrase);
            return this;
        }

        default public NettyComponentBuilder securityProvider(String securityProvider) {
            this.doSetProperty("securityProvider", securityProvider);
            return this;
        }

        default public NettyComponentBuilder ssl(boolean ssl) {
            this.doSetProperty("ssl", ssl);
            return this;
        }

        default public NettyComponentBuilder sslClientCertHeaders(boolean sslClientCertHeaders) {
            this.doSetProperty("sslClientCertHeaders", sslClientCertHeaders);
            return this;
        }

        default public NettyComponentBuilder sslContextParameters(SSLContextParameters sslContextParameters) {
            this.doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }

        default public NettyComponentBuilder sslHandler(SslHandler sslHandler) {
            this.doSetProperty("sslHandler", sslHandler);
            return this;
        }

        default public NettyComponentBuilder trustStoreFile(File trustStoreFile) {
            this.doSetProperty("trustStoreFile", trustStoreFile);
            return this;
        }

        default public NettyComponentBuilder trustStoreResource(String trustStoreResource) {
            this.doSetProperty("trustStoreResource", trustStoreResource);
            return this;
        }

        default public NettyComponentBuilder useGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
            this.doSetProperty("useGlobalSslContextParameters", useGlobalSslContextParameters);
            return this;
        }
    }
}

