/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.ddb.Ddb2Component;
import org.apache.camel.component.aws2.ddb.Ddb2Configuration;
import org.apache.camel.component.aws2.ddb.Ddb2Operations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

public interface Aws2DdbComponentBuilderFactory {
    public static Aws2DdbComponentBuilder aws2Ddb() {
        return new Aws2DdbComponentBuilderImpl();
    }

    public static class Aws2DdbComponentBuilderImpl
    extends AbstractComponentBuilder<Ddb2Component>
    implements Aws2DdbComponentBuilder {
        @Override
        protected Ddb2Component buildConcreteComponent() {
            return new Ddb2Component();
        }

        private Ddb2Configuration getOrCreateConfiguration(Ddb2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new Ddb2Configuration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "amazonDDBClient": {
                    this.getOrCreateConfiguration((Ddb2Component)component).setAmazonDDBClient((DynamoDbClient)value);
                    return true;
                }
                case "configuration": {
                    ((Ddb2Component)component).setConfiguration((Ddb2Configuration)value);
                    return true;
                }
                case "consistentRead": {
                    this.getOrCreateConfiguration((Ddb2Component)component).setConsistentRead(((Boolean)value).booleanValue());
                    return true;
                }
                case "enabledInitialDescribeTable": {
                    this.getOrCreateConfiguration((Ddb2Component)component).setEnabledInitialDescribeTable(((Boolean)value).booleanValue());
                    return true;
                }
                case "keyAttributeName": {
                    this.getOrCreateConfiguration((Ddb2Component)component).setKeyAttributeName((String)value);
                    return true;
                }
                case "keyAttributeType": {
                    this.getOrCreateConfiguration((Ddb2Component)component).setKeyAttributeType((String)value);
                    return true;
                }
                case "keyScalarType": {
                    this.getOrCreateConfiguration((Ddb2Component)component).setKeyScalarType((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((Ddb2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((Ddb2Component)component).setOperation((Ddb2Operations)value);
                    return true;
                }
                case "overrideEndpoint": {
                    this.getOrCreateConfiguration((Ddb2Component)component).setOverrideEndpoint(((Boolean)value).booleanValue());
                    return true;
                }
                case "profileCredentialsName": {
                    this.getOrCreateConfiguration((Ddb2Component)component).setProfileCredentialsName((String)value);
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((Ddb2Component)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((Ddb2Component)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((Ddb2Component)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "readCapacity": {
                    this.getOrCreateConfiguration((Ddb2Component)component).setReadCapacity((Long)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((Ddb2Component)component).setRegion((String)value);
                    return true;
                }
                case "trustAllCertificates": {
                    this.getOrCreateConfiguration((Ddb2Component)component).setTrustAllCertificates(((Boolean)value).booleanValue());
                    return true;
                }
                case "uriEndpointOverride": {
                    this.getOrCreateConfiguration((Ddb2Component)component).setUriEndpointOverride((String)value);
                    return true;
                }
                case "useDefaultCredentialsProvider": {
                    this.getOrCreateConfiguration((Ddb2Component)component).setUseDefaultCredentialsProvider(Boolean.valueOf((Boolean)value));
                    return true;
                }
                case "useProfileCredentialsProvider": {
                    this.getOrCreateConfiguration((Ddb2Component)component).setUseProfileCredentialsProvider(((Boolean)value).booleanValue());
                    return true;
                }
                case "writeCapacity": {
                    this.getOrCreateConfiguration((Ddb2Component)component).setWriteCapacity((Long)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((Ddb2Component)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((Ddb2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((Ddb2Component)component).setSecretKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2DdbComponentBuilder
    extends ComponentBuilder<Ddb2Component> {
        default public Aws2DdbComponentBuilder amazonDDBClient(DynamoDbClient amazonDDBClient) {
            this.doSetProperty("amazonDDBClient", amazonDDBClient);
            return this;
        }

        default public Aws2DdbComponentBuilder configuration(Ddb2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Aws2DdbComponentBuilder consistentRead(boolean consistentRead) {
            this.doSetProperty("consistentRead", consistentRead);
            return this;
        }

        default public Aws2DdbComponentBuilder enabledInitialDescribeTable(boolean enabledInitialDescribeTable) {
            this.doSetProperty("enabledInitialDescribeTable", enabledInitialDescribeTable);
            return this;
        }

        default public Aws2DdbComponentBuilder keyAttributeName(String keyAttributeName) {
            this.doSetProperty("keyAttributeName", keyAttributeName);
            return this;
        }

        default public Aws2DdbComponentBuilder keyAttributeType(String keyAttributeType) {
            this.doSetProperty("keyAttributeType", keyAttributeType);
            return this;
        }

        default public Aws2DdbComponentBuilder keyScalarType(String keyScalarType) {
            this.doSetProperty("keyScalarType", keyScalarType);
            return this;
        }

        default public Aws2DdbComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2DdbComponentBuilder operation(Ddb2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Aws2DdbComponentBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public Aws2DdbComponentBuilder profileCredentialsName(String profileCredentialsName) {
            this.doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }

        default public Aws2DdbComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Aws2DdbComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Aws2DdbComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Aws2DdbComponentBuilder readCapacity(Long readCapacity) {
            this.doSetProperty("readCapacity", readCapacity);
            return this;
        }

        default public Aws2DdbComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2DdbComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Aws2DdbComponentBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public Aws2DdbComponentBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public Aws2DdbComponentBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public Aws2DdbComponentBuilder writeCapacity(Long writeCapacity) {
            this.doSetProperty("writeCapacity", writeCapacity);
            return this;
        }

        default public Aws2DdbComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public Aws2DdbComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2DdbComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

