/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.sts.STS2Component;
import org.apache.camel.component.aws2.sts.STS2Configuration;
import org.apache.camel.component.aws2.sts.STS2Operations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.sts.StsClient;

public interface Aws2StsComponentBuilderFactory {
    public static Aws2StsComponentBuilder aws2Sts() {
        return new Aws2StsComponentBuilderImpl();
    }

    public static class Aws2StsComponentBuilderImpl
    extends AbstractComponentBuilder<STS2Component>
    implements Aws2StsComponentBuilder {
        @Override
        protected STS2Component buildConcreteComponent() {
            return new STS2Component();
        }

        private STS2Configuration getOrCreateConfiguration(STS2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new STS2Configuration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((STS2Component)component).setConfiguration((STS2Configuration)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((STS2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((STS2Component)component).setOperation((STS2Operations)value);
                    return true;
                }
                case "overrideEndpoint": {
                    this.getOrCreateConfiguration((STS2Component)component).setOverrideEndpoint(((Boolean)value).booleanValue());
                    return true;
                }
                case "pojoRequest": {
                    this.getOrCreateConfiguration((STS2Component)component).setPojoRequest(((Boolean)value).booleanValue());
                    return true;
                }
                case "profileCredentialsName": {
                    this.getOrCreateConfiguration((STS2Component)component).setProfileCredentialsName((String)value);
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((STS2Component)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((STS2Component)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((STS2Component)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((STS2Component)component).setRegion((String)value);
                    return true;
                }
                case "stsClient": {
                    this.getOrCreateConfiguration((STS2Component)component).setStsClient((StsClient)value);
                    return true;
                }
                case "trustAllCertificates": {
                    this.getOrCreateConfiguration((STS2Component)component).setTrustAllCertificates(((Boolean)value).booleanValue());
                    return true;
                }
                case "uriEndpointOverride": {
                    this.getOrCreateConfiguration((STS2Component)component).setUriEndpointOverride((String)value);
                    return true;
                }
                case "useDefaultCredentialsProvider": {
                    this.getOrCreateConfiguration((STS2Component)component).setUseDefaultCredentialsProvider(Boolean.valueOf((Boolean)value));
                    return true;
                }
                case "useProfileCredentialsProvider": {
                    this.getOrCreateConfiguration((STS2Component)component).setUseProfileCredentialsProvider(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((STS2Component)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((STS2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((STS2Component)component).setSecretKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2StsComponentBuilder
    extends ComponentBuilder<STS2Component> {
        default public Aws2StsComponentBuilder configuration(STS2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Aws2StsComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2StsComponentBuilder operation(STS2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Aws2StsComponentBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public Aws2StsComponentBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public Aws2StsComponentBuilder profileCredentialsName(String profileCredentialsName) {
            this.doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }

        default public Aws2StsComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Aws2StsComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Aws2StsComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Aws2StsComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2StsComponentBuilder stsClient(StsClient stsClient) {
            this.doSetProperty("stsClient", stsClient);
            return this;
        }

        default public Aws2StsComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Aws2StsComponentBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public Aws2StsComponentBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public Aws2StsComponentBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public Aws2StsComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public Aws2StsComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2StsComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

