/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import java.util.List;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.google.sheets.GoogleSheetsClientFactory;
import org.apache.camel.component.google.sheets.stream.GoogleSheetsStreamComponent;
import org.apache.camel.component.google.sheets.stream.GoogleSheetsStreamConfiguration;

public interface GoogleSheetsStreamComponentBuilderFactory {
    public static GoogleSheetsStreamComponentBuilder googleSheetsStream() {
        return new GoogleSheetsStreamComponentBuilderImpl();
    }

    public static class GoogleSheetsStreamComponentBuilderImpl
    extends AbstractComponentBuilder<GoogleSheetsStreamComponent>
    implements GoogleSheetsStreamComponentBuilder {
        @Override
        protected GoogleSheetsStreamComponent buildConcreteComponent() {
            return new GoogleSheetsStreamComponent();
        }

        private GoogleSheetsStreamConfiguration getOrCreateConfiguration(GoogleSheetsStreamComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new GoogleSheetsStreamConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "applicationName": {
                    this.getOrCreateConfiguration((GoogleSheetsStreamComponent)component).setApplicationName((String)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((GoogleSheetsStreamComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "clientId": {
                    this.getOrCreateConfiguration((GoogleSheetsStreamComponent)component).setClientId((String)value);
                    return true;
                }
                case "configuration": {
                    ((GoogleSheetsStreamComponent)component).setConfiguration((GoogleSheetsStreamConfiguration)value);
                    return true;
                }
                case "delegate": {
                    this.getOrCreateConfiguration((GoogleSheetsStreamComponent)component).setDelegate((String)value);
                    return true;
                }
                case "includeGridData": {
                    this.getOrCreateConfiguration((GoogleSheetsStreamComponent)component).setIncludeGridData(((Boolean)value).booleanValue());
                    return true;
                }
                case "majorDimension": {
                    this.getOrCreateConfiguration((GoogleSheetsStreamComponent)component).setMajorDimension((String)value);
                    return true;
                }
                case "maxResults": {
                    this.getOrCreateConfiguration((GoogleSheetsStreamComponent)component).setMaxResults(((Integer)value).intValue());
                    return true;
                }
                case "range": {
                    this.getOrCreateConfiguration((GoogleSheetsStreamComponent)component).setRange((String)value);
                    return true;
                }
                case "scopes": {
                    this.getOrCreateConfiguration((GoogleSheetsStreamComponent)component).setScopes((List)value);
                    return true;
                }
                case "splitResults": {
                    this.getOrCreateConfiguration((GoogleSheetsStreamComponent)component).setSplitResults(((Boolean)value).booleanValue());
                    return true;
                }
                case "valueRenderOption": {
                    this.getOrCreateConfiguration((GoogleSheetsStreamComponent)component).setValueRenderOption((String)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((GoogleSheetsStreamComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "clientFactory": {
                    ((GoogleSheetsStreamComponent)component).setClientFactory((GoogleSheetsClientFactory)value);
                    return true;
                }
                case "healthCheckConsumerEnabled": {
                    ((GoogleSheetsStreamComponent)component).setHealthCheckConsumerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckProducerEnabled": {
                    ((GoogleSheetsStreamComponent)component).setHealthCheckProducerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "accessToken": {
                    this.getOrCreateConfiguration((GoogleSheetsStreamComponent)component).setAccessToken((String)value);
                    return true;
                }
                case "clientSecret": {
                    this.getOrCreateConfiguration((GoogleSheetsStreamComponent)component).setClientSecret((String)value);
                    return true;
                }
                case "refreshToken": {
                    this.getOrCreateConfiguration((GoogleSheetsStreamComponent)component).setRefreshToken((String)value);
                    return true;
                }
                case "serviceAccountKey": {
                    this.getOrCreateConfiguration((GoogleSheetsStreamComponent)component).setServiceAccountKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface GoogleSheetsStreamComponentBuilder
    extends ComponentBuilder<GoogleSheetsStreamComponent> {
        default public GoogleSheetsStreamComponentBuilder applicationName(String applicationName) {
            this.doSetProperty("applicationName", applicationName);
            return this;
        }

        default public GoogleSheetsStreamComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public GoogleSheetsStreamComponentBuilder clientId(String clientId) {
            this.doSetProperty("clientId", clientId);
            return this;
        }

        default public GoogleSheetsStreamComponentBuilder configuration(GoogleSheetsStreamConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public GoogleSheetsStreamComponentBuilder delegate(String delegate) {
            this.doSetProperty("delegate", delegate);
            return this;
        }

        default public GoogleSheetsStreamComponentBuilder includeGridData(boolean includeGridData) {
            this.doSetProperty("includeGridData", includeGridData);
            return this;
        }

        default public GoogleSheetsStreamComponentBuilder majorDimension(String majorDimension) {
            this.doSetProperty("majorDimension", majorDimension);
            return this;
        }

        default public GoogleSheetsStreamComponentBuilder maxResults(int maxResults) {
            this.doSetProperty("maxResults", maxResults);
            return this;
        }

        default public GoogleSheetsStreamComponentBuilder range(String range) {
            this.doSetProperty("range", range);
            return this;
        }

        default public GoogleSheetsStreamComponentBuilder scopes(List<String> scopes) {
            this.doSetProperty("scopes", scopes);
            return this;
        }

        default public GoogleSheetsStreamComponentBuilder splitResults(boolean splitResults) {
            this.doSetProperty("splitResults", splitResults);
            return this;
        }

        default public GoogleSheetsStreamComponentBuilder valueRenderOption(String valueRenderOption) {
            this.doSetProperty("valueRenderOption", valueRenderOption);
            return this;
        }

        default public GoogleSheetsStreamComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public GoogleSheetsStreamComponentBuilder clientFactory(GoogleSheetsClientFactory clientFactory) {
            this.doSetProperty("clientFactory", clientFactory);
            return this;
        }

        default public GoogleSheetsStreamComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            this.doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }

        default public GoogleSheetsStreamComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            this.doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }

        default public GoogleSheetsStreamComponentBuilder accessToken(String accessToken) {
            this.doSetProperty("accessToken", accessToken);
            return this;
        }

        default public GoogleSheetsStreamComponentBuilder clientSecret(String clientSecret) {
            this.doSetProperty("clientSecret", clientSecret);
            return this;
        }

        default public GoogleSheetsStreamComponentBuilder refreshToken(String refreshToken) {
            this.doSetProperty("refreshToken", refreshToken);
            return this;
        }

        default public GoogleSheetsStreamComponentBuilder serviceAccountKey(String serviceAccountKey) {
            this.doSetProperty("serviceAccountKey", serviceAccountKey);
            return this;
        }
    }
}

