/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.milvus.MilvusComponent;
import org.apache.camel.component.milvus.MilvusConfiguration;

public interface MilvusComponentBuilderFactory {
    public static MilvusComponentBuilder milvus() {
        return new MilvusComponentBuilderImpl();
    }

    public static class MilvusComponentBuilderImpl
    extends AbstractComponentBuilder<MilvusComponent>
    implements MilvusComponentBuilder {
        @Override
        protected MilvusComponent buildConcreteComponent() {
            return new MilvusComponent();
        }

        private MilvusConfiguration getOrCreateConfiguration(MilvusComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new MilvusConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((MilvusComponent)component).setConfiguration((MilvusConfiguration)value);
                    return true;
                }
                case "host": {
                    this.getOrCreateConfiguration((MilvusComponent)component).setHost((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((MilvusComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "port": {
                    this.getOrCreateConfiguration((MilvusComponent)component).setPort(((Integer)value).intValue());
                    return true;
                }
                case "timeout": {
                    this.getOrCreateConfiguration((MilvusComponent)component).setTimeout(((Long)value).longValue());
                    return true;
                }
                case "token": {
                    this.getOrCreateConfiguration((MilvusComponent)component).setToken((String)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((MilvusComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface MilvusComponentBuilder
    extends ComponentBuilder<MilvusComponent> {
        default public MilvusComponentBuilder configuration(MilvusConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public MilvusComponentBuilder host(String host) {
            this.doSetProperty("host", host);
            return this;
        }

        default public MilvusComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public MilvusComponentBuilder port(int port) {
            this.doSetProperty("port", port);
            return this;
        }

        default public MilvusComponentBuilder timeout(long timeout) {
            this.doSetProperty("timeout", timeout);
            return this;
        }

        default public MilvusComponentBuilder token(String token) {
            this.doSetProperty("token", token);
            return this;
        }

        default public MilvusComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    }
}

