/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.s3.AWS2S3Component;
import org.apache.camel.component.aws2.s3.AWS2S3Configuration;
import org.apache.camel.component.aws2.s3.AWS2S3Operations;
import org.apache.camel.component.aws2.s3.stream.AWSS3NamingStrategyEnum;
import org.apache.camel.component.aws2.s3.stream.AWSS3RestartingPolicyEnum;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;

public interface Aws2S3ComponentBuilderFactory {
    public static Aws2S3ComponentBuilder aws2S3() {
        return new Aws2S3ComponentBuilderImpl();
    }

    public static class Aws2S3ComponentBuilderImpl
    extends AbstractComponentBuilder<AWS2S3Component>
    implements Aws2S3ComponentBuilder {
        @Override
        protected AWS2S3Component buildConcreteComponent() {
            return new AWS2S3Component();
        }

        private AWS2S3Configuration getOrCreateConfiguration(AWS2S3Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new AWS2S3Configuration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "autoCreateBucket": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setAutoCreateBucket(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((AWS2S3Component)component).setConfiguration((AWS2S3Configuration)value);
                    return true;
                }
                case "delimiter": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setDelimiter((String)value);
                    return true;
                }
                case "forcePathStyle": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setForcePathStyle(((Boolean)value).booleanValue());
                    return true;
                }
                case "overrideEndpoint": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setOverrideEndpoint(((Boolean)value).booleanValue());
                    return true;
                }
                case "pojoRequest": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setPojoRequest(((Boolean)value).booleanValue());
                    return true;
                }
                case "policy": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setPolicy((String)value);
                    return true;
                }
                case "prefix": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setPrefix((String)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setRegion((String)value);
                    return true;
                }
                case "uriEndpointOverride": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setUriEndpointOverride((String)value);
                    return true;
                }
                case "customerAlgorithm": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setCustomerAlgorithm((String)value);
                    return true;
                }
                case "customerKeyId": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setCustomerKeyId((String)value);
                    return true;
                }
                case "customerKeyMD5": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setCustomerKeyMD5((String)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((AWS2S3Component)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "deleteAfterRead": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setDeleteAfterRead(((Boolean)value).booleanValue());
                    return true;
                }
                case "destinationBucket": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setDestinationBucket((String)value);
                    return true;
                }
                case "destinationBucketPrefix": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setDestinationBucketPrefix((String)value);
                    return true;
                }
                case "destinationBucketSuffix": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setDestinationBucketSuffix((String)value);
                    return true;
                }
                case "doneFileName": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setDoneFileName((String)value);
                    return true;
                }
                case "fileName": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setFileName((String)value);
                    return true;
                }
                case "ignoreBody": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setIgnoreBody(((Boolean)value).booleanValue());
                    return true;
                }
                case "includeBody": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setIncludeBody(((Boolean)value).booleanValue());
                    return true;
                }
                case "includeFolders": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setIncludeFolders(((Boolean)value).booleanValue());
                    return true;
                }
                case "moveAfterRead": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setMoveAfterRead(((Boolean)value).booleanValue());
                    return true;
                }
                case "autocloseBody": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setAutocloseBody(((Boolean)value).booleanValue());
                    return true;
                }
                case "batchMessageNumber": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setBatchMessageNumber(((Integer)value).intValue());
                    return true;
                }
                case "batchSize": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setBatchSize(((Integer)value).intValue());
                    return true;
                }
                case "bufferSize": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setBufferSize(((Integer)value).intValue());
                    return true;
                }
                case "deleteAfterWrite": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setDeleteAfterWrite(((Boolean)value).booleanValue());
                    return true;
                }
                case "keyName": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setKeyName((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((AWS2S3Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "multiPartUpload": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setMultiPartUpload(((Boolean)value).booleanValue());
                    return true;
                }
                case "namingStrategy": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setNamingStrategy((AWSS3NamingStrategyEnum)value);
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setOperation((AWS2S3Operations)value);
                    return true;
                }
                case "partSize": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setPartSize(((Long)value).longValue());
                    return true;
                }
                case "restartingPolicy": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setRestartingPolicy((AWSS3RestartingPolicyEnum)value);
                    return true;
                }
                case "storageClass": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setStorageClass((String)value);
                    return true;
                }
                case "streamingUploadMode": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setStreamingUploadMode(((Boolean)value).booleanValue());
                    return true;
                }
                case "streamingUploadTimeout": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setStreamingUploadTimeout(((Long)value).longValue());
                    return true;
                }
                case "awsKMSKeyId": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setAwsKMSKeyId((String)value);
                    return true;
                }
                case "useAwsKMS": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setUseAwsKMS(((Boolean)value).booleanValue());
                    return true;
                }
                case "useCustomerKey": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setUseCustomerKey(((Boolean)value).booleanValue());
                    return true;
                }
                case "useSSES3": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setUseSSES3(((Boolean)value).booleanValue());
                    return true;
                }
                case "amazonS3Client": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setAmazonS3Client((S3Client)value);
                    return true;
                }
                case "amazonS3Presigner": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setAmazonS3Presigner((S3Presigner)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((AWS2S3Component)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckConsumerEnabled": {
                    ((AWS2S3Component)component).setHealthCheckConsumerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckProducerEnabled": {
                    ((AWS2S3Component)component).setHealthCheckProducerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setAccessKey((String)value);
                    return true;
                }
                case "profileCredentialsName": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setProfileCredentialsName((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setSecretKey((String)value);
                    return true;
                }
                case "trustAllCertificates": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setTrustAllCertificates(((Boolean)value).booleanValue());
                    return true;
                }
                case "useDefaultCredentialsProvider": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setUseDefaultCredentialsProvider(Boolean.valueOf((Boolean)value));
                    return true;
                }
                case "useProfileCredentialsProvider": {
                    this.getOrCreateConfiguration((AWS2S3Component)component).setUseProfileCredentialsProvider(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2S3ComponentBuilder
    extends ComponentBuilder<AWS2S3Component> {
        default public Aws2S3ComponentBuilder autoCreateBucket(boolean autoCreateBucket) {
            this.doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }

        default public Aws2S3ComponentBuilder configuration(AWS2S3Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Aws2S3ComponentBuilder delimiter(String delimiter) {
            this.doSetProperty("delimiter", delimiter);
            return this;
        }

        default public Aws2S3ComponentBuilder forcePathStyle(boolean forcePathStyle) {
            this.doSetProperty("forcePathStyle", forcePathStyle);
            return this;
        }

        default public Aws2S3ComponentBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public Aws2S3ComponentBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public Aws2S3ComponentBuilder policy(String policy) {
            this.doSetProperty("policy", policy);
            return this;
        }

        default public Aws2S3ComponentBuilder prefix(String prefix) {
            this.doSetProperty("prefix", prefix);
            return this;
        }

        default public Aws2S3ComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2S3ComponentBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public Aws2S3ComponentBuilder customerAlgorithm(String customerAlgorithm) {
            this.doSetProperty("customerAlgorithm", customerAlgorithm);
            return this;
        }

        default public Aws2S3ComponentBuilder customerKeyId(String customerKeyId) {
            this.doSetProperty("customerKeyId", customerKeyId);
            return this;
        }

        default public Aws2S3ComponentBuilder customerKeyMD5(String customerKeyMD5) {
            this.doSetProperty("customerKeyMD5", customerKeyMD5);
            return this;
        }

        default public Aws2S3ComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public Aws2S3ComponentBuilder deleteAfterRead(boolean deleteAfterRead) {
            this.doSetProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }

        default public Aws2S3ComponentBuilder destinationBucket(String destinationBucket) {
            this.doSetProperty("destinationBucket", destinationBucket);
            return this;
        }

        default public Aws2S3ComponentBuilder destinationBucketPrefix(String destinationBucketPrefix) {
            this.doSetProperty("destinationBucketPrefix", destinationBucketPrefix);
            return this;
        }

        default public Aws2S3ComponentBuilder destinationBucketSuffix(String destinationBucketSuffix) {
            this.doSetProperty("destinationBucketSuffix", destinationBucketSuffix);
            return this;
        }

        default public Aws2S3ComponentBuilder doneFileName(String doneFileName) {
            this.doSetProperty("doneFileName", doneFileName);
            return this;
        }

        default public Aws2S3ComponentBuilder fileName(String fileName) {
            this.doSetProperty("fileName", fileName);
            return this;
        }

        default public Aws2S3ComponentBuilder ignoreBody(boolean ignoreBody) {
            this.doSetProperty("ignoreBody", ignoreBody);
            return this;
        }

        default public Aws2S3ComponentBuilder includeBody(boolean includeBody) {
            this.doSetProperty("includeBody", includeBody);
            return this;
        }

        default public Aws2S3ComponentBuilder includeFolders(boolean includeFolders) {
            this.doSetProperty("includeFolders", includeFolders);
            return this;
        }

        default public Aws2S3ComponentBuilder moveAfterRead(boolean moveAfterRead) {
            this.doSetProperty("moveAfterRead", moveAfterRead);
            return this;
        }

        default public Aws2S3ComponentBuilder autocloseBody(boolean autocloseBody) {
            this.doSetProperty("autocloseBody", autocloseBody);
            return this;
        }

        default public Aws2S3ComponentBuilder batchMessageNumber(int batchMessageNumber) {
            this.doSetProperty("batchMessageNumber", batchMessageNumber);
            return this;
        }

        default public Aws2S3ComponentBuilder batchSize(int batchSize) {
            this.doSetProperty("batchSize", batchSize);
            return this;
        }

        default public Aws2S3ComponentBuilder bufferSize(int bufferSize) {
            this.doSetProperty("bufferSize", bufferSize);
            return this;
        }

        default public Aws2S3ComponentBuilder deleteAfterWrite(boolean deleteAfterWrite) {
            this.doSetProperty("deleteAfterWrite", deleteAfterWrite);
            return this;
        }

        default public Aws2S3ComponentBuilder keyName(String keyName) {
            this.doSetProperty("keyName", keyName);
            return this;
        }

        default public Aws2S3ComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2S3ComponentBuilder multiPartUpload(boolean multiPartUpload) {
            this.doSetProperty("multiPartUpload", multiPartUpload);
            return this;
        }

        default public Aws2S3ComponentBuilder namingStrategy(AWSS3NamingStrategyEnum namingStrategy) {
            this.doSetProperty("namingStrategy", namingStrategy);
            return this;
        }

        default public Aws2S3ComponentBuilder operation(AWS2S3Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Aws2S3ComponentBuilder partSize(long partSize) {
            this.doSetProperty("partSize", partSize);
            return this;
        }

        default public Aws2S3ComponentBuilder restartingPolicy(AWSS3RestartingPolicyEnum restartingPolicy) {
            this.doSetProperty("restartingPolicy", restartingPolicy);
            return this;
        }

        default public Aws2S3ComponentBuilder storageClass(String storageClass) {
            this.doSetProperty("storageClass", storageClass);
            return this;
        }

        default public Aws2S3ComponentBuilder streamingUploadMode(boolean streamingUploadMode) {
            this.doSetProperty("streamingUploadMode", streamingUploadMode);
            return this;
        }

        default public Aws2S3ComponentBuilder streamingUploadTimeout(long streamingUploadTimeout) {
            this.doSetProperty("streamingUploadTimeout", streamingUploadTimeout);
            return this;
        }

        default public Aws2S3ComponentBuilder awsKMSKeyId(String awsKMSKeyId) {
            this.doSetProperty("awsKMSKeyId", awsKMSKeyId);
            return this;
        }

        default public Aws2S3ComponentBuilder useAwsKMS(boolean useAwsKMS) {
            this.doSetProperty("useAwsKMS", useAwsKMS);
            return this;
        }

        default public Aws2S3ComponentBuilder useCustomerKey(boolean useCustomerKey) {
            this.doSetProperty("useCustomerKey", useCustomerKey);
            return this;
        }

        default public Aws2S3ComponentBuilder useSSES3(boolean useSSES3) {
            this.doSetProperty("useSSES3", useSSES3);
            return this;
        }

        default public Aws2S3ComponentBuilder amazonS3Client(S3Client amazonS3Client) {
            this.doSetProperty("amazonS3Client", amazonS3Client);
            return this;
        }

        default public Aws2S3ComponentBuilder amazonS3Presigner(S3Presigner amazonS3Presigner) {
            this.doSetProperty("amazonS3Presigner", amazonS3Presigner);
            return this;
        }

        default public Aws2S3ComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public Aws2S3ComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            this.doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }

        default public Aws2S3ComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            this.doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }

        default public Aws2S3ComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Aws2S3ComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Aws2S3ComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Aws2S3ComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2S3ComponentBuilder profileCredentialsName(String profileCredentialsName) {
            this.doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }

        default public Aws2S3ComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public Aws2S3ComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Aws2S3ComponentBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public Aws2S3ComponentBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
    }
}

