/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.kinesis.Kinesis2Component;
import org.apache.camel.component.aws2.kinesis.Kinesis2Configuration;
import org.apache.camel.component.aws2.kinesis.Kinesis2ShardClosedStrategyEnum;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;

public interface Aws2KinesisComponentBuilderFactory {
    public static Aws2KinesisComponentBuilder aws2Kinesis() {
        return new Aws2KinesisComponentBuilderImpl();
    }

    public static class Aws2KinesisComponentBuilderImpl
    extends AbstractComponentBuilder<Kinesis2Component>
    implements Aws2KinesisComponentBuilder {
        @Override
        protected Kinesis2Component buildConcreteComponent() {
            return new Kinesis2Component();
        }

        private Kinesis2Configuration getOrCreateConfiguration(Kinesis2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new Kinesis2Configuration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "cborEnabled": {
                    this.getOrCreateConfiguration((Kinesis2Component)component).setCborEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((Kinesis2Component)component).setConfiguration((Kinesis2Configuration)value);
                    return true;
                }
                case "overrideEndpoint": {
                    this.getOrCreateConfiguration((Kinesis2Component)component).setOverrideEndpoint(((Boolean)value).booleanValue());
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((Kinesis2Component)component).setRegion((String)value);
                    return true;
                }
                case "uriEndpointOverride": {
                    this.getOrCreateConfiguration((Kinesis2Component)component).setUriEndpointOverride((String)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((Kinesis2Component)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "iteratorType": {
                    this.getOrCreateConfiguration((Kinesis2Component)component).setIteratorType((ShardIteratorType)value);
                    return true;
                }
                case "maxResultsPerRequest": {
                    this.getOrCreateConfiguration((Kinesis2Component)component).setMaxResultsPerRequest(((Integer)value).intValue());
                    return true;
                }
                case "sequenceNumber": {
                    this.getOrCreateConfiguration((Kinesis2Component)component).setSequenceNumber((String)value);
                    return true;
                }
                case "shardClosed": {
                    this.getOrCreateConfiguration((Kinesis2Component)component).setShardClosed((Kinesis2ShardClosedStrategyEnum)value);
                    return true;
                }
                case "shardId": {
                    this.getOrCreateConfiguration((Kinesis2Component)component).setShardId((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((Kinesis2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "amazonKinesisClient": {
                    this.getOrCreateConfiguration((Kinesis2Component)component).setAmazonKinesisClient((KinesisClient)value);
                    return true;
                }
                case "asyncClient": {
                    this.getOrCreateConfiguration((Kinesis2Component)component).setAsyncClient(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((Kinesis2Component)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckConsumerEnabled": {
                    ((Kinesis2Component)component).setHealthCheckConsumerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckProducerEnabled": {
                    ((Kinesis2Component)component).setHealthCheckProducerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((Kinesis2Component)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((Kinesis2Component)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((Kinesis2Component)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((Kinesis2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "profileCredentialsName": {
                    this.getOrCreateConfiguration((Kinesis2Component)component).setProfileCredentialsName((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((Kinesis2Component)component).setSecretKey((String)value);
                    return true;
                }
                case "sessionToken": {
                    this.getOrCreateConfiguration((Kinesis2Component)component).setSessionToken((String)value);
                    return true;
                }
                case "trustAllCertificates": {
                    this.getOrCreateConfiguration((Kinesis2Component)component).setTrustAllCertificates(((Boolean)value).booleanValue());
                    return true;
                }
                case "useDefaultCredentialsProvider": {
                    this.getOrCreateConfiguration((Kinesis2Component)component).setUseDefaultCredentialsProvider(((Boolean)value).booleanValue());
                    return true;
                }
                case "useProfileCredentialsProvider": {
                    this.getOrCreateConfiguration((Kinesis2Component)component).setUseProfileCredentialsProvider(((Boolean)value).booleanValue());
                    return true;
                }
                case "useSessionCredentials": {
                    this.getOrCreateConfiguration((Kinesis2Component)component).setUseSessionCredentials(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2KinesisComponentBuilder
    extends ComponentBuilder<Kinesis2Component> {
        default public Aws2KinesisComponentBuilder cborEnabled(boolean cborEnabled) {
            this.doSetProperty("cborEnabled", cborEnabled);
            return this;
        }

        default public Aws2KinesisComponentBuilder configuration(Kinesis2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Aws2KinesisComponentBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public Aws2KinesisComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2KinesisComponentBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public Aws2KinesisComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public Aws2KinesisComponentBuilder iteratorType(ShardIteratorType iteratorType) {
            this.doSetProperty("iteratorType", iteratorType);
            return this;
        }

        default public Aws2KinesisComponentBuilder maxResultsPerRequest(int maxResultsPerRequest) {
            this.doSetProperty("maxResultsPerRequest", maxResultsPerRequest);
            return this;
        }

        default public Aws2KinesisComponentBuilder sequenceNumber(String sequenceNumber) {
            this.doSetProperty("sequenceNumber", sequenceNumber);
            return this;
        }

        default public Aws2KinesisComponentBuilder shardClosed(Kinesis2ShardClosedStrategyEnum shardClosed) {
            this.doSetProperty("shardClosed", shardClosed);
            return this;
        }

        default public Aws2KinesisComponentBuilder shardId(String shardId) {
            this.doSetProperty("shardId", shardId);
            return this;
        }

        default public Aws2KinesisComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2KinesisComponentBuilder amazonKinesisClient(KinesisClient amazonKinesisClient) {
            this.doSetProperty("amazonKinesisClient", amazonKinesisClient);
            return this;
        }

        default public Aws2KinesisComponentBuilder asyncClient(boolean asyncClient) {
            this.doSetProperty("asyncClient", asyncClient);
            return this;
        }

        default public Aws2KinesisComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public Aws2KinesisComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            this.doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }

        default public Aws2KinesisComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            this.doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }

        default public Aws2KinesisComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Aws2KinesisComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Aws2KinesisComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Aws2KinesisComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2KinesisComponentBuilder profileCredentialsName(String profileCredentialsName) {
            this.doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }

        default public Aws2KinesisComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public Aws2KinesisComponentBuilder sessionToken(String sessionToken) {
            this.doSetProperty("sessionToken", sessionToken);
            return this;
        }

        default public Aws2KinesisComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Aws2KinesisComponentBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public Aws2KinesisComponentBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public Aws2KinesisComponentBuilder useSessionCredentials(boolean useSessionCredentials) {
            this.doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }
}

