/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpTransportType;
import com.azure.core.amqp.ProxyOptions;
import com.azure.core.credential.TokenCredential;
import com.azure.core.util.ClientOptions;
import com.azure.messaging.servicebus.ServiceBusReceiverAsyncClient;
import com.azure.messaging.servicebus.ServiceBusSenderAsyncClient;
import com.azure.messaging.servicebus.ServiceBusTransactionContext;
import com.azure.messaging.servicebus.models.ServiceBusReceiveMode;
import com.azure.messaging.servicebus.models.SubQueue;
import java.time.Duration;
import java.time.OffsetDateTime;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.azure.servicebus.CredentialType;
import org.apache.camel.component.azure.servicebus.ServiceBusComponent;
import org.apache.camel.component.azure.servicebus.ServiceBusConfiguration;
import org.apache.camel.component.azure.servicebus.ServiceBusConsumerOperationDefinition;
import org.apache.camel.component.azure.servicebus.ServiceBusProducerOperationDefinition;
import org.apache.camel.component.azure.servicebus.ServiceBusType;
import org.apache.camel.spi.HeaderFilterStrategy;

public interface AzureServicebusComponentBuilderFactory {
    public static AzureServicebusComponentBuilder azureServicebus() {
        return new AzureServicebusComponentBuilderImpl();
    }

    public static class AzureServicebusComponentBuilderImpl
    extends AbstractComponentBuilder<ServiceBusComponent>
    implements AzureServicebusComponentBuilder {
        @Override
        protected ServiceBusComponent buildConcreteComponent() {
            return new ServiceBusComponent();
        }

        private ServiceBusConfiguration getOrCreateConfiguration(ServiceBusComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new ServiceBusConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "amqpRetryOptions": {
                    this.getOrCreateConfiguration((ServiceBusComponent)component).setAmqpRetryOptions((AmqpRetryOptions)value);
                    return true;
                }
                case "amqpTransportType": {
                    this.getOrCreateConfiguration((ServiceBusComponent)component).setAmqpTransportType((AmqpTransportType)value);
                    return true;
                }
                case "clientOptions": {
                    this.getOrCreateConfiguration((ServiceBusComponent)component).setClientOptions((ClientOptions)value);
                    return true;
                }
                case "configuration": {
                    ((ServiceBusComponent)component).setConfiguration((ServiceBusConfiguration)value);
                    return true;
                }
                case "headerFilterStrategy": {
                    this.getOrCreateConfiguration((ServiceBusComponent)component).setHeaderFilterStrategy((HeaderFilterStrategy)value);
                    return true;
                }
                case "proxyOptions": {
                    this.getOrCreateConfiguration((ServiceBusComponent)component).setProxyOptions((ProxyOptions)value);
                    return true;
                }
                case "serviceBusType": {
                    this.getOrCreateConfiguration((ServiceBusComponent)component).setServiceBusType((ServiceBusType)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((ServiceBusComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "consumerOperation": {
                    this.getOrCreateConfiguration((ServiceBusComponent)component).setConsumerOperation((ServiceBusConsumerOperationDefinition)value);
                    return true;
                }
                case "disableAutoComplete": {
                    this.getOrCreateConfiguration((ServiceBusComponent)component).setDisableAutoComplete(((Boolean)value).booleanValue());
                    return true;
                }
                case "enableDeadLettering": {
                    this.getOrCreateConfiguration((ServiceBusComponent)component).setEnableDeadLettering(((Boolean)value).booleanValue());
                    return true;
                }
                case "maxAutoLockRenewDuration": {
                    this.getOrCreateConfiguration((ServiceBusComponent)component).setMaxAutoLockRenewDuration((Duration)value);
                    return true;
                }
                case "peekNumMaxMessages": {
                    this.getOrCreateConfiguration((ServiceBusComponent)component).setPeekNumMaxMessages((Integer)value);
                    return true;
                }
                case "prefetchCount": {
                    this.getOrCreateConfiguration((ServiceBusComponent)component).setPrefetchCount(((Integer)value).intValue());
                    return true;
                }
                case "receiverAsyncClient": {
                    this.getOrCreateConfiguration((ServiceBusComponent)component).setReceiverAsyncClient((ServiceBusReceiverAsyncClient)value);
                    return true;
                }
                case "serviceBusReceiveMode": {
                    this.getOrCreateConfiguration((ServiceBusComponent)component).setServiceBusReceiveMode((ServiceBusReceiveMode)value);
                    return true;
                }
                case "subQueue": {
                    this.getOrCreateConfiguration((ServiceBusComponent)component).setSubQueue((SubQueue)value);
                    return true;
                }
                case "subscriptionName": {
                    this.getOrCreateConfiguration((ServiceBusComponent)component).setSubscriptionName((String)value);
                    return true;
                }
                case "reconnectDelay": {
                    this.getOrCreateConfiguration((ServiceBusComponent)component).setReconnectDelay(((Integer)value).intValue());
                    return true;
                }
                case "binary": {
                    this.getOrCreateConfiguration((ServiceBusComponent)component).setBinary(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((ServiceBusComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "producerOperation": {
                    this.getOrCreateConfiguration((ServiceBusComponent)component).setProducerOperation((ServiceBusProducerOperationDefinition)value);
                    return true;
                }
                case "scheduledEnqueueTime": {
                    this.getOrCreateConfiguration((ServiceBusComponent)component).setScheduledEnqueueTime((OffsetDateTime)value);
                    return true;
                }
                case "senderAsyncClient": {
                    this.getOrCreateConfiguration((ServiceBusComponent)component).setSenderAsyncClient((ServiceBusSenderAsyncClient)value);
                    return true;
                }
                case "serviceBusTransactionContext": {
                    this.getOrCreateConfiguration((ServiceBusComponent)component).setServiceBusTransactionContext((ServiceBusTransactionContext)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((ServiceBusComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "connectionString": {
                    this.getOrCreateConfiguration((ServiceBusComponent)component).setConnectionString((String)value);
                    return true;
                }
                case "credentialType": {
                    this.getOrCreateConfiguration((ServiceBusComponent)component).setCredentialType((CredentialType)value);
                    return true;
                }
                case "fullyQualifiedNamespace": {
                    this.getOrCreateConfiguration((ServiceBusComponent)component).setFullyQualifiedNamespace((String)value);
                    return true;
                }
                case "tokenCredential": {
                    this.getOrCreateConfiguration((ServiceBusComponent)component).setTokenCredential((TokenCredential)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AzureServicebusComponentBuilder
    extends ComponentBuilder<ServiceBusComponent> {
        default public AzureServicebusComponentBuilder amqpRetryOptions(AmqpRetryOptions amqpRetryOptions) {
            this.doSetProperty("amqpRetryOptions", amqpRetryOptions);
            return this;
        }

        default public AzureServicebusComponentBuilder amqpTransportType(AmqpTransportType amqpTransportType) {
            this.doSetProperty("amqpTransportType", amqpTransportType);
            return this;
        }

        default public AzureServicebusComponentBuilder clientOptions(ClientOptions clientOptions) {
            this.doSetProperty("clientOptions", clientOptions);
            return this;
        }

        default public AzureServicebusComponentBuilder configuration(ServiceBusConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AzureServicebusComponentBuilder headerFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
            this.doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }

        default public AzureServicebusComponentBuilder proxyOptions(ProxyOptions proxyOptions) {
            this.doSetProperty("proxyOptions", proxyOptions);
            return this;
        }

        default public AzureServicebusComponentBuilder serviceBusType(ServiceBusType serviceBusType) {
            this.doSetProperty("serviceBusType", serviceBusType);
            return this;
        }

        default public AzureServicebusComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AzureServicebusComponentBuilder consumerOperation(ServiceBusConsumerOperationDefinition consumerOperation) {
            this.doSetProperty("consumerOperation", consumerOperation);
            return this;
        }

        default public AzureServicebusComponentBuilder disableAutoComplete(boolean disableAutoComplete) {
            this.doSetProperty("disableAutoComplete", disableAutoComplete);
            return this;
        }

        default public AzureServicebusComponentBuilder enableDeadLettering(boolean enableDeadLettering) {
            this.doSetProperty("enableDeadLettering", enableDeadLettering);
            return this;
        }

        default public AzureServicebusComponentBuilder maxAutoLockRenewDuration(Duration maxAutoLockRenewDuration) {
            this.doSetProperty("maxAutoLockRenewDuration", maxAutoLockRenewDuration);
            return this;
        }

        default public AzureServicebusComponentBuilder peekNumMaxMessages(Integer peekNumMaxMessages) {
            this.doSetProperty("peekNumMaxMessages", peekNumMaxMessages);
            return this;
        }

        default public AzureServicebusComponentBuilder prefetchCount(int prefetchCount) {
            this.doSetProperty("prefetchCount", prefetchCount);
            return this;
        }

        default public AzureServicebusComponentBuilder receiverAsyncClient(ServiceBusReceiverAsyncClient receiverAsyncClient) {
            this.doSetProperty("receiverAsyncClient", receiverAsyncClient);
            return this;
        }

        default public AzureServicebusComponentBuilder serviceBusReceiveMode(ServiceBusReceiveMode serviceBusReceiveMode) {
            this.doSetProperty("serviceBusReceiveMode", serviceBusReceiveMode);
            return this;
        }

        default public AzureServicebusComponentBuilder subQueue(SubQueue subQueue) {
            this.doSetProperty("subQueue", subQueue);
            return this;
        }

        default public AzureServicebusComponentBuilder subscriptionName(String subscriptionName) {
            this.doSetProperty("subscriptionName", subscriptionName);
            return this;
        }

        default public AzureServicebusComponentBuilder reconnectDelay(int reconnectDelay) {
            this.doSetProperty("reconnectDelay", reconnectDelay);
            return this;
        }

        default public AzureServicebusComponentBuilder binary(boolean binary) {
            this.doSetProperty("binary", binary);
            return this;
        }

        default public AzureServicebusComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AzureServicebusComponentBuilder producerOperation(ServiceBusProducerOperationDefinition producerOperation) {
            this.doSetProperty("producerOperation", producerOperation);
            return this;
        }

        default public AzureServicebusComponentBuilder scheduledEnqueueTime(OffsetDateTime scheduledEnqueueTime) {
            this.doSetProperty("scheduledEnqueueTime", scheduledEnqueueTime);
            return this;
        }

        default public AzureServicebusComponentBuilder senderAsyncClient(ServiceBusSenderAsyncClient senderAsyncClient) {
            this.doSetProperty("senderAsyncClient", senderAsyncClient);
            return this;
        }

        default public AzureServicebusComponentBuilder serviceBusTransactionContext(ServiceBusTransactionContext serviceBusTransactionContext) {
            this.doSetProperty("serviceBusTransactionContext", serviceBusTransactionContext);
            return this;
        }

        default public AzureServicebusComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public AzureServicebusComponentBuilder connectionString(String connectionString) {
            this.doSetProperty("connectionString", connectionString);
            return this;
        }

        default public AzureServicebusComponentBuilder credentialType(CredentialType credentialType) {
            this.doSetProperty("credentialType", credentialType);
            return this;
        }

        default public AzureServicebusComponentBuilder fullyQualifiedNamespace(String fullyQualifiedNamespace) {
            this.doSetProperty("fullyQualifiedNamespace", fullyQualifiedNamespace);
            return this;
        }

        default public AzureServicebusComponentBuilder tokenCredential(TokenCredential tokenCredential) {
            this.doSetProperty("tokenCredential", tokenCredential);
            return this;
        }
    }
}

