/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.pulsar.PulsarComponent;
import org.apache.camel.component.pulsar.PulsarConfiguration;
import org.apache.camel.component.pulsar.PulsarMessageReceiptFactory;
import org.apache.camel.component.pulsar.utils.AutoConfiguration;
import org.apache.camel.component.pulsar.utils.consumers.SubscriptionInitialPosition;
import org.apache.camel.component.pulsar.utils.consumers.SubscriptionType;
import org.apache.pulsar.client.api.BatcherBuilder;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.MessageRouter;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.RedeliveryBackoff;
import org.apache.pulsar.client.api.RegexSubscriptionMode;

public interface PulsarComponentBuilderFactory {
    public static PulsarComponentBuilder pulsar() {
        return new PulsarComponentBuilderImpl();
    }

    public static class PulsarComponentBuilderImpl
    extends AbstractComponentBuilder<PulsarComponent>
    implements PulsarComponentBuilder {
        @Override
        protected PulsarComponent buildConcreteComponent() {
            return new PulsarComponent();
        }

        private PulsarConfiguration getOrCreateConfiguration(PulsarComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new PulsarConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "authenticationClass": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setAuthenticationClass((String)value);
                    return true;
                }
                case "authenticationParams": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setAuthenticationParams((String)value);
                    return true;
                }
                case "configuration": {
                    ((PulsarComponent)component).setConfiguration((PulsarConfiguration)value);
                    return true;
                }
                case "serviceUrl": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setServiceUrl((String)value);
                    return true;
                }
                case "ackGroupTimeMillis": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setAckGroupTimeMillis(((Long)value).longValue());
                    return true;
                }
                case "ackTimeoutMillis": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setAckTimeoutMillis(((Long)value).longValue());
                    return true;
                }
                case "ackTimeoutRedeliveryBackoff": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setAckTimeoutRedeliveryBackoff((RedeliveryBackoff)value);
                    return true;
                }
                case "allowManualAcknowledgement": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setAllowManualAcknowledgement(((Boolean)value).booleanValue());
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((PulsarComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "consumerName": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setConsumerName((String)value);
                    return true;
                }
                case "consumerNamePrefix": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setConsumerNamePrefix((String)value);
                    return true;
                }
                case "consumerQueueSize": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setConsumerQueueSize(((Integer)value).intValue());
                    return true;
                }
                case "deadLetterTopic": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setDeadLetterTopic((String)value);
                    return true;
                }
                case "enableRetry": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setEnableRetry(((Boolean)value).booleanValue());
                    return true;
                }
                case "keySharedPolicy": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setKeySharedPolicy((String)value);
                    return true;
                }
                case "maxRedeliverCount": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setMaxRedeliverCount((Integer)value);
                    return true;
                }
                case "messageListener": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setMessageListener(((Boolean)value).booleanValue());
                    return true;
                }
                case "negativeAckRedeliveryBackoff": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setNegativeAckRedeliveryBackoff((RedeliveryBackoff)value);
                    return true;
                }
                case "negativeAckRedeliveryDelayMicros": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setNegativeAckRedeliveryDelayMicros(((Long)value).longValue());
                    return true;
                }
                case "numberOfConsumers": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setNumberOfConsumers(((Integer)value).intValue());
                    return true;
                }
                case "numberOfConsumerThreads": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setNumberOfConsumerThreads(((Integer)value).intValue());
                    return true;
                }
                case "readCompacted": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setReadCompacted(((Boolean)value).booleanValue());
                    return true;
                }
                case "retryLetterTopic": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setRetryLetterTopic((String)value);
                    return true;
                }
                case "subscriptionInitialPosition": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setSubscriptionInitialPosition((SubscriptionInitialPosition)value);
                    return true;
                }
                case "subscriptionName": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setSubscriptionName((String)value);
                    return true;
                }
                case "subscriptionTopicsMode": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setSubscriptionTopicsMode((RegexSubscriptionMode)value);
                    return true;
                }
                case "subscriptionType": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setSubscriptionType((SubscriptionType)value);
                    return true;
                }
                case "topicsPattern": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setTopicsPattern(((Boolean)value).booleanValue());
                    return true;
                }
                case "pulsarMessageReceiptFactory": {
                    ((PulsarComponent)component).setPulsarMessageReceiptFactory((PulsarMessageReceiptFactory)value);
                    return true;
                }
                case "batcherBuilder": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setBatcherBuilder((BatcherBuilder)value);
                    return true;
                }
                case "batchingEnabled": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setBatchingEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "batchingMaxMessages": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setBatchingMaxMessages(((Integer)value).intValue());
                    return true;
                }
                case "batchingMaxPublishDelayMicros": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setBatchingMaxPublishDelayMicros(((Long)value).longValue());
                    return true;
                }
                case "blockIfQueueFull": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setBlockIfQueueFull(((Boolean)value).booleanValue());
                    return true;
                }
                case "chunkingEnabled": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setChunkingEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "compressionType": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setCompressionType((CompressionType)value);
                    return true;
                }
                case "hashingScheme": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setHashingScheme((String)value);
                    return true;
                }
                case "initialSequenceId": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setInitialSequenceId(((Long)value).longValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((PulsarComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "maxPendingMessages": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setMaxPendingMessages(((Integer)value).intValue());
                    return true;
                }
                case "maxPendingMessagesAcrossPartitions": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setMaxPendingMessagesAcrossPartitions(((Integer)value).intValue());
                    return true;
                }
                case "messageRouter": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setMessageRouter((MessageRouter)value);
                    return true;
                }
                case "messageRoutingMode": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setMessageRoutingMode((MessageRoutingMode)value);
                    return true;
                }
                case "producerName": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setProducerName((String)value);
                    return true;
                }
                case "sendTimeoutMs": {
                    this.getOrCreateConfiguration((PulsarComponent)component).setSendTimeoutMs(((Integer)value).intValue());
                    return true;
                }
                case "autoConfiguration": {
                    ((PulsarComponent)component).setAutoConfiguration((AutoConfiguration)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((PulsarComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "pulsarClient": {
                    ((PulsarComponent)component).setPulsarClient((PulsarClient)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface PulsarComponentBuilder
    extends ComponentBuilder<PulsarComponent> {
        default public PulsarComponentBuilder authenticationClass(String authenticationClass) {
            this.doSetProperty("authenticationClass", authenticationClass);
            return this;
        }

        default public PulsarComponentBuilder authenticationParams(String authenticationParams) {
            this.doSetProperty("authenticationParams", authenticationParams);
            return this;
        }

        default public PulsarComponentBuilder configuration(PulsarConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public PulsarComponentBuilder serviceUrl(String serviceUrl) {
            this.doSetProperty("serviceUrl", serviceUrl);
            return this;
        }

        default public PulsarComponentBuilder ackGroupTimeMillis(long ackGroupTimeMillis) {
            this.doSetProperty("ackGroupTimeMillis", ackGroupTimeMillis);
            return this;
        }

        default public PulsarComponentBuilder ackTimeoutMillis(long ackTimeoutMillis) {
            this.doSetProperty("ackTimeoutMillis", ackTimeoutMillis);
            return this;
        }

        default public PulsarComponentBuilder ackTimeoutRedeliveryBackoff(RedeliveryBackoff ackTimeoutRedeliveryBackoff) {
            this.doSetProperty("ackTimeoutRedeliveryBackoff", ackTimeoutRedeliveryBackoff);
            return this;
        }

        default public PulsarComponentBuilder allowManualAcknowledgement(boolean allowManualAcknowledgement) {
            this.doSetProperty("allowManualAcknowledgement", allowManualAcknowledgement);
            return this;
        }

        default public PulsarComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public PulsarComponentBuilder consumerName(String consumerName) {
            this.doSetProperty("consumerName", consumerName);
            return this;
        }

        default public PulsarComponentBuilder consumerNamePrefix(String consumerNamePrefix) {
            this.doSetProperty("consumerNamePrefix", consumerNamePrefix);
            return this;
        }

        default public PulsarComponentBuilder consumerQueueSize(int consumerQueueSize) {
            this.doSetProperty("consumerQueueSize", consumerQueueSize);
            return this;
        }

        default public PulsarComponentBuilder deadLetterTopic(String deadLetterTopic) {
            this.doSetProperty("deadLetterTopic", deadLetterTopic);
            return this;
        }

        default public PulsarComponentBuilder enableRetry(boolean enableRetry) {
            this.doSetProperty("enableRetry", enableRetry);
            return this;
        }

        default public PulsarComponentBuilder keySharedPolicy(String keySharedPolicy) {
            this.doSetProperty("keySharedPolicy", keySharedPolicy);
            return this;
        }

        default public PulsarComponentBuilder maxRedeliverCount(Integer maxRedeliverCount) {
            this.doSetProperty("maxRedeliverCount", maxRedeliverCount);
            return this;
        }

        default public PulsarComponentBuilder messageListener(boolean messageListener) {
            this.doSetProperty("messageListener", messageListener);
            return this;
        }

        default public PulsarComponentBuilder negativeAckRedeliveryBackoff(RedeliveryBackoff negativeAckRedeliveryBackoff) {
            this.doSetProperty("negativeAckRedeliveryBackoff", negativeAckRedeliveryBackoff);
            return this;
        }

        default public PulsarComponentBuilder negativeAckRedeliveryDelayMicros(long negativeAckRedeliveryDelayMicros) {
            this.doSetProperty("negativeAckRedeliveryDelayMicros", negativeAckRedeliveryDelayMicros);
            return this;
        }

        default public PulsarComponentBuilder numberOfConsumers(int numberOfConsumers) {
            this.doSetProperty("numberOfConsumers", numberOfConsumers);
            return this;
        }

        default public PulsarComponentBuilder numberOfConsumerThreads(int numberOfConsumerThreads) {
            this.doSetProperty("numberOfConsumerThreads", numberOfConsumerThreads);
            return this;
        }

        default public PulsarComponentBuilder readCompacted(boolean readCompacted) {
            this.doSetProperty("readCompacted", readCompacted);
            return this;
        }

        default public PulsarComponentBuilder retryLetterTopic(String retryLetterTopic) {
            this.doSetProperty("retryLetterTopic", retryLetterTopic);
            return this;
        }

        default public PulsarComponentBuilder subscriptionInitialPosition(SubscriptionInitialPosition subscriptionInitialPosition) {
            this.doSetProperty("subscriptionInitialPosition", subscriptionInitialPosition);
            return this;
        }

        default public PulsarComponentBuilder subscriptionName(String subscriptionName) {
            this.doSetProperty("subscriptionName", subscriptionName);
            return this;
        }

        default public PulsarComponentBuilder subscriptionTopicsMode(RegexSubscriptionMode subscriptionTopicsMode) {
            this.doSetProperty("subscriptionTopicsMode", subscriptionTopicsMode);
            return this;
        }

        default public PulsarComponentBuilder subscriptionType(SubscriptionType subscriptionType) {
            this.doSetProperty("subscriptionType", subscriptionType);
            return this;
        }

        default public PulsarComponentBuilder topicsPattern(boolean topicsPattern) {
            this.doSetProperty("topicsPattern", topicsPattern);
            return this;
        }

        default public PulsarComponentBuilder pulsarMessageReceiptFactory(PulsarMessageReceiptFactory pulsarMessageReceiptFactory) {
            this.doSetProperty("pulsarMessageReceiptFactory", pulsarMessageReceiptFactory);
            return this;
        }

        default public PulsarComponentBuilder batcherBuilder(BatcherBuilder batcherBuilder) {
            this.doSetProperty("batcherBuilder", batcherBuilder);
            return this;
        }

        default public PulsarComponentBuilder batchingEnabled(boolean batchingEnabled) {
            this.doSetProperty("batchingEnabled", batchingEnabled);
            return this;
        }

        default public PulsarComponentBuilder batchingMaxMessages(int batchingMaxMessages) {
            this.doSetProperty("batchingMaxMessages", batchingMaxMessages);
            return this;
        }

        default public PulsarComponentBuilder batchingMaxPublishDelayMicros(long batchingMaxPublishDelayMicros) {
            this.doSetProperty("batchingMaxPublishDelayMicros", batchingMaxPublishDelayMicros);
            return this;
        }

        default public PulsarComponentBuilder blockIfQueueFull(boolean blockIfQueueFull) {
            this.doSetProperty("blockIfQueueFull", blockIfQueueFull);
            return this;
        }

        default public PulsarComponentBuilder chunkingEnabled(boolean chunkingEnabled) {
            this.doSetProperty("chunkingEnabled", chunkingEnabled);
            return this;
        }

        default public PulsarComponentBuilder compressionType(CompressionType compressionType) {
            this.doSetProperty("compressionType", compressionType);
            return this;
        }

        default public PulsarComponentBuilder hashingScheme(String hashingScheme) {
            this.doSetProperty("hashingScheme", hashingScheme);
            return this;
        }

        default public PulsarComponentBuilder initialSequenceId(long initialSequenceId) {
            this.doSetProperty("initialSequenceId", initialSequenceId);
            return this;
        }

        default public PulsarComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public PulsarComponentBuilder maxPendingMessages(int maxPendingMessages) {
            this.doSetProperty("maxPendingMessages", maxPendingMessages);
            return this;
        }

        @Deprecated
        default public PulsarComponentBuilder maxPendingMessagesAcrossPartitions(int maxPendingMessagesAcrossPartitions) {
            this.doSetProperty("maxPendingMessagesAcrossPartitions", maxPendingMessagesAcrossPartitions);
            return this;
        }

        default public PulsarComponentBuilder messageRouter(MessageRouter messageRouter) {
            this.doSetProperty("messageRouter", messageRouter);
            return this;
        }

        default public PulsarComponentBuilder messageRoutingMode(MessageRoutingMode messageRoutingMode) {
            this.doSetProperty("messageRoutingMode", messageRoutingMode);
            return this;
        }

        default public PulsarComponentBuilder producerName(String producerName) {
            this.doSetProperty("producerName", producerName);
            return this;
        }

        default public PulsarComponentBuilder sendTimeoutMs(int sendTimeoutMs) {
            this.doSetProperty("sendTimeoutMs", sendTimeoutMs);
            return this;
        }

        default public PulsarComponentBuilder autoConfiguration(AutoConfiguration autoConfiguration) {
            this.doSetProperty("autoConfiguration", autoConfiguration);
            return this;
        }

        default public PulsarComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public PulsarComponentBuilder pulsarClient(PulsarClient pulsarClient) {
            this.doSetProperty("pulsarClient", pulsarClient);
            return this;
        }
    }
}

