/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.connector;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.util.ServiceHelper;

public class ConnectorConsumerProcessor
extends DelegateAsyncProcessor {
    private final Processor beforeConsumer;
    private final Processor afterConsumer;

    public ConnectorConsumerProcessor(Processor processor, Processor beforeConsumer, Processor afterConsumer) {
        super(processor);
        this.beforeConsumer = beforeConsumer;
        this.afterConsumer = afterConsumer;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        AsyncCallback delegate = doneSync -> {
            if (this.afterConsumer != null) {
                try {
                    this.afterConsumer.process(exchange);
                }
                catch (Throwable e) {
                    exchange.setException(e);
                }
            }
            callback.done(doneSync);
        };
        if (this.beforeConsumer != null) {
            try {
                this.beforeConsumer.process(exchange);
            }
            catch (Throwable e) {
                exchange.setException(e);
                callback.done(true);
                return true;
            }
        }
        return super.process(exchange, delegate);
    }

    protected void doStart() throws Exception {
        ServiceHelper.startServices((Object[])new Object[]{this.beforeConsumer, this.processor, this.afterConsumer});
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopServices((Object[])new Object[]{this.beforeConsumer, this.processor, this.afterConsumer});
    }

    protected void doSuspend() throws Exception {
        ServiceHelper.suspendService((Object)this.processor);
    }

    protected void doResume() throws Exception {
        ServiceHelper.resumeService((Object)this.processor);
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.beforeConsumer, this.processor, this.afterConsumer});
    }
}

