/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.connector;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.DelegateEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.connector.ConnectorComponent;
import org.apache.camel.component.connector.ConnectorConsumerProcessor;
import org.apache.camel.component.connector.ConnectorProducer;
import org.apache.camel.component.connector.DataType;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.util.ServiceHelper;

@ManagedResource(description="Managed Connector Endpoint")
public class DefaultConnectorEndpoint
extends DefaultEndpoint
implements DelegateEndpoint {
    private final Endpoint endpoint;
    private final DataType inputDataType;
    private final DataType outputDataType;

    public DefaultConnectorEndpoint(String endpointUri, ConnectorComponent component, Endpoint endpoint, DataType inputDataType, DataType outputDataType) {
        super(endpointUri, (Component)component);
        this.endpoint = endpoint;
        this.inputDataType = inputDataType;
        this.outputDataType = outputDataType;
    }

    public Producer createProducer() throws Exception {
        Producer producer = this.endpoint.createProducer();
        return new ConnectorProducer(this.endpoint, producer, this.getComponent().getBeforeProducer(), this.getComponent().getAfterProducer());
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ConnectorConsumerProcessor delegate = new ConnectorConsumerProcessor(processor, this.getComponent().getBeforeConsumer(), this.getComponent().getAfterConsumer());
        Consumer consumer = this.endpoint.createConsumer((Processor)delegate);
        this.configureConsumer(consumer);
        return consumer;
    }

    public ConnectorComponent getComponent() {
        return (ConnectorComponent)super.getComponent();
    }

    public boolean isSingleton() {
        return true;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @ManagedAttribute(description="Delegate Endpoint URI", mask=true)
    public String getDelegateEndpointUri() {
        return this.endpoint.getEndpointUri();
    }

    @ManagedAttribute(description="Input data type")
    public DataType getInputDataType() {
        return this.inputDataType;
    }

    @ManagedAttribute(description="Output data type")
    public DataType getOutputDataType() {
        return this.outputDataType;
    }

    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService((Service)this.endpoint);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.endpoint);
        super.doStop();
    }
}

