/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.connector;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ComponentVerifier;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.TypeConverter;
import org.apache.camel.VerifiableComponent;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.component.connector.ConnectorComponent;
import org.apache.camel.component.connector.ConnectorModel;
import org.apache.camel.component.connector.DefaultConnectorEndpoint;
import org.apache.camel.component.connector.SchedulerTimerConnectorEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.verifier.ResultBuilder;
import org.apache.camel.impl.verifier.ResultErrorBuilder;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultConnectorComponent
extends DefaultComponent
implements ConnectorComponent,
VerifiableComponent {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CamelCatalog catalog = new DefaultCamelCatalog(false);
    private final String componentName;
    private final ConnectorModel model;
    private Map<String, Object> componentOptions;
    private Processor beforeProducer;
    private Processor afterProducer;
    private Processor beforeConsumer;
    private Processor afterConsumer;

    protected DefaultConnectorComponent(String componentName, String className) {
        this.componentName = componentName;
        this.model = new ConnectorModel(componentName, className);
        this.catalog.addComponent(componentName, className);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        DefaultConnectorEndpoint answer;
        int before = parameters.size();
        Map<String, Object> schedulerOptions = this.extractSchedulerOptions(parameters);
        int after = parameters.size();
        if (schedulerOptions != null && before != after) {
            URI u = new URI(uri);
            u = URISupport.createRemainingURI((URI)u, parameters);
            uri = u.toString();
        }
        Map<String, String> options = this.buildEndpointOptions(remaining, parameters);
        String scheme = this.model.getBaseScheme();
        this.createNewBaseComponent(scheme);
        String delegateUri = this.createEndpointUri(scheme, options);
        Endpoint delegate = this.getCamelContext().getEndpoint(delegateUri);
        if (this.log.isInfoEnabled()) {
            this.log.info("Connector resolved: {} -> {}", (Object)URISupport.sanitizeUri((String)uri), (Object)URISupport.sanitizeUri((String)delegateUri));
        }
        if ("timer".equals(this.model.getScheduler())) {
            SchedulerTimerConnectorEndpoint endpoint = new SchedulerTimerConnectorEndpoint(uri, this, delegate, this.model.getInputDataType(), this.model.getOutputDataType());
            this.setProperties((Object)endpoint, schedulerOptions);
            answer = endpoint;
        } else {
            answer = new DefaultConnectorEndpoint(uri, this, delegate, this.model.getInputDataType(), this.model.getOutputDataType());
        }
        parameters.clear();
        return answer;
    }

    @Override
    public String createEndpointUri(String scheme, Map<String, String> options) throws URISyntaxException {
        this.log.trace("Creating endpoint uri with scheme: {}", (Object)scheme);
        return this.catalog.asEndpointUri(scheme, options, false);
    }

    @Override
    public void addConnectorOption(Map<String, String> options, String name, String value) {
        this.log.trace("Adding option: {}={}", (Object)name, (Object)value);
        options.put(name, value);
    }

    @Override
    public CamelCatalog getCamelCatalog() {
        return this.catalog;
    }

    @Override
    public String getCamelConnectorJSon() {
        return this.model.getConnectorJSon();
    }

    @Override
    public String getConnectorName() {
        return this.model.getConnectorName();
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public Map<String, Object> getComponentOptions() {
        return this.componentOptions;
    }

    @Override
    public void setComponentOptions(Map<String, Object> baseComponentOptions) {
        this.componentOptions = baseComponentOptions;
    }

    public ComponentVerifier getVerifier() {
        String scheme = this.model.getBaseScheme();
        Component component = this.getCamelContext().getComponent(scheme, true, false);
        if (component instanceof VerifiableComponent) {
            return (scope, map) -> {
                Map<String, String> options;
                try {
                    options = this.buildEndpointOptions(null, map);
                }
                catch (URISyntaxException e) {
                    return ResultBuilder.withStatusAndScope((ComponentVerifier.Result.Status)ComponentVerifier.Result.Status.OK, (ComponentVerifier.Scope)scope).error(ResultErrorBuilder.withException((Exception)e).build()).build();
                }
                return ((VerifiableComponent)component).getVerifier().verify(scope, options);
            };
        }
        return (scope, map) -> ResultBuilder.withStatusAndScope((ComponentVerifier.Result.Status)ComponentVerifier.Result.Status.UNSUPPORTED, (ComponentVerifier.Scope)scope).error(ResultErrorBuilder.withCode((ComponentVerifier.VerificationError.Code)ComponentVerifier.VerificationError.StandardCode.UNSUPPORTED).detail("camel_connector_name", (Object)this.getConnectorName()).detail("camel_component_name", (Object)this.getComponentName()).build()).build();
    }

    protected void doStart() throws Exception {
        if (this.model.getInputDataType() == null) {
            throw new IllegalArgumentException("Camel connector must have inputDataType defined in camel-connector.json file");
        }
        if (this.model.getOutputDataType() == null) {
            throw new IllegalArgumentException("Camel connector must have outputDataType defined in camel-connector.json file");
        }
        if (this.model.getBaseScheme() == null) {
            throw new IllegalArgumentException("Camel connector must have baseSchema defined in camel-connector.json file");
        }
        if (this.model.getBaseJavaType() == null) {
            throw new IllegalArgumentException("Camel connector must have baseJavaType defined in camel-connector.json file");
        }
        String scheme = this.model.getBaseScheme();
        if (!this.catalog.findComponentNames().contains(scheme)) {
            String javaType = this.model.getBaseJavaType();
            this.catalog.addComponent(scheme, javaType);
        }
        this.log.debug("Starting connector: {}", (Object)this.componentName);
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.log.debug("Stopping connector: {}", (Object)this.componentName);
        super.doStop();
    }

    @Override
    public Processor getBeforeProducer() {
        return this.beforeProducer;
    }

    @Override
    public void setBeforeProducer(Processor beforeProducer) {
        this.beforeProducer = beforeProducer;
    }

    @Override
    public Processor getAfterProducer() {
        return this.afterProducer;
    }

    @Override
    public void setAfterProducer(Processor afterProducer) {
        this.afterProducer = afterProducer;
    }

    @Override
    public Processor getBeforeConsumer() {
        return this.beforeConsumer;
    }

    @Override
    public void setBeforeConsumer(Processor beforeConsumer) {
        this.beforeConsumer = beforeConsumer;
    }

    @Override
    public Processor getAfterConsumer() {
        return this.afterConsumer;
    }

    @Override
    public void setAfterConsumer(Processor afterConsumer) {
        this.afterConsumer = afterConsumer;
    }

    private Component createNewBaseComponent(String scheme) throws Exception {
        Class<?> type;
        Constructor ctr;
        String baseClassName = this.model.getBaseJavaType();
        if (baseClassName != null && (ctr = DefaultConnectorComponent.getPublicDefaultConstructor(type = Class.forName(baseClassName))) != null) {
            LinkedHashMap<Object, Object> copy;
            Object base = ctr.newInstance(new Object[0]);
            Map<String, String> defaultOptions = this.model.getDefaultComponentOptions();
            if (!defaultOptions.isEmpty()) {
                copy = new LinkedHashMap();
                for (Map.Entry<String, String> entry : defaultOptions.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (value == null) continue;
                    value = this.getCamelContext().resolvePropertyPlaceholders(value);
                    this.log.debug("Using component option: {}={}", (Object)key, (Object)value);
                    copy.put(key, value);
                }
                IntrospectionSupport.setProperties((CamelContext)this.getCamelContext(), (TypeConverter)this.getCamelContext().getTypeConverter(), base, copy);
            }
            if (this.componentOptions != null && !this.componentOptions.isEmpty()) {
                copy = new LinkedHashMap<String, Object>(this.componentOptions);
                IntrospectionSupport.setProperties((CamelContext)this.getCamelContext(), (TypeConverter)this.getCamelContext().getTypeConverter(), base, copy);
            }
            if (base instanceof Component) {
                this.getCamelContext().removeComponent(scheme);
                this.getCamelContext().addService(base, true, true);
                this.getCamelContext().addComponent(scheme, (Component)base);
                return (Component)base;
            }
        }
        return null;
    }

    private Map<String, Object> extractSchedulerOptions(Map<String, Object> parameters) {
        if (this.model.getScheduler() != null) {
            LinkedHashMap<String, Object> answer = new LinkedHashMap<String, Object>();
            this.model.getDefaultEndpointOptions().forEach((key, value) -> {
                String schedulerKey = DefaultConnectorComponent.asSchedulerKey(key);
                if (schedulerKey != null) {
                    answer.put(schedulerKey, value);
                }
            });
            Iterator<Map.Entry<String, Object>> it = parameters.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                String schedulerKey = DefaultConnectorComponent.asSchedulerKey(entry.getKey());
                if (schedulerKey == null) continue;
                Object value2 = entry.getValue();
                answer.put(schedulerKey, value2);
                it.remove();
            }
            return answer;
        }
        return null;
    }

    private static String asSchedulerKey(String key) {
        if (key.startsWith("scheduler")) {
            String name = key.substring(9);
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            return name;
        }
        return null;
    }

    private Map<String, String> buildEndpointOptions(String remaining, Map<String, Object> parameters) throws URISyntaxException {
        String targetUri;
        Map extra;
        String scheme = this.model.getBaseScheme();
        Map<String, String> defaultOptions = this.model.getDefaultEndpointOptions();
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        if (!defaultOptions.isEmpty()) {
            defaultOptions.forEach((key, value) -> {
                if (this.isValidConnectionOption((String)key, (String)value)) {
                    this.addConnectorOption((Map<String, String>)options, (String)key, (String)value);
                }
            });
        }
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String key2 = entry.getKey();
            String value2 = null;
            if (entry.getValue() != null) {
                value2 = entry.getValue().toString();
            }
            if (!this.isValidConnectionOption(key2, value2)) continue;
            this.addConnectorOption(options, key2, value2);
        }
        if (remaining != null && (extra = this.catalog.endpointProperties(targetUri = scheme + ":" + remaining)) != null && !extra.isEmpty()) {
            extra.forEach((key, value) -> {
                if (this.isValidConnectionOption((String)key, (String)value)) {
                    this.addConnectorOption((Map<String, String>)options, (String)key, (String)value);
                }
            });
        }
        return options;
    }

    private boolean isValidConnectionOption(String key, String value) {
        return this.model.getScheduler() == null || DefaultConnectorComponent.asSchedulerKey(key) == null;
    }

    private static Constructor getPublicDefaultConstructor(Class<?> clazz) {
        for (Constructor<?> ctr : clazz.getConstructors()) {
            if (!Modifier.isPublic(ctr.getModifiers()) || ctr.getParameterCount() != 0) continue;
            return ctr;
        }
        return null;
    }
}

