/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.connector;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.camel.component.connector.DataType;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.function.Suppliers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConnectorModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectorModel.class);
    private static final Pattern NAME_PATTERN = Pattern.compile("\"name\"\\s?:\\s?\"([\\w|.-]+)\".*");
    private static final Pattern JAVA_TYPE_PATTERN = Pattern.compile("\"javaType\"\\s?:\\s?\"([\\w|.]+)\".*");
    private static final Pattern BASE_JAVA_TYPE_PATTERN = Pattern.compile("\"baseJavaType\"\\s?:\\s?\"([\\w|.]+)\".*");
    private static final Pattern BASE_SCHEME_PATTERN = Pattern.compile("\"baseScheme\"\\s?:\\s?\"([\\w|.-]+)\".*");
    private static final Pattern SCHEDULER_PATTERN = Pattern.compile("\"scheduler\"\\s?:\\s?\"([\\w|.-]+)\".*");
    private static final Pattern INPUT_DATA_TYPE_PATTERN = Pattern.compile("\"inputDataType\"\\s?:\\s?\"(\\*|[\\w|.:*]+)\".*");
    private static final Pattern OUTPUT_DATA_TYPE_PATTERN = Pattern.compile("\"outputDataType\"\\s?:\\s?\"([\\w|.:*]+)\".*");
    private final String componentName;
    private final String className;
    private final Supplier<List<String>> lines;
    private String baseScheme;
    private String baseJavaType;
    private String scheduler;
    private String connectorJSon;
    private String connectorName;
    private DataType inputDataType;
    private DataType outputDataType;
    private Map<String, String> defaultComponentOptions;
    private Map<String, String> defaultEndpointOptions;

    ConnectorModel(String componentName, Class<?> componentClass) {
        this.componentName = componentName;
        this.className = componentClass.getName();
        this.lines = Suppliers.memorize(() -> this.findCamelConnectorJSonSchema(componentClass));
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getBaseScheme() {
        if (this.baseScheme == null) {
            this.baseScheme = ConnectorModel.extractBaseScheme(this.lines.get());
        }
        return this.baseScheme;
    }

    public String getBaseJavaType() {
        if (this.baseJavaType == null) {
            this.baseJavaType = ConnectorModel.extractBaseJavaType(this.lines.get());
        }
        return this.baseJavaType;
    }

    public String getScheduler() {
        if (this.scheduler == null) {
            this.scheduler = ConnectorModel.extractScheduler(this.lines.get());
        }
        return this.scheduler;
    }

    public String getConnectorName() {
        if (this.connectorName == null) {
            this.connectorName = ConnectorModel.extractName(this.lines.get());
        }
        return this.connectorName;
    }

    public String getConnectorJSon() {
        if (this.connectorJSon == null) {
            this.connectorJSon = this.lines.get().stream().collect(Collectors.joining("\n"));
        }
        return this.connectorJSon;
    }

    public Map<String, String> getDefaultComponentOptions() {
        if (this.defaultComponentOptions == null) {
            this.defaultComponentOptions = Collections.unmodifiableMap(this.extractComponentDefaultValues(this.lines.get()));
        }
        return this.defaultComponentOptions;
    }

    public Map<String, String> getDefaultEndpointOptions() {
        if (this.defaultEndpointOptions == null) {
            this.defaultEndpointOptions = Collections.unmodifiableMap(this.extractEndpointDefaultValues(this.lines.get()));
        }
        return this.defaultEndpointOptions;
    }

    public DataType getInputDataType() {
        String line;
        if (this.inputDataType == null && (line = ConnectorModel.extractInputDataType(this.lines.get())) != null) {
            this.inputDataType = new DataType(line);
        }
        return this.inputDataType;
    }

    public DataType getOutputDataType() {
        String line;
        if (this.outputDataType == null && (line = ConnectorModel.extractOutputDataType(this.lines.get())) != null) {
            this.outputDataType = new DataType(line);
        }
        return this.outputDataType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> findCamelConnectorJSonSchema(Class<?> componentClass) {
        Enumeration<URL> urls;
        LOGGER.debug("Finding camel-connector.json in classpath for connector: {}", (Object)this.componentName);
        try {
            urls = componentClass.getClassLoader().getResources("camel-connector.json");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot open camel-connector.json in classpath for connector " + this.componentName);
        }
        while (urls.hasMoreElements()) {
            try {
                InputStream is = urls.nextElement().openStream();
                Throwable throwable = null;
                try {
                    List<String> lines = ConnectorModel.loadFile(is);
                    String javaType = ConnectorModel.extractJavaType(lines);
                    LOGGER.debug("Found camel-connector.json in classpath with javaType: {}", (Object)javaType);
                    if (!this.className.equals(javaType)) continue;
                    List<String> list = lines;
                    return list;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot read camel-connector.json in classpath for connector " + this.componentName);
            }
        }
        return Collections.emptyList();
    }

    private static List<String> loadFile(InputStream fis) throws Exception {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(fis));
        do {
            if ((line = reader.readLine()) == null) continue;
            lines.add(line);
        } while (line != null);
        reader.close();
        return lines;
    }

    private static String extractName(List<String> json) {
        for (String line : json) {
            Matcher matcher = NAME_PATTERN.matcher(line = line.trim());
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return null;
    }

    private static String extractJavaType(List<String> json) {
        for (String line : json) {
            Matcher matcher = JAVA_TYPE_PATTERN.matcher(line = line.trim());
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return null;
    }

    private static String extractBaseJavaType(List<String> json) {
        for (String line : json) {
            Matcher matcher = BASE_JAVA_TYPE_PATTERN.matcher(line = line.trim());
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return null;
    }

    private static String extractScheduler(List<String> json) {
        for (String line : json) {
            Matcher matcher = SCHEDULER_PATTERN.matcher(line = line.trim());
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return null;
    }

    private static String extractBaseScheme(List<String> json) {
        for (String line : json) {
            Matcher matcher = BASE_SCHEME_PATTERN.matcher(line = line.trim());
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return null;
    }

    private static String extractInputDataType(List<String> json) {
        for (String line : json) {
            Matcher matcher = INPUT_DATA_TYPE_PATTERN.matcher(line = line.trim());
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return null;
    }

    private static String extractOutputDataType(List<String> json) {
        for (String line : json) {
            Matcher matcher = OUTPUT_DATA_TYPE_PATTERN.matcher(line = line.trim());
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return null;
    }

    private Map<String, String> extractComponentDefaultValues(List<String> lines) {
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        boolean found = false;
        for (String line : lines) {
            if ((line = line.trim()).startsWith("\"componentValues\"")) {
                found = true;
                continue;
            }
            if (line.startsWith("}")) {
                found = false;
                continue;
            }
            if (!found) continue;
            int pos = line.indexOf(58);
            String key = line.substring(0, pos);
            String value = line.substring(pos + 1);
            value = value.trim();
            key = key.trim();
            if (value.endsWith(",")) {
                value = value.substring(0, value.length() - 1);
            }
            key = StringHelper.removeLeadingAndEndingQuotes((String)key);
            value = StringHelper.removeLeadingAndEndingQuotes((String)value);
            answer.put(key, value);
        }
        return answer;
    }

    private Map<String, String> extractEndpointDefaultValues(List<String> lines) {
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        boolean found = false;
        for (String line : lines) {
            if ((line = line.trim()).startsWith("\"endpointValues\"")) {
                found = true;
                continue;
            }
            if (line.startsWith("}")) {
                found = false;
                continue;
            }
            if (!found) continue;
            int pos = line.indexOf(58);
            String key = line.substring(0, pos);
            String value = line.substring(pos + 1);
            value = value.trim();
            key = key.trim();
            if (value.endsWith(",")) {
                value = value.substring(0, value.length() - 1);
            }
            key = StringHelper.removeLeadingAndEndingQuotes((String)key);
            value = StringHelper.removeLeadingAndEndingQuotes((String)value);
            answer.put(key, value);
        }
        return answer;
    }
}

